/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowSession;

public class MockFlowSession
implements FlowSession {
    private static final String FLOW_VIEW_MAP_ATTRIBUTE = "flowViewMap";
    private Flow definition;
    private State state;
    private MutableAttributeMap scope = new LocalAttributeMap();
    private FlowSession parent;

    public MockFlowSession() {
        this.setDefinition(new Flow("mockFlow"));
        TransitionableState state = new TransitionableState(this.definition, "mockState"){

            protected void doEnter(RequestControlContext context) throws FlowExecutionException {
            }
        };
        this.setState(state);
    }

    public MockFlowSession(Flow flow) {
        this.setDefinition(flow);
    }

    public MockFlowSession(Flow flow, AttributeMap input) {
        this.setDefinition(flow);
        this.scope.putAll(input);
    }

    public FlowDefinition getDefinition() {
        return this.definition;
    }

    public StateDefinition getState() {
        return this.state;
    }

    public MutableAttributeMap getScope() {
        return this.scope;
    }

    public MutableAttributeMap getViewScope() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException("The current state of this flow '" + this.definition.getId() + "' is [null] - cannot access view scope");
        }
        if (!this.state.isViewState()) {
            throw new IllegalStateException("The current state '" + this.state.getId() + "' of this flow '" + this.definition.getId() + "' is not a view state - view scope not accessible");
        }
        return (MutableAttributeMap)this.scope.get(FLOW_VIEW_MAP_ATTRIBUTE);
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setDefinition(Flow flow) {
        this.definition = flow;
    }

    public void setState(State state) {
        if (this.state != null && this.state.isViewState()) {
            this.destroyViewScope();
        }
        this.state = state;
        if (this.state != null && this.state.isViewState()) {
            this.initViewScope();
        }
    }

    public void setScope(MutableAttributeMap scope) {
        this.scope = scope;
    }

    public void setParent(FlowSession parent) {
        this.parent = parent;
    }

    public Flow getDefinitionInternal() {
        return this.definition;
    }

    public State getStateInternal() {
        return this.state;
    }

    private void initViewScope() {
        this.scope.put(FLOW_VIEW_MAP_ATTRIBUTE, new LocalAttributeMap());
    }

    private void destroyViewScope() {
        this.scope.remove(FLOW_VIEW_MAP_ATTRIBUTE);
    }
}

