/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class SecurityRule {
    public static final String SECURITY_ATTRIBUTE_NAME = "secured";
    public static final short COMPARISON_ANY = 1;
    public static final short COMPARISON_ALL = 2;
    private Collection attributes;
    private short comparisonType = 1;

    public static String securityAttributesToCommaDelimitedList(Collection attributes) {
        StringBuffer attrs = new StringBuffer();
        Iterator attributeIt = attributes.iterator();
        while (attributeIt.hasNext()) {
            if (attrs.length() != 0) {
                attrs.append(", ");
            }
            attrs.append(attributeIt.next());
        }
        return attrs.toString();
    }

    public static Collection commaDelimitedListToSecurityAttributes(String attributes) {
        HashSet<String> attrs = new HashSet<String>();
        Iterator<String> attributeIt = Arrays.asList(attributes.split(",")).iterator();
        while (attributeIt.hasNext()) {
            String attribute = attributeIt.next().trim();
            if ("".equals(attribute)) continue;
            attrs.add(attribute);
        }
        return attrs;
    }

    public Collection getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection attributes) {
        this.attributes = attributes;
    }

    public short getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(short comparisonType) {
        this.comparisonType = comparisonType;
    }
}

