/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;

class FlowExecutionListeners {
    private FlowExecutionListener[] EMPTY_LISTENER_ARRAY = new FlowExecutionListener[0];
    private FlowExecutionListener[] listeners;

    public FlowExecutionListeners() {
        this(null);
    }

    public FlowExecutionListeners(FlowExecutionListener[] listeners) {
        this.listeners = listeners != null ? listeners : this.EMPTY_LISTENER_ARRAY;
    }

    public FlowExecutionListener[] getArray() {
        return this.listeners;
    }

    public int size() {
        return this.listeners.length;
    }

    public void fireRequestSubmitted(RequestContext context) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].requestSubmitted(context);
            ++i;
        }
    }

    public void fireRequestProcessed(RequestContext context) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].requestProcessed(context);
            ++i;
        }
    }

    public void fireSessionCreating(RequestContext context, FlowDefinition flow) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].sessionCreating(context, flow);
            ++i;
        }
    }

    public void fireSessionStarting(RequestContext context, FlowSession session, MutableAttributeMap input) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].sessionStarting(context, session, input);
            ++i;
        }
    }

    public void fireSessionStarted(RequestContext context, FlowSession session) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].sessionStarted(context, session);
            ++i;
        }
    }

    public void fireEventSignaled(RequestContext context, Event event) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].eventSignaled(context, event);
            ++i;
        }
    }

    public void fireStateEntering(RequestContext context, StateDefinition nextState) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].stateEntering(context, nextState);
            ++i;
        }
    }

    public void fireStateEntered(RequestContext context, StateDefinition previousState) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].stateEntered(context, previousState, context.getCurrentState());
            ++i;
        }
    }

    public void fireViewRendering(RequestContext context, View view) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].viewRendering(context, view, context.getCurrentState());
            ++i;
        }
    }

    public void fireViewRendered(RequestContext context, View view) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].viewRendered(context, view, context.getCurrentState());
            ++i;
        }
    }

    public void fireTransitionExecuting(RequestContext context, TransitionDefinition transition) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].transitionExecuting(context, transition);
            ++i;
        }
    }

    public void firePaused(RequestContext context) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].paused(context);
            ++i;
        }
    }

    public void fireResuming(RequestContext context) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].resuming(context);
            ++i;
        }
    }

    public void fireSessionEnding(RequestContext context, FlowSession session, String outcomeId, MutableAttributeMap output) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].sessionEnding(context, session, outcomeId, output);
            ++i;
        }
    }

    public void fireSessionEnded(RequestContext context, FlowSession session, String outcomeId, AttributeMap output) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].sessionEnded(context, session, outcomeId, output);
            ++i;
        }
    }

    public void fireExceptionThrown(RequestContext context, FlowExecutionException exception) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].exceptionThrown(context, exception);
            ++i;
        }
    }
}

