/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.execution.RequestContext;

public class TransitionSet {
    private List transitions = new LinkedList();

    public boolean add(Transition transition) {
        if (this.contains(transition)) {
            return false;
        }
        return this.transitions.add(transition);
    }

    public boolean addAll(Transition[] transitions) {
        return CollectionUtils.addAllNoDuplicates(this.transitions, transitions);
    }

    public boolean contains(Transition transition) {
        return this.transitions.contains(transition);
    }

    public boolean remove(Transition transition) {
        return this.transitions.remove(transition);
    }

    public int size() {
        return this.transitions.size();
    }

    public Iterator iterator() {
        return this.transitions.iterator();
    }

    public Transition[] toArray() {
        return this.transitions.toArray(new Transition[this.transitions.size()]);
    }

    public TransitionCriteria[] getTransitionCriterias() {
        TransitionCriteria[] criterias = new TransitionCriteria[this.transitions.size()];
        int i = 0;
        Iterator it = this.transitions.iterator();
        while (it.hasNext()) {
            criterias[i++] = ((Transition)it.next()).getMatchingCriteria();
        }
        return criterias;
    }

    public Transition getTransition(RequestContext context) {
        for (Transition transition : this.transitions) {
            if (!transition.matches(context)) continue;
            return transition;
        }
        return null;
    }

    public boolean hasMatchingTransition(RequestContext context) {
        return this.getTransition(context) != null;
    }

    public String toString() {
        return StylerUtils.style((Object)this.transitions);
    }
}

