/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator<Object> {
    private Object arrayObject = null;
    private int pos = 0;
    private int length = 0;

    public ArrayIterator(Object pvArrayObjects) {
        if (pvArrayObjects == null) {
            throw new IllegalArgumentException("Param ArrayObject must be not null");
        }
        if (!pvArrayObjects.getClass().isArray()) {
            throw new IllegalArgumentException("Param ArrayObject must be an Array");
        }
        this.arrayObject = pvArrayObjects;
        this.length = Array.getLength(this.arrayObject);
        this.resetPosition();
    }

    public final void resetPosition() {
        this.pos = 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getPos() {
        return this.pos;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.length;
    }

    @Override
    public Object next() {
        if (this.pos >= this.length) {
            throw new NoSuchElementException("No more elements in the array (the pointer is after the last element).");
        }
        Object lvValue = Array.get(this.arrayObject, this.pos);
        ++this.pos;
        return lvValue;
    }

    @Override
    public void remove() {
    }
}

