/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.xmlrpc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.interchange.xmlrpc.XmlRpcException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRpcContentHandler
extends DefaultHandler {
    private String value = null;
    private List<Object> params = new ArrayList<Object>();
    private Stack<Object> stack = new Stack();
    private boolean returnValueAsList = true;
    private boolean isFault = false;
    private String methodName = null;
    private static final Map<String, String> validTags = new HashMap<String, String>();

    public XmlRpcContentHandler() {
        validTags.put("fault", "");
        validTags.put("data", "");
        validTags.put("param", "");
        validTags.put("params", "");
        validTags.put("value", "");
        validTags.put("member", "");
        validTags.put("methodCall", "");
        validTags.put("methodResponse", "");
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack.clear();
        this.isFault = false;
        this.methodName = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String pvUri, String pvLocalName, String pvName, Attributes pvAttributes) throws SAXException {
        if ("params".equals(pvName)) {
            this.params.clear();
        } else if ("array".equals(pvName)) {
            this.stack.push(new ArrayList());
        } else if ("struct".equals(pvName)) {
            this.stack.push(new HashMap());
        } else if ("fault".equals(pvName)) {
            this.isFault = true;
        }
    }

    private void addValue(String pvName, Object pvValue) {
        if (this.stack.size() > 0) {
            Object lvCurrentStackObj = this.stack.peek();
            if (lvCurrentStackObj instanceof List) {
                ((List)lvCurrentStackObj).add(pvValue);
            } else if (lvCurrentStackObj instanceof Map) {
                Map lvMap = (Map)lvCurrentStackObj;
                lvMap.put(pvName, pvValue);
                if ("key".equals(pvName)) {
                    for (Map.Entry entry : lvMap.entrySet()) {
                        if (entry.getValue() != null) continue;
                        entry.setValue(pvValue);
                    }
                }
                lvMap.remove("key");
            } else if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
                NonCriticalExceptionHandler.handleException(XmlRpcContentHandler.class, "Not supported Object in Stack: " + lvCurrentStackObj);
            }
        } else {
            this.params.add(pvValue);
        }
    }

    @Override
    public void endElement(String pvUri, String pvLocalName, String pvName) throws SAXException {
        Object currentValue = null;
        if ("string".equals(pvName) || "value".equals(pvName) && this.value != null) {
            this.value = this.value.replaceAll("&lt;", "<");
            this.value = this.value.replaceAll("&gt;", ">");
            currentValue = this.value;
            this.addValue("key", currentValue);
        } else if ("i4".equals(pvName) || "int".equals(pvName)) {
            currentValue = Integer.valueOf(this.value);
            this.addValue("key", currentValue);
        } else if ("boolean".equals(pvName)) {
            if ("1".equals(this.value)) {
                currentValue = Boolean.TRUE;
            } else if ("0".equals(this.value)) {
                currentValue = Boolean.FALSE;
            } else {
                throw new XmlRpcException("The value: " + this.value + " is not a valid boolean value.");
            }
            this.addValue("key", currentValue);
        } else if ("double".equals(pvName)) {
            try {
                currentValue = Double.valueOf(this.value);
                this.addValue("key", currentValue);
            }
            catch (NumberFormatException e) {
                throw new XmlRpcException("The value: " + this.value + " is not a valid double value.");
            }
        } else if ("dateTime.iso8601".equals(pvName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
            try {
                currentValue = sdf.parse(this.value);
                this.addValue("key", currentValue);
            }
            catch (ParseException e) {
                throw new XmlRpcException("The value: " + this.value + " is not a valid date value.");
            }
        } else if ("array".equals(pvName)) {
            Object lvCurrentStackObj = this.stack.pop();
            this.addValue("key", lvCurrentStackObj);
        } else if ("struct".equals(pvName)) {
            Object lvCurrentStackObj = this.stack.pop();
            this.addValue("key", lvCurrentStackObj);
        } else if ("ex:i1".equals(pvName)) {
            currentValue = Byte.valueOf(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:i2".equals(pvName)) {
            currentValue = Short.valueOf(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:i8".equals(pvName)) {
            currentValue = Long.valueOf(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:float".equals(pvName)) {
            currentValue = Float.valueOf(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:bigdecimal".equals(pvName)) {
            currentValue = new BigDecimal(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:biginteger".equals(pvName)) {
            currentValue = new BigInteger(this.value);
            this.addValue("key", currentValue);
        } else if ("ex:dateTime".equals(pvName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss.SSS");
            try {
                currentValue = sdf.parse(this.value);
                Calendar lvCalendar = Calendar.getInstance();
                lvCalendar.setTime((Date)currentValue);
                currentValue = lvCalendar;
                this.addValue("key", currentValue);
            }
            catch (ParseException e) {
                throw new XmlRpcException("The value: " + this.value + " is not a valid date value.");
            }
        } else if ("ex:nil".equals(pvName)) {
            currentValue = null;
            this.addValue("key", currentValue);
        } else if ("methodName".equals(pvName)) {
            this.methodName = this.value;
        } else if ("name".equals(pvName)) {
            this.addValue(this.value, null);
        } else if (!validTags.containsKey(pvName)) {
            throw new XmlRpcException("The Tag: " + pvName + " is not supported");
        }
        this.value = null;
    }

    @Override
    public void characters(char[] pvCh, int pvStart, int pvLength) throws SAXException {
        String lvOldValue = "";
        if (this.value != null) {
            lvOldValue = this.value;
        }
        this.value = lvOldValue + new String(pvCh, pvStart, pvLength);
    }

    public Object getResults() {
        if (!this.getReturnValueAsList() && this.params.size() == 1) {
            return this.params.get(0);
        }
        return this.params;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public void setReturnValueAsList(boolean pvReturnValueAsList) {
        this.returnValueAsList = pvReturnValueAsList;
    }

    public boolean getReturnValueAsList() {
        return this.returnValueAsList;
    }
}

