/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.reflect;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import net.sf.sojo.util.StackTraceElementWrapper;
import net.sf.sojo.util.ThrowableWrapper;
import net.sf.sojo.util.Util;

public final class ReflectionHelper {
    private static final Map<Class<?>, Class<?>> isSimpleType = new HashMap();

    protected ReflectionHelper() {
    }

    public static boolean isSimpleType(Object pvObject) {
        if (pvObject == null) {
            return false;
        }
        return ReflectionHelper.isSimpleType(pvObject.getClass());
    }

    public static boolean isSimpleType(Class<?> pvClass) {
        if (pvClass == null) {
            return false;
        }
        return isSimpleType.containsKey(pvClass);
    }

    public static void addSimpleType(Class<?> pvSimpleType) {
        if (pvSimpleType != null) {
            isSimpleType.put(pvSimpleType, pvSimpleType);
        }
    }

    public static void removeSimpleType(Class<?> pvSimpleType) {
        if (pvSimpleType != null) {
            isSimpleType.remove(pvSimpleType);
        }
    }

    public static boolean isMapType(Class<?> pvType) {
        boolean lvReturn = false;
        if (pvType != null) {
            lvReturn = Map.class.isAssignableFrom(pvType);
        }
        return lvReturn;
    }

    public static boolean isMapType(Object pvObject) {
        boolean lvReturn = false;
        if (pvObject == null) {
            lvReturn = false;
        } else if (pvObject instanceof Map) {
            lvReturn = true;
        }
        return lvReturn;
    }

    public static boolean isIterableType(Object pvObject) {
        boolean lvReturn = false;
        if (pvObject == null) {
            lvReturn = false;
        } else if (pvObject instanceof Collection) {
            lvReturn = true;
        } else if (pvObject.getClass().isArray()) {
            lvReturn = true;
        }
        return lvReturn;
    }

    public static boolean isIterateableType(Class<?> pvType) {
        boolean lvReturn = false;
        if (pvType == null) {
            lvReturn = false;
        } else if (Collection.class.isAssignableFrom(pvType)) {
            lvReturn = true;
        } else if (pvType.isArray()) {
            lvReturn = true;
        }
        return lvReturn;
    }

    public static boolean isComplexMapType(Class<?> pvType) {
        boolean lvReturn = true;
        if (pvType == null) {
            lvReturn = false;
        } else if (ReflectionHelper.isSimpleType(pvType)) {
            lvReturn = false;
        } else if (ReflectionHelper.isIterateableType(pvType)) {
            lvReturn = false;
        } else if (ReflectionHelper.isMapType(pvType)) {
            lvReturn = false;
        }
        return lvReturn;
    }

    public static boolean isComplexMapType(Object pvObject) {
        boolean lvReturn = ReflectionHelper.isMapType(pvObject);
        if (lvReturn) {
            Map lvMap = (Map)pvObject;
            lvReturn = lvMap.containsKey(Util.getKeyWordClass());
        }
        return lvReturn;
    }

    public static boolean isComplexType(Object pvObject) {
        boolean lvReturn = true;
        if (pvObject == null) {
            lvReturn = false;
        } else if (ReflectionHelper.isSimpleType(pvObject)) {
            lvReturn = false;
        } else if (ReflectionHelper.isIterableType(pvObject)) {
            lvReturn = false;
        } else if (ReflectionHelper.isMapType(pvObject)) {
            lvReturn = false;
        }
        return lvReturn;
    }

    public static boolean isComplexType(Class<?> pvType) {
        boolean lvReturn = true;
        if (pvType == null) {
            lvReturn = false;
        } else if (ReflectionHelper.isSimpleType(pvType)) {
            lvReturn = false;
        } else if (ReflectionHelper.isIterateableType(pvType)) {
            lvReturn = false;
        } else if (ReflectionHelper.isMapType(pvType)) {
            lvReturn = false;
        }
        return lvReturn;
    }

    public static Object createNewSimpleObject(Class<?> pvSimpleClass, Object pvSimpleParamObject) throws InstantiationException {
        try {
            if (pvSimpleClass == null) {
                return null;
            }
            String lvSimpleParamObjectString = "0";
            if (pvSimpleParamObject != null && pvSimpleParamObject.toString().length() > 0) {
                lvSimpleParamObjectString = pvSimpleParamObject.toString();
            }
            if (pvSimpleClass.equals(String.class)) {
                return lvSimpleParamObjectString;
            }
            if (pvSimpleClass.equals(Integer.TYPE)) {
                return Integer.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Integer.class)) {
                return Integer.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Short.TYPE)) {
                return Short.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Short.class)) {
                return Short.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Byte.TYPE)) {
                return Byte.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Byte.class)) {
                return Byte.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Long.TYPE)) {
                return Long.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Long.class)) {
                return Long.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Double.TYPE)) {
                return Double.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Double.class)) {
                return Double.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Float.TYPE)) {
                return Float.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Float.class)) {
                return Float.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Character.TYPE)) {
                return new Character(lvSimpleParamObjectString.charAt(0));
            }
            if (pvSimpleClass.equals(Character.class)) {
                return new Character(lvSimpleParamObjectString.charAt(0));
            }
            if (pvSimpleClass.equals(Boolean.TYPE)) {
                return Boolean.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Boolean.class)) {
                return Boolean.valueOf(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(BigDecimal.class)) {
                return new BigDecimal(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(BigInteger.class)) {
                return new BigInteger(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(StringBuffer.class)) {
                return new StringBuffer(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(URL.class)) {
                try {
                    return new URL(lvSimpleParamObjectString);
                }
                catch (Exception e) {
                    throw new InstantiationException("Can't create a new instance from type URL for String: " + lvSimpleParamObjectString + " (" + e + ")");
                }
            }
            if (pvSimpleClass.equals(Class.class)) {
                try {
                    if (lvSimpleParamObjectString.startsWith("class ")) {
                        lvSimpleParamObjectString = lvSimpleParamObjectString.substring("class ".length());
                    }
                    Class<?> lvClass = ReflectionHelper.forName(lvSimpleParamObjectString);
                    return lvClass;
                }
                catch (Exception e) {
                    throw new InstantiationException("Can't create a new instance from type class for String: " + lvSimpleParamObjectString + " (" + e + ")");
                }
            }
            if (pvSimpleClass.equals(Date.class)) {
                java.util.Date lvDate = Util.string2Date(lvSimpleParamObjectString);
                return new Date(lvDate.getTime());
            }
            if (pvSimpleClass.equals(java.util.Date.class)) {
                return Util.string2Date(lvSimpleParamObjectString);
            }
            if (pvSimpleClass.equals(Time.class)) {
                return new Time(new Long(lvSimpleParamObjectString));
            }
            if (pvSimpleClass.equals(Timestamp.class)) {
                long lvTime = Util.string2Date(lvSimpleParamObjectString).getTime();
                return new Timestamp(lvTime);
            }
        }
        catch (NumberFormatException e) {
            throw new InstantiationException("Can't create a new instance from type: " + pvSimpleClass.getName() + " with constructor-argument: " + pvSimpleParamObject);
        }
        return pvSimpleParamObject;
    }

    public static Constructor<?> findConstructorByParameterTypes(Class<?> pvClass, Class<?>[] pvParameterTypes) {
        Constructor<?>[] lvConstructors = pvClass.getConstructors();
        for (int i = 0; i < lvConstructors.length; ++i) {
            Class<?>[] lvParamTypes = lvConstructors[i].getParameterTypes();
            if (pvParameterTypes.length != lvParamTypes.length) continue;
            boolean lvFind = true;
            for (int j = 0; j < lvParamTypes.length; ++j) {
                if (lvParamTypes[j].equals(pvParameterTypes[j])) continue;
                lvFind = false;
            }
            if (!lvFind) continue;
            return lvConstructors[i];
        }
        return null;
    }

    public static Object createNewIterableInstance(Class<?> pvNewInstanceClass, int pvSize) {
        Object lvRetObj = null;
        try {
            Constructor<?> lvConstructor = ReflectionHelper.findConstructorByParameterTypes(pvNewInstanceClass, new Class[]{Integer.TYPE});
            lvRetObj = lvConstructor != null ? lvConstructor.newInstance(Integer.valueOf(Integer.toString(pvSize))) : pvNewInstanceClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't create a new instance of class : " + pvNewInstanceClass);
        }
        return lvRetObj;
    }

    public static Object createBeanFromMap(Map<?, ?> pvMap, Class<?> pvToType) throws InstantiationException, IllegalAccessException {
        Object lvClass = null;
        if (pvMap != null) {
            lvClass = pvMap.get(Util.getKeyWordClass());
        }
        Class lvBeanType = pvToType;
        if (lvClass instanceof String) {
            try {
                lvBeanType = ReflectionHelper.forName(lvClass.toString());
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException("Can't create a class for String: " + lvClass);
            }
        } else if (lvClass instanceof Class) {
            lvBeanType = (Class)lvClass;
        }
        if (lvBeanType == null) {
            throw new NullPointerException("No type (class) was set for create a Bean. Map is: " + pvMap + " an type is: " + pvToType);
        }
        Object lvBeanObject = null;
        try {
            lvBeanObject = lvBeanType.newInstance();
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Can't create a Bean from class: " + lvBeanType);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException("Can't create a Bean from class: " + lvBeanType);
        }
        return lvBeanObject;
    }

    public static Class<?> mapFromSimpeToWrapper(Class<?> pvSimpleType) {
        Class<Object> lvReturnClass = pvSimpleType;
        if (Byte.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Byte.class;
        } else if (Short.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Short.class;
        } else if (Integer.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Integer.class;
        } else if (Long.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Long.class;
        } else if (Float.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Float.class;
        } else if (Double.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Double.class;
        } else if (Character.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Character.class;
        } else if (Boolean.TYPE.equals(pvSimpleType)) {
            lvReturnClass = Boolean.class;
        }
        return lvReturnClass;
    }

    public static Throwable createThrowable(ThrowableWrapper pvThrowableWrapper) {
        return ReflectionHelper.createThrowable(pvThrowableWrapper, null);
    }

    public static Throwable createThrowable(ThrowableWrapper pvThrowableWrapper, Class<?> pvToClass) {
        Throwable lvThrowable = null;
        try {
            Class<?> lvClass = pvToClass;
            if (lvClass == null) {
                lvClass = ReflectionHelper.forName(pvThrowableWrapper.getExceptionClassName());
            } else if (!Throwable.class.isAssignableFrom(lvClass)) {
                throw new InstantiationException("The Class: " + lvClass.getName() + " is not from type Throwable!");
            }
            Constructor<?> lvConstructor = ReflectionHelper.findConstructorByParameterTypes(lvClass, new Class[]{String.class, Throwable.class});
            if (lvConstructor != null) {
                ThrowableWrapper lvCauseWrapper = pvThrowableWrapper.getCauseWrapper();
                if (lvCauseWrapper != null) {
                    Throwable lvCause = ReflectionHelper.createThrowable(lvCauseWrapper, null);
                    lvThrowable = (Throwable)lvConstructor.newInstance(pvThrowableWrapper.getMessage(), lvCause);
                } else {
                    lvThrowable = (Throwable)lvConstructor.newInstance(pvThrowableWrapper.getMessage(), null);
                }
            } else {
                lvConstructor = ReflectionHelper.findConstructorByParameterTypes(lvClass, new Class[]{String.class});
                if (lvConstructor != null) {
                    lvThrowable = (Throwable)lvConstructor.newInstance(pvThrowableWrapper.getMessage());
                } else {
                    lvConstructor = lvClass.getConstructor(new Class[0]);
                    if (lvConstructor != null) {
                        lvThrowable = (Throwable)lvConstructor.newInstance(new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            lvThrowable = e instanceof InstantiationException ? e : new InstantiationException(e.toString());
        }
        StackTraceElementWrapper[] lvElementWrapper = pvThrowableWrapper.getStackTraceElementWrapperList();
        StackTraceElement[] lvElement = new StackTraceElement[lvElementWrapper.length];
        for (int i = 0; i < lvElementWrapper.length; ++i) {
            StackTraceElement lvSTE;
            lvElement[i] = lvSTE = lvElementWrapper[i].tryToCreateStackTraceElement();
        }
        lvThrowable.setStackTrace(lvElement);
        return lvThrowable;
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        return clazz;
    }

    static {
        isSimpleType.put(String.class, String.class);
        isSimpleType.put(Boolean.class, Boolean.class);
        isSimpleType.put(Boolean.TYPE, Boolean.TYPE);
        isSimpleType.put(Byte.class, Byte.class);
        isSimpleType.put(Byte.TYPE, Byte.TYPE);
        isSimpleType.put(Short.class, Short.class);
        isSimpleType.put(Short.TYPE, Short.TYPE);
        isSimpleType.put(Integer.class, Integer.class);
        isSimpleType.put(Integer.TYPE, Integer.TYPE);
        isSimpleType.put(Long.class, Long.class);
        isSimpleType.put(Long.TYPE, Long.TYPE);
        isSimpleType.put(Float.class, Float.class);
        isSimpleType.put(Float.TYPE, Float.TYPE);
        isSimpleType.put(Double.class, Double.class);
        isSimpleType.put(Double.TYPE, Double.TYPE);
        isSimpleType.put(Character.class, Character.class);
        isSimpleType.put(Character.TYPE, Character.TYPE);
        isSimpleType.put(BigDecimal.class, BigDecimal.class);
        isSimpleType.put(StringBuffer.class, StringBuffer.class);
        isSimpleType.put(BigInteger.class, BigInteger.class);
        isSimpleType.put(Class.class, Class.class);
        isSimpleType.put(Date.class, Date.class);
        isSimpleType.put(java.util.Date.class, java.util.Date.class);
        isSimpleType.put(Time.class, Time.class);
        isSimpleType.put(Timestamp.class, Timestamp.class);
        isSimpleType.put(Calendar.class, Calendar.class);
        isSimpleType.put(GregorianCalendar.class, GregorianCalendar.class);
        isSimpleType.put(URL.class, URL.class);
        isSimpleType.put(Object.class, Object.class);
    }
}

