/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import net.sf.sojo.core.reflect.AccessiblePrivilegedAction;

public class Property {
    public static final int PROPERTY_TYPE_INVALIDE = -1;
    public static final int PROPERTY_TYPE_METHOD = 0;
    public static final int PROPERTY_TYPE_FIELD = 1;
    private AccessibleObject accessibleObject = null;
    private int propertyType = -1;
    private String toString = null;

    public Property(AccessibleObject pvAccessibleObject) {
        this.accessibleObject = pvAccessibleObject;
        this.detectPropertyType();
        this.toString = this.accessibleObject.toString();
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public void executeSetValue(Object pvObject, Object pvArgs) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        AccessController.doPrivileged(new AccessiblePrivilegedAction(this.accessibleObject));
        if (this.propertyType == 0) {
            ((Method)this.accessibleObject).invoke(pvObject, pvArgs);
        } else {
            ((Field)this.accessibleObject).set(pvObject, pvArgs);
        }
    }

    public Object executeGetValue(Object pvObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object lvReturnValue = null;
        AccessController.doPrivileged(new AccessiblePrivilegedAction(this.accessibleObject));
        lvReturnValue = this.propertyType == 0 ? ((Method)this.accessibleObject).invoke(pvObject, new Object[0]) : ((Field)this.accessibleObject).get(pvObject);
        return lvReturnValue;
    }

    public Class<?> getParameterType() {
        Class<?> lvParamType = null;
        if (this.propertyType == 0) {
            Method lvMethod = (Method)this.accessibleObject;
            Class<?>[] lvParameterTypes = lvMethod.getParameterTypes();
            if (lvParameterTypes != null && lvParameterTypes.length > 0) {
                lvParamType = lvMethod.getParameterTypes()[0];
            }
        } else {
            lvParamType = ((Field)this.accessibleObject).getType();
        }
        return lvParamType;
    }

    private void detectPropertyType() {
        if (this.accessibleObject instanceof Method) {
            this.propertyType = 0;
        } else if (this.accessibleObject instanceof Field) {
            this.propertyType = 1;
        } else {
            throw new IllegalArgumentException("Only Method or Field are allowed: " + this.accessibleObject);
        }
    }

    public String toString() {
        return this.toString;
    }
}

