/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.sojo.util.Util;

public class ClassPropertyFilter {
    private Class<?> filterClass = null;
    private List<String> propertyList = new ArrayList<String>();
    private boolean support4AddClassProperty = false;

    public ClassPropertyFilter() {
    }

    public ClassPropertyFilter(Class<?> pvClass) {
        this.setFilterClass(pvClass);
    }

    public ClassPropertyFilter(Class<?> pvClass, String[] pvProperties) {
        this.setFilterClass(pvClass);
        this.addProperties(pvProperties);
    }

    public Class<?> getFilterClass() {
        return this.filterClass;
    }

    private void setFilterClass(Class<?> pvClass) {
        this.filterClass = pvClass;
    }

    public void setSupport4AddClassProperty(boolean pvSupport4AddClassProperty) {
        this.support4AddClassProperty = pvSupport4AddClassProperty;
    }

    public boolean getSupport4AddClassProperty() {
        return this.support4AddClassProperty;
    }

    public ClassPropertyFilter addProperties(String[] pvProperties) {
        if (pvProperties != null) {
            for (String prop : pvProperties) {
                this.addProperty(prop);
            }
        }
        return this;
    }

    public ClassPropertyFilter addProperty(String pvProperty) {
        if (!Util.getKeyWordClass().equals(pvProperty) || this.getSupport4AddClassProperty()) {
            this.propertyList.add(pvProperty);
        }
        return this;
    }

    public ClassPropertyFilter removeProperty(String pvProperty) {
        this.propertyList.remove(pvProperty);
        return this;
    }

    public ClassPropertyFilter removeProperties(String[] pvProperty) {
        if (pvProperty != null) {
            for (String prop : pvProperty) {
                this.removeProperty(prop);
            }
        }
        return this;
    }

    public boolean isKnownProperty(String pvProperty) {
        if (pvProperty != null) {
            for (String prop : this.propertyList) {
                if (prop.equals(pvProperty)) {
                    return true;
                }
                if (!Pattern.matches(prop, pvProperty)) continue;
                return true;
            }
        }
        return false;
    }

    public int getPropertySize() {
        return this.propertyList.size();
    }

    public String[] getAllProperties() {
        return this.propertyList.toArray(new String[this.propertyList.size()]);
    }
}

