/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import java.util.ArrayList;
import java.util.List;
import net.sf.sojo.core.ConversionContext;
import net.sf.sojo.core.ConverterInterceptor;
import net.sf.sojo.core.ConverterInterceptorRecursive;

public class ConverterInterceptorHandler {
    private List<ConverterInterceptor> interceptors = new ArrayList<ConverterInterceptor>();

    public void addConverterInterceptor(ConverterInterceptor pvConverterInterceptor) {
        if (pvConverterInterceptor == null) {
            throw new IllegalArgumentException("The ConverterInterceptor must be different from null");
        }
        this.interceptors.remove(pvConverterInterceptor);
        this.interceptors.add(pvConverterInterceptor);
    }

    public ConverterInterceptor getConverterInterceptorByPosition(int pvPosition) {
        return this.interceptors.get(pvPosition);
    }

    public void removeConverterInterceptor(ConverterInterceptor pvSearchInterceptor) {
        this.interceptors.remove(pvSearchInterceptor);
    }

    public int size() {
        return this.interceptors.size();
    }

    public void clear() {
        this.interceptors.clear();
    }

    public Object fireBeforeConvert(Object pvConvertObject, Class<?> pvToType) {
        Object lvReturn = pvConvertObject;
        for (ConverterInterceptor lvInterceptor : this.interceptors) {
            lvReturn = lvInterceptor.beforeConvert(pvConvertObject, pvToType);
        }
        return lvReturn;
    }

    public Object fireAfterConvert(Object pvResult, Class<?> pvToType) {
        Object lvReturn = pvResult;
        for (ConverterInterceptor lvInterceptor : this.interceptors) {
            lvReturn = lvInterceptor.afterConvert(pvResult, pvToType);
        }
        return lvReturn;
    }

    public void fireOnError(Exception pvException) {
        for (ConverterInterceptor lvInterceptor : this.interceptors) {
            lvInterceptor.onError(pvException);
        }
    }

    public void fireBeforeConvertRecursion(ConversionContext pvContext) {
        for (ConverterInterceptor o : this.interceptors) {
            if (!(o instanceof ConverterInterceptorRecursive)) continue;
            ConverterInterceptorRecursive lvInterceptor = (ConverterInterceptorRecursive)o;
            lvInterceptor.beforeConvertRecursion(pvContext);
        }
    }

    public void fireAfterConvertRecursion(ConversionContext pvContext) {
        for (ConverterInterceptor o : this.interceptors) {
            if (!(o instanceof ConverterInterceptorRecursive)) continue;
            ConverterInterceptorRecursive lvInterceptor = (ConverterInterceptorRecursive)o;
            lvInterceptor.afterConvertRecursion(pvContext);
        }
    }
}

