/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.AttributeStatisticsType;
import com.supermap.data.Charset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.Environment;
import com.supermap.data.Feature;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariant;
import com.supermap.data.QueryParameter;
import com.supermap.data.RecordsetNative;
import com.supermap.data.Rectangle2D;
import com.supermap.data.RepresentationElement;
import com.supermap.data.RepresentationType;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.SpatialRelationType;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TextStyle;
import com.supermap.data.Toolkit;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recordset
extends InternalHandleDisposable {
    private DatasetVector _$11 = null;
    private Object _$10 = null;
    private SpatialQueryMode _$9 = SpatialQueryMode.NONE;
    private BatchEditor _$8 = null;
    private boolean _$7 = false;
    private int _$6;
    private boolean _$5;
    private FieldInfos _$4;
    private boolean[] _$3 = new boolean[]{false};
    transient Vector m_steppedListeners;
    protected long m_selfEventHandle;

    protected Recordset() {
    }

    Recordset(long l, DatasetVector datasetVector) {
        this.setHandle(l, true);
        this._$11 = datasetVector;
        this._$5 = RecordsetNative.jni_IsCursorTypeStatic(this.getHandle());
        this._$4 = new FieldInfos(RecordsetNative.jni_GetFieldInfos(this.getHandle()));
        this._$6 = this._$4.getCount();
    }

    public Rectangle2D getBounds() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        RecordsetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public DatasetVector getDataset() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$11;
    }

    public QueryParameter getQueryParameter() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetQueryParameter(this.getHandle());
        QueryParameter queryParameter = new QueryParameter(l, this._$10, this._$9);
        queryParameter.setIsDisposable(true);
        return queryParameter;
    }

    public FieldInfos getFieldInfos() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this._$4);
    }

    public int getFieldCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this._$6 = RecordsetNative.jni_GetFieldCount(this.getHandle());
        return this._$6;
    }

    public boolean isClosed() {
        boolean bl = false;
        bl = this._$11 != null ? this.getHandle() == 0L || this._$11.getHandle() == 0L || !this._$11.isOpen() : true;
        if (bl) {
            this.setHandle(0L);
        }
        return bl;
    }

    public boolean isBOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsBOF(this.getHandle());
    }

    public boolean isEOF() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEOF(this.getHandle());
    }

    public boolean isEmpty() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEmpty(this.getHandle());
    }

    public boolean isReadOnly() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5 || this._$11.isReadOnly();
    }

    public int getRecordCount() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetRecordCount(this.getHandle());
    }

    public boolean addNew(Geometry geometry) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        boolean bl = false;
        if (!this._$7) {
            if (geometry2 == null) {
                if (this._$11.getType() == DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), 0L);
                }
            } else {
                long l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this._$11.getType() != DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), l);
                }
            }
        } else if (geometry2 == null) {
            if (this._$11.getType() == DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), 0L);
            }
        } else {
            long l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this._$11.getType() != DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), l);
            }
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean addNew(Geometry geometry, Map<String, Object> map) {
        long l;
        int n;
        if (map == null) {
            return this.addNew(geometry);
        }
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        Object[] objectArray = map.keySet().toArray();
        int n2 = objectArray.length;
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[n2];
        long[] lArray = new long[n2];
        InternalVariant[] internalVariantArray = new InternalVariant[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        if (!this._$7) {
            if (geometry2 == null) {
                if (this._$11.getType() == DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
                }
            } else {
                l = geometry2.getHandle();
                if (l == 0L) {
                    String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this._$11.getType() != DatasetType.TABULAR) {
                    n = RecordsetNative.jni_AddNew2(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
                }
            }
        } else if (geometry2 == null) {
            if (this._$11.getType() == DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
            }
        } else {
            l = geometry2.getHandle();
            if (l == 0L) {
                String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this._$11.getType() != DatasetType.TABULAR) {
                n = RecordsetNative.jni_AddNew3(this.getHandle(), l, stringArray, lArray) ? 1 : 0;
            }
        }
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean edit() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Edit(this.getHandle());
    }

    public boolean update() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7) {
            String string = InternalResource.loadString("", "Recordset_BatchEditorIsBeginning", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = RecordsetNative.jni_Update(this.getHandle());
        return bl;
    }

    public boolean cancelUpdate() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_CancelUpdate(this.getHandle());
    }

    public void close() {
        if (!this.isClosed()) {
            RecordsetNative.jni_Close(this.getHandle());
            this.clearHandle();
            if (this._$4 != null) {
                this._$4.setIsDisposable(true);
                this._$4.dispose();
                this._$4 = null;
            }
        }
    }

    public boolean delete() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Delete(this.getHandle());
    }

    public boolean deleteAll() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_DeleteAll(this.getHandle());
    }

    private void _$2(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public Object getFieldValue(int n) {
        this._$2(n);
        FieldType fieldType = this._$4.get(n).getType();
        if (fieldType.equals(FieldType.INT32)) {
            Integer n2 = this.getInt32(n);
            if (this._$3[0]) {
                return null;
            }
            return n2;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l = this.getInt64(n);
            if (this._$3[0]) {
                return null;
            }
            return l;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s = this.getInt16(n);
            if (this._$3[0]) {
                return null;
            }
            return s;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(n);
            if (this._$3[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getByte(n);
            if (this._$3[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(n);
            if (this._$3[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(n);
            if (this._$3[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d = this.getDouble(n);
            if (this._$3[0]) {
                return null;
            }
            return d;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(n);
            if (this._$3[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f = Float.valueOf(this.getSingle(n));
            if (this._$3[0]) {
                return null;
            }
            return f;
        }
        if (fieldType.equals(FieldType.TEXT) || fieldType.equals(FieldType.WTEXT)) {
            String string = this.getString(n);
            if (this._$3[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public int getInt32(int n) {
        this._$2(n);
        int n2 = RecordsetNative.jni_GetFieldValueIntByIndex(this.getHandle(), n, this._$3);
        return n2;
    }

    public int getInt32(String string) {
        return this.getInt32(this._$4.indexOf(string));
    }

    public short getInt16(int n) {
        this._$2(n);
        short s = RecordsetNative.jni_GetFieldValueShortByIndex(this.getHandle(), n, this._$3);
        return s;
    }

    public short getInt16(String string) {
        return this.getInt16(this._$4.indexOf(string));
    }

    public long getInt64(int n) {
        this._$2(n);
        long l = RecordsetNative.jni_GetFieldValueLongByIndex(this.getHandle(), n, this._$3);
        return l;
    }

    public long getInt64(String string) {
        return this.getInt64(this._$4.indexOf(string));
    }

    public boolean getBoolean(int n) {
        this._$2(n);
        boolean bl = RecordsetNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), n, this._$3);
        return bl;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this._$4.indexOf(string));
    }

    public String getString(int n) {
        this._$2(n);
        String string = RecordsetNative.jni_GetFieldValueTextByIndex(this.getHandle(), n, this._$3);
        return string;
    }

    public String getString(String string) {
        return this.getString(this._$4.indexOf(string));
    }

    public Date getDateTime(int n) {
        this._$2(n);
        Date date = this.getFieldValueDateTimeByIndex(n, this._$3);
        return date;
    }

    public Date getDateTime(String string) {
        int n = this._$4.indexOf(string);
        return this.getDateTime(n);
    }

    Date getFieldValueDateTimeByIndex(int n, boolean[] blArray) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = RecordsetNative.jni_GetFieldValueDateByIndex(this.getHandle(), n, blArray);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public double getDouble(int n) {
        this._$2(n);
        double d = RecordsetNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), n, this._$3);
        return d;
    }

    public double getDouble(String string) {
        int n = this._$4.indexOf(string);
        return this.getDouble(n);
    }

    public float getSingle(int n) {
        this._$2(n);
        float f = RecordsetNative.jni_GetFieldValueFloatByIndex(this.getHandle(), n, this._$3);
        return f;
    }

    public float getSingle(String string) {
        int n = this._$4.indexOf(string);
        return this.getSingle(n);
    }

    public byte getByte(int n) {
        this._$2(n);
        byte by = RecordsetNative.jni_GetFieldValueByteByIndex(this.getHandle(), n, this._$3);
        return by;
    }

    public byte getByte(String string) {
        int n = this._$4.indexOf(string);
        return this.getByte(n);
    }

    public byte[] getLongBinary(int n) {
        this._$2(n);
        byte[] byArray = RecordsetNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), n, this._$3);
        return byArray;
    }

    public byte[] getLongBinary(String string) {
        int n = this._$4.indexOf(string);
        return this.getLongBinary(n);
    }

    private void _$2(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
    }

    public Object getFieldValue(String string) {
        this._$2(string);
        int n = this._$4.indexOf(string);
        if (n < 0) {
            String string2 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        return this.getFieldValue(n);
    }

    public Geometry getGeometry() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = RecordsetNative.jni_GetGeometry(this.getHandle());
        if (l == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance2(l, this.getDataset().getDatasource().getWorkspace());
        geometry.setIsDisposable(true);
        return geometry;
    }

    public int getID() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetID(this.getHandle());
    }

    public boolean move(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Move(this.getHandle(), n);
    }

    public boolean moveFirst() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveFirst(this.getHandle());
    }

    public boolean moveLast() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveLast(this.getHandle());
    }

    public boolean moveNext() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveNext(this.getHandle());
    }

    public boolean movePrev() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MovePrev(this.getHandle());
    }

    public boolean moveTo(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveTo(this.getHandle(), n);
    }

    public boolean refresh() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Refresh(this.getHandle());
    }

    public boolean seekID(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = n < 0 ? false : RecordsetNative.jni_SeekID(this.getHandle(), n);
        return bl;
    }

    private void _$1(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean setFieldValue(int n, Object object) {
        this._$1(n);
        if (this._$4.get(n).isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = object == null ? this.setFieldValueNull(n) : this.setFieldValue(this._$4.get(n).getName(), object);
        return bl;
    }

    private void _$1(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
    }

    public boolean setFieldValue(String string, Object object) {
        FieldInfo fieldInfo = this._$4.get(string);
        if (fieldInfo == null) {
            String string2 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (fieldInfo.isSystemField()) {
            String string3 = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        FieldType fieldType = fieldInfo.getType();
        if (object == null) {
            bl = this.setFieldValueNull(string);
        } else {
            String string4 = object.toString();
            if (fieldType.equals(FieldType.BOOLEAN)) {
                bl = this.setBoolean(string, (boolean)((Boolean)object));
            } else if (fieldType.equals(FieldType.BYTE)) {
                bl = this.setByte(string, (byte)((Byte)object));
            } else if (fieldType.equals(FieldType.CHAR)) {
                bl = this._$1(string, (String)object);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Date date = null;
                if (object instanceof String) {
                    String string5;
                    Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (pattern.matcher(string5 = (String)object).matches()) {
                        String string6 = System.getProperty("os.name").toLowerCase();
                        if (string6.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string5);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string5);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string5);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)object;
                }
                bl = this.setDateTime(string, date);
            } else {
                bl = fieldType.equals(FieldType.DOUBLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setDouble(string, (double)Double.valueOf(string4))) : (fieldType.equals(FieldType.INT16) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt16(string, (short)Short.valueOf(string4))) : (fieldType.equals(FieldType.INT32) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt32(string, (int)Integer.valueOf(string4))) : (fieldType.equals(FieldType.INT64) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt64(string, (long)Long.valueOf(string4))) : (fieldType.equals(FieldType.LONGBINARY) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setLongBinary(string, (byte[])object)) : (fieldType.equals(FieldType.SINGLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setSingle(string, Float.valueOf(string4).floatValue())) : (fieldType.equals(FieldType.TEXT) || fieldType.equals(FieldType.WTEXT) ? (string4.length() == 0 && !fieldInfo.isZeroLengthAllowed() ? false : this.setString(string, String.valueOf(string4))) : false))))));
            }
        }
        return bl;
    }

    public boolean setByte(int n, byte by) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return this.setByte(string, by);
    }

    public boolean setByte(String string, byte by) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueByteByName(this.getHandle(), string, by);
    }

    public boolean setInt32(String string, int n) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n);
    }

    public boolean setInt32(int n, int n2) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n2);
    }

    public boolean setInt16(String string, short s) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s);
    }

    public boolean setInt16(int n, short s) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s);
    }

    public boolean setInt64(String string, long l) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l);
    }

    public boolean setInt64(int n, long l) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l);
    }

    public boolean setDouble(String string, double d) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d);
    }

    public boolean setDouble(int n, double d) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d);
    }

    public boolean setSingle(String string, float f) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f);
    }

    public boolean setSingle(int n, float f) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f);
    }

    public boolean setBoolean(String string, boolean bl) {
        this._$2(string);
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    public boolean setBoolean(int n, boolean bl) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    private boolean _$1(String string, String string2) {
        return RecordsetNative.jni_setFieldValueCharByName(this.getHandle(), string, string2);
    }

    public boolean setString(String string, String string2) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string, string2);
    }

    public boolean setString(int n, String string) {
        this._$1(n);
        String string2 = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string2, string);
    }

    public boolean setLongBinary(String string, byte[] byArray) {
        this._$1(string);
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setLongBinary(int n, byte[] byArray) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setDateTime(String string, Date date) {
        this._$1(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        return RecordsetNative.jni_setFieldValueDateTimeByName(this.getHandle(), string, n, n2, n3, n4, n5, n6);
    }

    public boolean setDateTime(int n, Date date) {
        this._$1(n);
        String string = this._$4.get(n).getName();
        return this.setDateTime(string, date);
    }

    public boolean setFieldValueNull(int n) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6) {
            String string = InternalResource.loadString("" + n, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this._$4.get(n).isSystemField()) {
            String string = InternalResource.loadString("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this._$4.get(n).isRequired()) {
            String string = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_SetFieldValueNullByIndex(this.getHandle(), n);
    }

    public boolean setFieldValueNull(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$4.get(n).isSystemField()) {
            String string6 = InternalResource.loadString("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this._$4.get(n).isRequired()) {
            String string7 = InternalResource.loadString("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string7);
        }
        return RecordsetNative.jni_SetFieldValueNullByName(this.getHandle(), string);
    }

    public boolean setGeometry(Geometry geometry) {
        GeometryType geometryType;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType = this.getDataset().getType();
        if (!Recordset.checkDatasetAndGeometryType(datasetType, geometryType = geometry.getType())) {
            String string = InternalResource.loadString("geometry", "Recordset_DatasetTypeAndGeometryTypeIsDifferent", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = InternalResource.loadString("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = RecordsetNative.jni_SetGeometry(this.getHandle(), geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public double statistic(int n, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this._$6) {
            String string = InternalResource.loadString("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (statisticMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        FieldType fieldType = this._$4.get(n).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_StatisticByIndex(this.getHandle(), n, statisticMode.getUGCValue());
    }

    public double statistic(String string, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (statisticMode == null) {
            String string4 = InternalResource.loadString("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        FieldType fieldType = this._$4.get(n).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string6 = InternalResource.loadString("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return RecordsetNative.jni_StatisticByName(this.getHandle(), string, statisticMode.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
        }
    }

    public BatchEditor getBatch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetBatchEdit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            this._$8 = new BatchEditor(this.getHandle());
        }
        return this._$8;
    }

    void setQueryParameter(QueryParameter queryParameter) {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getHandle() == 0L) {
            String string = InternalResource.loadString("queryParameter", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getSpatialQueryObject() != null) {
            this._$10 = queryParameter.getSpatialQueryObject();
            this._$9 = queryParameter.getSpatialQueryMode();
        }
        RecordsetNative.jni_SetQueryParameter(this.getHandle(), queryParameter.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(queryParameter);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this._$11 = null;
        this._$9 = null;
        this._$10 = null;
    }

    protected static Recordset createInstance(long l, DatasetVector datasetVector) {
        return new Recordset(l, datasetVector);
    }

    static boolean checkDatasetAndGeometryType(DatasetType datasetType, GeometryType geometryType) {
        boolean bl = false;
        if (datasetType != null && geometryType != null) {
            if (datasetType == DatasetType.CAD) {
                bl = true;
            }
            if (datasetType == DatasetType.POINT && geometryType == GeometryType.GEOPOINT || (datasetType == DatasetType.LINE || datasetType == DatasetType.NETWORK) && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.PARAMETRICLINE && geometryType == GeometryType.GEOPARAMETRICLINECOMPOUND || datasetType == DatasetType.PARAMETRICREGION && geometryType == GeometryType.GEOPARAMETRICREGIONCOMPOUND || datasetType == DatasetType.REGION && geometryType == GeometryType.GEOREGION || datasetType == DatasetType.TEXT && geometryType == GeometryType.GEOTEXT || datasetType == DatasetType.LINEM && geometryType == GeometryType.GEOLINEM || datasetType == DatasetType.POINT3D && geometryType == GeometryType.GEOPOINT3D || datasetType == DatasetType.NETWORK3D && geometryType == GeometryType.GEOLINE3D || datasetType == DatasetType.NETWORK && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.REGION3D && geometryType == GeometryType.GEOREGION3D || datasetType == DatasetType.MODEL && geometryType == GeometryType.GEOMODEL) {
                bl = true;
            }
        }
        return bl;
    }

    public RepresentationElement getRepresentationElement(String string) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string4 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long[] lArray = new long[5];
        boolean bl = RecordsetNative.jni_GetRepresentationElement(this.getHandle(), string, lArray);
        if (bl) {
            RepresentationElement representationElement = new RepresentationElement();
            representationElement.setType((RepresentationType)Enum.parseUGCValue(RepresentationType.class, (int)lArray[0]));
            if (lArray[2] != 0L) {
                representationElement.setGeometry(Geometry.createInstance(lArray[2]).clone());
            }
            if (lArray[4] != 0L) {
                InternalVariant internalVariant = InternalVariant.createInstance(lArray[4]);
                Object object = internalVariant.toObject();
                internalVariant.dispose();
                internalVariant = null;
                representationElement.setCustomValue(object);
            }
            return representationElement;
        }
        return null;
    }

    public boolean setRepresentationElement(String string, RepresentationElement representationElement) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$4.get(n).isSystemField()) {
            String string6 = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (representationElement == null) {
            String string7 = InternalResource.loadString("element", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string7);
        }
        return this.setRepresentationElement(string, representationElement.getGeometry(), representationElement.getType(), representationElement.getCustomValue());
    }

    public boolean setRepresentationElement(String string, GeoStyle geoStyle, Object object) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$4.get(n).isSystemField()) {
            String string6 = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        if (object == null) {
            bl = geoStyle == null ? RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), string, 0L, 0L) : RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), string, geoStyle.getHandle(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(object)) {
                String string7 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string7);
            }
            InternalVariant internalVariant = new InternalVariant(object);
            bl = geoStyle == null ? RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), string, 0L, internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElementStyle(this.getHandle(), string, geoStyle.getHandle(), internalVariant.getHandle());
        }
        return bl;
    }

    public boolean setRepresentationElement(String string, TextStyle textStyle, Object object) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string5 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$4.get(n).isSystemField()) {
            String string6 = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        boolean bl = false;
        if (object == null) {
            bl = textStyle == null ? RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), string, 0L, 0L) : RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), string, textStyle.getHandle(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(object)) {
                String string7 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string7);
            }
            InternalVariant internalVariant = new InternalVariant(object);
            bl = textStyle == null ? RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), string, 0L, internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElementTextStyle(this.getHandle(), string, textStyle.getHandle(), internalVariant.getHandle());
        }
        return bl;
    }

    public boolean setRepresentationElement(String string, Geometry geometry, RepresentationType representationType, Object object) {
        if (this.isClosed()) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("representationField", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (geometry != null && geometry.getHandle() == 0L) {
            String string5 = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        int n = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n < 0) {
            String string6 = InternalResource.loadString(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this._$4.get(n).isSystemField()) {
            String string7 = InternalResource.loadString("representationField", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        boolean bl = false;
        if (representationType.equals(RepresentationType.STYLE)) {
            bl = geometry.getType().equals(GeometryType.GEOTEXT) ? this.setRepresentationElement(string, ((GeoText)geometry).getTextStyle(), object) : this.setRepresentationElement(string, geometry.getStyle(), object);
        } else if (object == null) {
            bl = geometry == null ? RecordsetNative.jni_SetRepresentationElement(this.getHandle(), string, 0L, representationType.getUGCValue(), 0L) : RecordsetNative.jni_SetRepresentationElement(this.getHandle(), string, geometry.getHandle(), representationType.getUGCValue(), 0L);
        } else {
            if (!InternalVariant.isSupportedInstance(object)) {
                String string8 = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                throw new IllegalArgumentException(string8);
            }
            InternalVariant internalVariant = new InternalVariant(object);
            bl = geometry == null ? RecordsetNative.jni_SetRepresentationElement(this.getHandle(), string, 0L, representationType.getUGCValue(), internalVariant.getHandle()) : RecordsetNative.jni_SetRepresentationElement(this.getHandle(), string, geometry.getHandle(), representationType.getUGCValue(), internalVariant.getHandle());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public boolean wasNull() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$3[0];
    }

    public boolean setValues(Map<String, Object> map) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$7) {
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this._$4.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        InternalVariant[] internalVariantArray = new InternalVariant[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Map<String, Object> map, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this._$7) {
            this.setGeometry(geometry);
            int n2 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n3 = this._$4.indexOf(string);
                if (n3 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n3, object);
                ++n2;
            }
            return n2 > 0;
        }
        if (!this._$11.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l = 0L;
        if (geometry2 != null) {
            l = geometry2.getHandle();
        }
        Charset charset = Environment.getCurrentCharset();
        Object[] objectArray = map.keySet().toArray();
        int n4 = objectArray.length;
        String[] stringArray = new String[n4];
        long[] lArray = new long[n4];
        InternalVariant[] internalVariantArray = new InternalVariant[n4];
        for (n = 0; n < n4; ++n) {
            stringArray[n] = (String)objectArray[n];
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n]) != null) {
                if (!InternalVariant.isSupportedInstance(map.get(stringArray[n]))) {
                    String string = InternalResource.loadString("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                Environment.setCurrentCharset(this.getDataset().getCharset());
                internalVariantArray[n] = new InternalVariant(map.get(stringArray[n]));
                Environment.setCurrentCharset(charset);
            } else {
                internalVariantArray[n] = new InternalVariant();
            }
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = 0;
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public boolean setValues(Object[] objectArray) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this._$6) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$7) {
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                if (this._$4.get(i).isSystemField() || (bl = this.setFieldValue(i, objectArray[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this._$11.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Charset charset = Environment.getCurrentCharset();
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        InternalVariant[] internalVariantArray = new InternalVariant[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (this._$4.get(n).isSystemField()) continue;
            stringArray[n] = this._$4.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            Environment.setCurrentCharset(this.getDataset().getCharset());
            internalVariantArray[n] = new InternalVariant(objectArray[n]);
            Environment.setCurrentCharset(charset);
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        return n != 0;
    }

    public boolean setValues(Object[] objectArray, Geometry geometry) {
        int n;
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = InternalResource.loadString("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this._$6) {
            String string = InternalResource.loadString("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this._$7) {
            this.setGeometry(geometry);
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                if (this._$4.get(i).isSystemField() || (bl = this.setFieldValue(i, objectArray[i]))) continue;
                return false;
            }
            return true;
        }
        if (!this._$11.getDatasource().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Charset charset = Environment.getCurrentCharset();
        Geometry geometry2 = geometry;
        long l = geometry2.getHandle();
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        InternalVariant[] internalVariantArray = new InternalVariant[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (this._$4.get(n).isSystemField()) continue;
            stringArray[n] = this._$4.get(n).getName();
            if (stringArray[n].equalsIgnoreCase("smid")) {
                String string = InternalResource.loadString("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            Environment.setCurrentCharset(this.getDataset().getCharset());
            internalVariantArray[n] = new InternalVariant(objectArray[n]);
            Environment.setCurrentCharset(charset);
            internalVariantArray[n].setIsDisposable(false);
            lArray[n] = internalVariantArray[n].getHandle();
        }
        n = RecordsetNative.jni_SetGeometry1(this.getHandle(), l, true, stringArray, lArray) ? 1 : 0;
        for (int i = 0; i < internalVariantArray.length; ++i) {
            internalVariantArray[i].setIsDisposable(true);
            internalVariantArray[i].dispose();
            internalVariantArray[i] = null;
        }
        Recordset.makeSureNativeObjectLive(geometry2);
        return n != 0;
    }

    public Object[] getValues() {
        if (this.isClosed()) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = new Object[this._$6];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getFieldValue(i);
        }
        return objectArray;
    }

    public boolean setObject(int n, Object object) {
        return this.setFieldValue(n, object);
    }

    public boolean setObject(String string, Object object) {
        return this.setFieldValue(string, object);
    }

    public Object getObject(int n) {
        return this.getFieldValue(n);
    }

    public Object getObject(String string) {
        return this.getFieldValue(string);
    }

    public Feature getFeature() {
        long l = RecordsetNative.jni_GetFeature(this.getHandle());
        if (0L == l) {
            throw new OutOfMemoryError("OutOfMemory");
        }
        Feature feature = new Feature(l);
        return feature;
    }

    public Map<Integer, Feature> getAllFeatures() {
        HashMap<Integer, Feature> hashMap = new HashMap<Integer, Feature>(this.getRecordCount());
        this.moveFirst();
        while (!this.isEOF()) {
            Feature feature = this.getFeature();
            hashMap.put(feature.getID(), feature);
            this.moveNext();
        }
        return hashMap;
    }

    public boolean updateFields(DatasetVector datasetVector, SpatialRelationType spatialRelationType, String[] stringArray, String[] stringArray2, AttributeStatisticsType attributeStatisticsType, boolean bl, String string, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string3 = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasetVector == null) {
            String string4 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string5 = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray == null) {
            String string6 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (stringArray2 == null) {
            String string7 = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_UpdateFields1(this.getHandle(), datasetVector.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), stringArray, stringArray2, bl, string, bl2, this.m_selfEventHandle);
    }

    public boolean updateFields(Recordset recordset, SpatialRelationType spatialRelationType, String[] stringArray, String[] stringArray2, AttributeStatisticsType attributeStatisticsType, boolean bl, String string, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string3 = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (recordset == null) {
            String string4 = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string5 = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (stringArray == null) {
            String string6 = InternalResource.loadString("sourceFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (stringArray2 == null) {
            String string7 = InternalResource.loadString("targetFields", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_UpdateFields2(this.getHandle(), recordset.getHandle(), spatialRelationType.value(), attributeStatisticsType.value(), stringArray, stringArray2, bl, string, bl2, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(DatasetVector datasetVector, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_GetIDsByGeoRelation1(this.getHandle(), datasetVector.getHandle(), spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(Recordset recordset, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset.getDataset().getType() != DatasetType.POINT && recordset.getDataset().getType() != DatasetType.LINE && recordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        return RecordsetNative.jni_GetIDsByGeoRelation2(this.getHandle(), recordset.getHandle(), spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
    }

    public int[] getIDsByGeoRelation(Geometry[] geometryArray, SpatialRelationType spatialRelationType, boolean bl, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getDataset().getType() != DatasetType.POINT && this.getDataset().getType() != DatasetType.LINE && this.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("Recordset", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray == null) {
            String string = InternalResource.loadString("sourceGeometries", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray.length == 0) {
            String string = InternalResource.loadString("sourceGeometries.length", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryArray[0] == null) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeometryType geometryType = geometryArray[0].getType();
        if (geometryType != GeometryType.GEOPOINT && geometryType != GeometryType.GEOLINE && geometryType != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("sourceGeometries[0]", "Geometry_Type_Invalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long[] lArray = new long[geometryArray.length];
        for (int i = 0; i < geometryArray.length; ++i) {
            Geometry geometry = geometryArray[i];
            if (geometry == null) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry.getType() != geometryType) {
                String string = InternalResource.loadString(String.format("sourceGeometries[%d]", i), "Geometry_Type_Must_Be_Same", "data_resources");
                throw new IllegalArgumentException(string);
            }
            lArray[i] = geometry.getHandle();
            hashSet.add(geometry.getID());
        }
        if (hashSet.size() != geometryArray.length) {
            String string = InternalResource.loadString("sourceGeometries", "Geometry_Type_Must_Be_Same", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_selfEventHandle = RecordsetNative.jni_NewSelfEventHandle(this);
        int[] nArray = RecordsetNative.jni_GetIDsByGeoRelation3(this.getHandle(), lArray, spatialRelationType.value(), bl, bl2, this.m_selfEventHandle);
        this.clearSelfEventHandle();
        return nArray;
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Recordset recordset, int n, long l, String string, String string2, long l2) {
        if (recordset != null) {
            boolean bl = Toolkit.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent(recordset, n, l, string, string2, null, bl);
            recordset.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(recordset);
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            RecordsetNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public class BatchEditor {
        private int _$1 = 1024;
        long handle = 0L;

        private BatchEditor(long l) {
            this.handle = l;
        }

        public void begin() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Begin()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_setMaxRecordCount(this.handle, this._$1);
            boolean bl2 = RecordsetNative.jni_begin(this.handle, true);
            Recordset.this._$7 = true;
        }

        public void update() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Update()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_Update1(this.handle);
            if (bl) {
                Recordset.this._$7 = false;
                RecordsetNative.jni_begin(this.handle, false);
            }
        }

        public void cancel() {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("Cancel()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_CancelUpdate1(this.handle);
            if (bl) {
                Recordset.this._$7 = false;
                RecordsetNative.jni_begin(this.handle, false);
            }
        }

        public void setMaxRecordCount(int n) {
            if (this.handle == 0L) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n < 0) {
                String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "data_resources");
                throw new IllegalStateException(string);
            }
            if (Recordset.this._$7) {
                String string = InternalResource.loadString("SetMaxRecordCount(int value)", "SetMaxRecordCount_Must_BeforeBegin", "data_resources");
                throw new IllegalStateException(string);
            }
            this._$1 = n;
        }

        public int getMaxRecordCount() {
            return this._$1;
        }
    }
}

