/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Environment;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeometristNative;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResampleType;
import com.supermap.data.Unit;

public class Geometrist {
    private Geometrist() {
    }

    public static boolean isIdentical(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometrySearch and geomettyTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsIdentical(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean isDisjointed(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsDisjointed(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasIntersection(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION && geometry2.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasIntersection(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasTouch(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasTouch(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasOverlap(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2.getType() != geometry2.getType()) {
            String string = InternalResource.loadString("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasOverlap(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasCross(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCross(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean isWithin(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_IsWithin(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean canContain(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_CanContain(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasCommonPoint(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCommonPoint(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static boolean hasCommonLine(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasCommonLine(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public static Geometry clip(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Clip(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry clip(Geometry geometry, Rectangle2D rectangle2D) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("clipRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.isEmpty()) {
            String string = InternalResource.loadString("clipRectangle", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ClipRect(geometry.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static boolean hasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasHollow(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    @Deprecated
    public static boolean HasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_HasHollow(geometry.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public static Geometry intersect(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!geometry.getType().equals(geometry2.getType())) {
            String string = InternalResource.loadString("", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Intersect(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry erase(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("eraseGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Erase(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry union(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Union(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry xOR(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_XOR(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry update(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("updateGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Update(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    public static Geometry identity(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("identityGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Identity(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l != 0L) {
            geometry3 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return geometry3;
    }

    @Deprecated
    public static Geometry resample(Geometry geometry, double d) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_Resample(geometry.getHandle(), d);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static Geometry resample(Geometry geometry, ResampleType resampleType, double d) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = resampleType.getUGCValue();
        long l = GeometristNative.jni_Resample1(geometry.getHandle(), n, d);
        Geometry geometry2 = null;
        if (l != 0L) {
            geometry2 = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geometry2;
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = GeometristNative.jni_Distance(geometry.getHandle(), geometry2.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return d;
    }

    public static GeoRegion computeConvexHull(Point2Ds point2Ds) {
        int n = point2Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l = GeometristNative.jni_ComputeConvexHullPoints(dArray, dArray2, n);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion computeConvexHull(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeConvexHull(geometry.getHandle());
        Geometry geometry2 = null;
        geometry2 = l != 0L ? Geometry.createInstance(l) : Geometry.createInstance(geometry.getType());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return (GeoRegion)geometry2;
    }

    public static boolean splitRegion(GeoRegion geoRegion, Geometry geometry, GeoRegion geoRegion2, GeoRegion geoRegion3) {
        if (geoRegion == null || geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion2 == null || geoRegion2.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3 == null || geoRegion3.getHandle() == 0L) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geoRegion, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("soureRegion", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geoRegion2, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geoRegion3, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("targetGeoRegion2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_SplitRegion(geoRegion.getHandle(), geometry.getHandle(), geoRegion2.getHandle(), geoRegion3.getHandle());
        if (bl) {
            geoRegion2.refrashPartsList();
            geoRegion3.refrashPartsList();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion2);
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion3);
        return bl;
    }

    public static GeoArc computeFillet(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, double d) {
        if (d <= 0.0) {
            String string = InternalResource.loadString("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeFillet(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), d);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoArc)geometry;
    }

    public static boolean isParallel(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsParallel(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computeParallel(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        if (!Geometrist.isPointOnLine(point2D, point2D2, point2D3, true)) {
            geoLine = Geometrist.computePerpendicular(point2D, point2D2, point2D3);
            geoLine.rotate(point2D, -90.0);
        }
        return geoLine;
    }

    public static GeoLine computeParallel(GeoLine geoLine, double d) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeometristNative.jni_ComputeParallel(geoLine.getHandle(), d);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        return (GeoLine)geometry;
    }

    public static boolean isPerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPerpendicular(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computePerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        Point2D point2D4 = Geometrist.computePerpendicularPosition(point2D, point2D2, point2D3);
        geoLine.rotate(point2D4, 90.0);
        return geoLine;
    }

    public static Point2D computePerpendicularPosition(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        GeometristNative.jni_ComputePerpendicularPosition(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public static boolean isPointOnLine(Point2D point2D, Point2D point2D2, Point2D point2D3, boolean bl) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), bl);
    }

    public static Point2D intersectLine(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, boolean bl) {
        if (point2D.equals(point2D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl2 = GeometristNative.jni_IntersectLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), bl, dArray);
        if (bl2) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public static double computeGeodesicDistance(Point2Ds point2Ds, double d, double d2) {
        if (point2Ds.getCount() < 2) {
            String string = InternalResource.loadString("points", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("majorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 >= 1.0) {
            String string = InternalResource.loadString("flatten", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[point2Ds.getCount()];
        double[] dArray2 = new double[point2Ds.getCount()];
        for (int i = 0; i < point2Ds.getCount(); ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        return GeometristNative.jni_ComputeGeodesicDistance(dArray, dArray2, d, d2);
    }

    public static double computeGeodesicArea(Geometry geometry, PrjCoordSys prjCoordSys) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = GeometristNative.jni_ComputeGeodesicArea(geometry.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d;
    }

    public static double computeLength(GeoLine3D geoLine3D, PrjCoordSys prjCoordSys) {
        if (geoLine3D == null || geoLine3D.getHandle() == 0L) {
            String string = InternalResource.loadString("line3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d = GeometristNative.jni_ComputeLength(geoLine3D.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine3D);
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d;
    }

    public static Point2D[] intersectPolyLine(Point2Ds point2Ds, Point2Ds point2Ds2) {
        int n = point2Ds.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("points1", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = point2Ds2.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("points2", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = point2Ds2.getItem(i).getX();
            dArray4[i] = point2Ds2.getItem(i).getY();
        }
        double[][] dArray5 = GeometristNative.jni_IntersectPolyLine(dArray, dArray2, n, dArray3, dArray4, n2);
        if (dArray5 == null) {
            return null;
        }
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        Point2D[] point2DArray = new Point2D[dArray6.length];
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = new Point2D();
            point2D.setX(dArray6[i]);
            point2D.setY(dArray7[i]);
            point2DArray[i] = point2D;
        }
        return point2DArray;
    }

    public static Point2Ds smooth(Point2Ds point2Ds, int n) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds.getCount() < 4) {
            String string = InternalResource.loadString("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(point2Ds);
        InternalHandleDisposable.setIsDisposable(geoLine, false);
        long l = geoLine.getHandle();
        long l2 = GeometristNative.jni_Smooth(l, n);
        Point2Ds point2Ds2 = null;
        if (l2 != 0L) {
            GeoLine geoLine2 = new GeoLine(l2);
            int n2 = geoLine2.getPart(0).getCount();
            Point2D[] point2DArray = new Point2D[n2];
            for (int i = 0; i < n2; ++i) {
                Point2D point2D;
                point2DArray[i] = point2D = geoLine2.getPart(0).getItem(i);
            }
            point2Ds2 = new Point2Ds(point2DArray);
            InternalHandleDisposable.setIsDisposable(geoLine2, true);
            geoLine2.dispose();
        }
        return point2Ds2;
    }

    public static GeoLine[] splitLine(GeoLine geoLine, Geometry geometry, double d) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geoLine, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = InternalResource.loadString("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT) && d <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeometristNative.jni_SplitLine(geoLine.getHandle(), geometry.getHandle(), d);
        if (lArray == null) {
            return null;
        }
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)Geometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return geoLineArray;
    }

    public static boolean isLeft(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsLeft(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public static boolean isRight(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsRight(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public static boolean isOnSameSide(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D3.equals(point2D4)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsOnSameSide(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY()) == 1;
    }

    public static boolean isProjectOnLineSegment(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsProjectOnLineSegment(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public static double distanceToLineSegment(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return GeometristNative.jni_DistanceToLineSegment(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public static Point2D nearestPointToVertex(Point2D point2D, Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist._$1(geometry, GeometryType.GEOLINE)) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl = GeometristNative.jni_NearestPointToVertex(point2D.getX(), point2D.getY(), geometry.getHandle(), dArray);
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        if (!bl) {
            return Point2D.getEMPTY();
        }
        return new Point2D(dArray[0], dArray[1]);
    }

    public static Point3D intersectLineSegment(Point3D point3D, Point3D point3D2, Point3D point3D3, Point3D point3D4, double d) {
        if (point3D.equals(point3D2)) {
            String string = InternalResource.loadString("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point3D3.equals(point3D4)) {
            String string = InternalResource.loadString("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[]{point3D.getX(), point3D.getY(), point3D.getZ()};
        double[] dArray3 = new double[]{point3D2.getX(), point3D2.getY(), point3D2.getZ()};
        double[] dArray4 = new double[]{point3D3.getX(), point3D3.getY(), point3D3.getZ()};
        double[] dArray5 = new double[]{point3D4.getX(), point3D4.getY(), point3D4.getZ()};
        boolean bl = GeometristNative.jni_IntersectLineSegment3D(dArray2, dArray3, dArray4, dArray5, dArray, d);
        if (!bl) {
            return Point3D.getEMPTY();
        }
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static boolean isPointOnLineSegment(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        if (point3D2.equals(point3D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLineSegment3D(point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), point3D3.getX(), point3D3.getY(), point3D3.getZ());
    }

    public static boolean isProjectOnLineSegment(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        if (point3D2.equals(point3D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsProjectOnLineSegment3D(point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), point3D3.getX(), point3D3.getY(), point3D3.getZ());
    }

    public static Point3D computePerpendicularPosition(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        if (point3D2.equals(point3D3)) {
            String string = InternalResource.loadString("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[3];
        GeometristNative.jni_ComputePerpendicularPosition3D(point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), point3D3.getX(), point3D3.getY(), point3D3.getZ(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public static double distanceToLineSegment(Point3D point3D, Point3D point3D2, Point3D point3D3) {
        return GeometristNative.jni_DistanceToLineSegment3D(point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ(), point3D3.getX(), point3D3.getY(), point3D3.getZ());
    }

    private static boolean _$1(Geometry geometry, GeometryType ... geometryTypeArray) {
        boolean bl = false;
        for (GeometryType geometryType : geometryTypeArray) {
            bl = bl || geometry.getType() == geometryType;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        return bl;
    }

    public static GeoRegion computeConcaveHull(Point2Ds point2Ds, double d) {
        int n = point2Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0 || d >= 180.0) {
            String string = InternalResource.loadString("angle", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long l = GeometristNative.jni_ComputeConcaveHullPoints(dArray, dArray2, n, d);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = Geometry.createInstance(l);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion[] aggregatePointsToRegions(Point2Ds point2Ds, PrjCoordSys prjCoordSys, double d, Unit unit, int n) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds.getCount() < n) {
            String string = InternalResource.loadString("minPilePointCount", "PointsCountMustLargerThanMinPilePointCount", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("distance", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (prjCoordSys != null && prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys != null) {
            l = prjCoordSys.getHandle();
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        long[] lArray = GeometristNative.jni_AggregatePoints(dArray, dArray2, n2, d, l, unit.value(), n);
        if (lArray != null) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = (GeoRegion)GeoRegion.createInstance(lArray[i]);
            }
            return geoRegionArray;
        }
        return null;
    }

    public static int[] aggregatePoints(Point2Ds point2Ds, PrjCoordSys prjCoordSys, double d, Unit unit, int n) {
        if (point2Ds == null) {
            String string = InternalResource.loadString("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds.getCount() < n) {
            String string = InternalResource.loadString("minPilePointCount", "PointsCountMustLargerThanMinPilePointCount", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("distance", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (prjCoordSys != null && prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys != null) {
            l = prjCoordSys.getHandle();
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        int[] nArray = GeometristNative.jni_AggregatePoints2(dArray, dArray2, n2, d, l, unit.value(), n);
        return nArray;
    }

    static {
        Environment.LoadWrapJ();
    }
}

