/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegionNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import java.util.ArrayList;

public class GeoRegion
extends Geometry {
    private ArrayList _$5;

    public GeoRegion() {
        super.setHandle(GeoRegionNative.jni_New(), true);
        this._$5 = new ArrayList();
    }

    public GeoRegion(GeoRegion geoRegion) {
        if (geoRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion.getHandle() == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegionNative.jni_Clone(geoRegion.getHandle());
        super.setHandle(l, true);
        this._$5 = new ArrayList(geoRegion.getPartsList().size());
        for (int i = 0; i < geoRegion.getPartsList().size(); ++i) {
            Point2Ds point2Ds = (Point2Ds)geoRegion.getPartsList().get(i);
            this._$5.add(point2Ds.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoRegion);
    }

    public GeoRegion(Point2Ds point2Ds) {
        this();
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("convertToRegion", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.addPart(point2Ds);
    }

    public int addPart(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = point2Ds.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds2 = new Point2Ds(this._$1(n2));
        Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
        this._$5.add(point2Ds3);
        return n2;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRegionNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public Point2Ds getPart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this._$5.get(n);
    }

    public boolean insertPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        if (n == this.getPartCount()) {
            int n3 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds2 = new Point2Ds(this._$1(n3));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this._$5.add(n, point2Ds3);
            return n3 != -1;
        }
        boolean bl = GeoRegionNative.jni_InsertPart(this.getHandle(), n, dArray, dArray2);
        Point2Ds point2Ds4 = new Point2Ds(this._$1(n));
        Point2Ds point2Ds5 = new Point2Ds(point2Ds4, this);
        this._$5.add(n, point2Ds5);
        return bl;
    }

    public boolean removePart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegionNative.jni_RemovePart(this.getHandle(), n);
        if (bl) {
            this._$5.remove(n);
        }
        return bl;
    }

    public boolean setPart(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds2 = (Point2Ds)this._$5.get(n);
            Point2Ds point2Ds3 = new Point2Ds(this._$1(n));
            Point2Ds point2Ds4 = new Point2Ds(point2Ds3, this);
            this._$5.set(n, point2Ds4);
            point2Ds2.setUserType(Point2Ds.UserType.NONE);
        }
        return bl;
    }

    boolean setPartJustToUGC(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n, dArray, dArray2);
        return bl;
    }

    public int indexOf(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5.indexOf(point2Ds);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPerimeter(this.getHandle());
    }

    public boolean isCounterClockwise(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCounterClockwise(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return GeoRegionNative.jni_IsCounterClockwise(this.getHandle(), n) > 0;
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = super.fromXML(string);
        if (bl) {
            this.refrashPartsList();
        }
        return bl;
    }

    public Geometry mirror(Point2D point2D, Point2D point2D2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = (GeoRegion)super.mirror(point2D, point2D2);
        int n = geoRegion.getPartCount();
        geoRegion._$5 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(geoRegion._$1(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, geoRegion);
            geoRegion._$5.add(point2Ds2);
        }
        return geoRegion;
    }

    public void offset(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(d, d2);
        this._$1();
    }

    public void resize(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(rectangle2D);
        this._$1();
    }

    public void rotate(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(point2D, d);
        this._$1();
    }

    protected void clearHandle() {
        super.clearHandle();
        if (this._$5 != null) {
            this._$5.clear();
            this._$5 = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoRegion geoRegion) {
        geoRegion.clearHandle();
    }

    protected void changeHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("regionHandle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.dispose();
        this.setHandle(l, false);
    }

    protected static void changeHandle(GeoRegion geoRegion, long l) {
        geoRegion.changeHandle(l);
    }

    ArrayList getPartsList() {
        return this._$5;
    }

    private Point2D[] _$1(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegionNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoRegionNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void _$1() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = (Point2Ds)this._$5.get(i);
            point2Ds.setUserType(Point2Ds.UserType.NONE);
            point2Ds.clear();
            point2Ds.addRange(this._$1(i));
            point2Ds.setUserType(Point2Ds.UserType.GEOREGION);
        }
    }

    void refrashPartsList() {
        int n = this.getPartCount();
        this._$5.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this._$1(i));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this._$5.add(point2Ds2);
        }
    }

    public GeoRegion clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegionNative.jni_Clear(this.getHandle());
        this._$5.clear();
    }

    GeoRegion(long l) {
        this.setHandle(l, false);
        this._$5 = new ArrayList();
        this.refrashPartsList();
    }

    protected void refreshHandle(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l, false);
    }

    protected static void refreshHandle(GeoRegion geoRegion, long l) {
        geoRegion.refreshHandle(l);
    }

    public GeoRegion[] protectedDecompose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("protectedDecompose()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoRegionNative.jni_ProtectedDecompose(this.getHandle());
        if (lArray != null && lArray.length > 0) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = new GeoRegion(lArray[i]);
            }
            return geoRegionArray;
        }
        return null;
    }
}

