/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoArcNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoArc
extends Geometry {
    private double _$6;
    private double _$5;

    public GeoArc() {
        long l = GeoArcNative.jni_New();
        this.setHandle(l, true);
        this._$6 = 0.0;
        this._$5 = 180.0;
    }

    public GeoArc(GeoArc geoArc) {
        if (geoArc == null) {
            String string = InternalResource.loadString("geoArc", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoArc);
        if (l == 0L) {
            String string = InternalResource.loadString("geoArc", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoArcNative.jni_Clone(l);
        this._$6 = geoArc.getStartAngle();
        this._$5 = geoArc.getSweepAngle();
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoArc);
    }

    GeoArc(long l) {
        this.setHandle(l, false);
        this._$6 = GeoArcNative.jni_GetStartAngle(l);
        this._$5 = GeoArcNative.jni_GetSweepAngle(l);
    }

    public GeoArc(Point2D point2D, double d, double d2, double d3) {
        double d4;
        if (d <= 0.0) {
            String string = InternalResource.loadString("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= -360.0 || d3 >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoArc_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoArc_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d2, d3, d5, d6);
        double d7 = point2D.getX();
        long l = GeoArcNative.jni_New2(d7, d4 = point2D.getY(), d, dArray[0], dArray[1]);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoArc(Point2D startPoint,Point2D middlePoint,Point2D endPoint)", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = d2;
        this._$5 = d3;
        this.setHandle(l, true);
    }

    public GeoArc(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = point2D3.getX();
        double d6 = point2D3.getY();
        long l = GeoArcNative.jni_New3(d, d2, d3, d4, d5, d6);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoArc(Point2D startPoint,Point2D middlePoint,Point2D endPoint)", "ThreePointsAreInOneLine", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d7 = GeoArcNative.jni_GetStartAngle(l);
        double d8 = GeoArcNative.jni_GetEndAngle(l);
        if (d8 - d7 < 0.0) {
            this._$6 = d8;
            this._$5 = -(360.0 - (d7 - d8));
        } else {
            this._$6 = d7;
            this._$5 = d8 - d7;
        }
        this.setHandle(l, true);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoArcNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D();
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.getRadius();
        double d4 = this.getStartAngle();
        double d5 = this.getSweepAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d4, d5, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d, d2, d3, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoArcNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getStartAngle();
        double d5 = this.getSweepAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d4, d5, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setRadius(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setStartAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getRadius();
        double d5 = this.getSweepAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d, d5, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d4, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setStartAngle(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = d;
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setSweepAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= -360.0 || d >= 360.0) {
            String string = InternalResource.loadString("value", "GeoArc_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d == 0.0) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "GeoArc_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = this.getCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.getRadius();
        double d5 = this.getStartAngle();
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = GeoArc.valueToUGC(d5, d, d6, d7);
        boolean bl = GeoArcNative.jni_SetArc(this.getHandle(), d2, d3, d4, dArray[0], dArray[1]);
        if (!bl) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "GeoArc_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$5 = d;
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoArcNative.jni_GetLength(this.getHandle());
    }

    public GeoLine convertToLine(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("segmentCount", "Global_ArgumentShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoArcNative.jni_ConvertToLine(this.getHandle(), n);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public Point2D findPointOnArc(double d) {
        if (this.getSweepAngle() < 0.0 && (d < this.getSweepAngle() || d > 0.0)) {
            String string = InternalResource.loadString("findPointOnArc(double sweepAngle)", "GeoArc_SweepAngleOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getSweepAngle() > 0.0 && (d > this.getSweepAngle() || d < 0.0)) {
            String string = InternalResource.loadString("findPointOnArc(double sweepAngle)", "GeoArc_SweepAngleOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = (int)this.getStartAngle();
        int n2 = n / 360;
        double d2 = this.getStartAngle() - (double)(360 * n2);
        double d3 = d2 + d;
        double d4 = d3 / 180.0 * Math.PI;
        Point2D point2D = this.getCenter();
        double d5 = point2D.getX() + Math.cos(d4) * this.getRadius();
        double d6 = point2D.getY() + Math.sin(d4) * this.getRadius();
        Point2D point2D2 = new Point2D(d5, d6);
        return point2D2;
    }

    public GeoArc clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoArc(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoArcNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    protected static double[] valueToUGC(double d, double d2, double d3, double d4) {
        int n = (int)d;
        int n2 = n / 360;
        d -= (double)(360 * n2);
        if (d2 < 0.0) {
            d3 = d + d2;
            d4 = d;
        } else {
            d3 = d;
            d4 = d + d2;
        }
        double[] dArray = new double[]{d3, d4};
        return dArray;
    }
}

