/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfoNative;
import com.supermap.data.EngineType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.Locale;

public class DatasourceConnectionInfo
extends InternalHandleDisposable {
    private boolean _$3 = false;

    public DatasourceConnectionInfo() {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    public DatasourceConnectionInfo(String string, String string2, String string3, String string4, String string5) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (string3 == null || string3.trim().length() == 0) {
            String string6 = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        this.reset(string, "", string2, string3, string4, string5, EngineType.ORACLEPLUS);
    }

    public DatasourceConnectionInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (string2 == null) {
            string2 = "SQL Server";
        }
        if (string4 == null || string4.trim().length() == 0) {
            String string7 = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        this.reset(string, string2, string3, string4, string5, string6, EngineType.SQLPLUS);
    }

    public DatasourceConnectionInfo(String string, String string2, String string3) {
        long l = DatasourceConnectionInfoNative.jni_New();
        this.setHandle(l, true);
        if (string2 == null || string2.trim().length() == 0) {
            String string4 = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        this.reset(string, "", "", string2, "", string3, EngineType.UDB);
    }

    public String getAlias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetAlias(this.getHandle());
    }

    public void setAlias(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setAlias()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        DatasourceConnectionInfoNative.jni_SetAlias(this.getHandle(), string);
    }

    public EngineType getEngineType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasourceConnectionInfoNative.jni_GetEngineType(this.getHandle());
        EngineType engineType = null;
        try {
            engineType = (EngineType)Enum.parseUGCValue(EngineType.class, n);
        }
        catch (Exception exception) {
            engineType = new EngineType(n, n);
        }
        return engineType;
    }

    public void setEngineType(EngineType engineType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("setEngineType()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (engineType.equals(EngineType.IMAGEPLUGINS)) {
            this.setReadOnly(true);
        }
        int n = engineType.getUGCValue();
        DatasourceConnectionInfoNative.jni_SetEngineType(this.getHandle(), n);
    }

    public String getServer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetServer(this.getHandle());
    }

    public void setServer(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setServer()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (Locale.getDefault().equals(Locale.JAPANESE)) {
            string = string.replaceAll("\\\\", "/");
        }
        DatasourceConnectionInfoNative.jni_SetServer(this.getHandle(), string);
    }

    public String getDatabase() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetDataBase(this.getHandle());
    }

    public void setDatabase(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setDatabase()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null) {
            string = "";
        }
        DatasourceConnectionInfoNative.jni_SetDataBase(this.getHandle(), string);
    }

    public String getUser() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetUser(this.getHandle());
    }

    public void setUser(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setUser()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null) {
            string = "";
        }
        DatasourceConnectionInfoNative.jni_SetUser(this.getHandle(), string);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setPassword()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null) {
            string = "";
        }
        DatasourceConnectionInfoNative.jni_SetPassword(this.getHandle(), string);
    }

    public String getDriver() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetDriver(this.getHandle());
    }

    public void setDriver(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setDriver()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (string == null) {
            string = "SQL Server";
        }
        DatasourceConnectionInfoNative.jni_SetDriver(this.getHandle(), string);
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetReadOnly(this.getHandle());
    }

    public void setReadOnly(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("setIsReadOnly()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetReadOnly(this.getHandle(), bl);
    }

    public boolean isAutoConnect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetAutoConnect(this.getHandle());
    }

    public void setAutoConnect(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("setIsAutoConnect(boolean value)", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetAutoConnect(this.getHandle(), bl);
    }

    public boolean isOpenLinkTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_GetIsOpenLinkTable(this.getHandle());
    }

    public void setOpenLinkTable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3) {
            String string = InternalResource.loadString("setIsOpenLinkTable(boolean value)", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        DatasourceConnectionInfoNative.jni_SetIsOpenLinkTable(this.getHandle(), bl);
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$3) {
            String string3 = InternalResource.loadString("setConnectionIncrementStep()", "DatasourceConnInfo_CantSetProperty", "data_resources");
            throw new UnsupportedOperationException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = DatasourceConnectionInfoNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasourceConnectionInfoNative.jni_ToXML(this.getHandle());
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasourceConnectionInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Alias = ");
        stringBuffer.append(this.getAlias());
        stringBuffer.append(",EngineType = ");
        stringBuffer.append(this.getEngineType().name());
        stringBuffer.append(",Server = ");
        stringBuffer.append(this.getServer());
        stringBuffer.append(",Database = ");
        stringBuffer.append(this.getDatabase());
        stringBuffer.append(",Driver = ");
        stringBuffer.append(this.getDriver());
        stringBuffer.append(",User = ");
        stringBuffer.append(this.getUser());
        stringBuffer.append(",Password = ");
        stringBuffer.append(this.getPassword());
        stringBuffer.append(",IsReadOnly = ");
        stringBuffer.append(this.isReadOnly());
        stringBuffer.append(",IsAutoConnect = ");
        stringBuffer.append(this.isAutoConnect());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(DatasourceConnectionInfo datasourceConnectionInfo) {
        datasourceConnectionInfo.clearHandle();
    }

    DatasourceConnectionInfo(long l) {
        this.setHandle(l, false);
    }

    DatasourceConnectionInfo(Datasource datasource, long l) {
        if (datasource == null || datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$3 = true;
        this.setHandle(l, false);
    }

    void reset() {
        this.reset("", "", "", "UntitledDatasource", "", "", EngineType.UDB);
    }

    void reset(String string, String string2, String string3, String string4, String string5, String string6, EngineType engineType) {
        if (string4 == null || string4.trim().length() == 0) {
            String string7 = InternalResource.loadString("alias", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string7);
        }
        if (Locale.getDefault().equals(Locale.JAPANESE)) {
            string = string.replaceAll("\\\\", "/");
        }
        if (this.getHandle() != 0L) {
            int n = engineType.getUGCValue();
            DatasourceConnectionInfoNative.jni_Reset(this.getHandle(), string, string2, string3, string4, string5, string6, n);
        }
    }

    protected static DatasourceConnectionInfo createInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new DatasourceConnectionInfo(l);
    }
}

