/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetClosedEvent;
import com.supermap.data.DatasetClosedListener;
import com.supermap.data.DatasetClosingEvent;
import com.supermap.data.DatasetClosingListener;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridCollection;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetImageCollection;
import com.supermap.data.DatasetImageNative;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfoNative;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Dataset
extends InternalHandle {
    protected Datasource m_datasource = null;
    transient CopyOnWriteArrayList<DatasetClosingListener> m_datasetClosingListeners;
    transient CopyOnWriteArrayList<DatasetClosedListener> m_datasetClosedListeners;
    transient CopyOnWriteArrayList<SteppedListener> m_steppedListeners;
    protected long m_selfEventHandle;
    protected static String m_senderMethodName;
    private PrjCoordSys _$2;

    protected Dataset() {
        m_senderMethodName = "PJConvert";
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null) {
            DatasetNative.jni_UnSetPrjCoordSys(this.getHandle());
            if (this._$2 != null) {
                this._$2.clearHandle();
                this._$2 = null;
            }
        } else {
            long l = InternalHandle.getHandle(prjCoordSys);
            if (l == 0L) {
                String string = InternalResource.loadString("value", "Global_InvalidConstructorArgument", "data_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetNative.jni_Open(this.getHandle());
            boolean bl = DatasetNative.jni_setPrjCoordSys(this.getHandle(), l);
            if (bl) {
                this._$2 = prjCoordSys.clone();
            }
            InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        }
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.isOpen()) {
            this.open();
        }
        if (this._$2 == null && (l = DatasetNative.jni_getPrjCoordSys(this.getHandle())) != 0L) {
            this._$2 = PrjCoordSys.createInstance(l, false);
        }
        return this._$2;
    }

    public boolean hasVersion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasVersion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_hasVersion(this.getHandle());
    }

    public boolean hasPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_HasSetPrjCoordSys(this.getHandle());
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean isReadOnly() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = this.m_datasource.isReadOnly();
        boolean bl2 = DatasetNative.jni_GetIsReadOnly(this.getHandle());
        return bl || bl2;
    }

    public boolean isOpen() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsOpen(this.getHandle());
    }

    public Datasource getDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasource;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        DatasetNative.jni_SetDescription(this.getHandle(), string);
    }

    public String getExtInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetExtInfo(this.getHandle());
    }

    public void setExtInfo(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            string = "";
        }
        if (string.length() > 2047) {
            throw new IllegalStateException("The length is outof range");
        }
        DatasetNative.jni_SetExtInfo(this.getHandle(), string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetName(this.getHandle());
    }

    public String getTableName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetTableName(this.getHandle());
    }

    public DatasetType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetType(this.getHandle());
        DatasetType datasetType = null;
        try {
            datasetType = (DatasetType)Enum.parseUGCValue(DatasetType.class, n);
        }
        catch (RuntimeException runtimeException) {
            if (n == DatasetType.DEM.getUGCValue()) {
                datasetType = DatasetType.GRID;
            }
            throw runtimeException;
        }
        return datasetType;
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetClosingEvent datasetClosingEvent = new DatasetClosingEvent(this, this);
        this.fireClosing(datasetClosingEvent);
        if (datasetClosingEvent.getCancel()) {
            return;
        }
        DatasetNative.jni_Close(this.getHandle());
        DatasetClosedEvent datasetClosedEvent = new DatasetClosedEvent(this, this);
        this.fireClosed(datasetClosedEvent);
    }

    public boolean open() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_Open(this.getHandle());
    }

    boolean rename(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string3 = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (!this.m_datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("newName", "Dataset_NameIsNotAvailabe", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        boolean bl = DatasetNative.jni_Rename(this.getHandle(), string);
        return bl;
    }

    public void setReadOnly(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetNative.jni_SetReadOnly(this.getHandle(), bl);
    }

    protected void clearHandle() {
        this.m_datasource = null;
        this._$2 = null;
        this.setHandle(0L);
    }

    static InternalInvalidState isValidDatasetName(String string) {
        int n = FieldInfoNative.jni_IsValidTableName(string);
        if (n == -1) {
            return null;
        }
        return (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
    }

    protected static Dataset createInstance(long l, DatasetType datasetType, Datasource datasource) {
        if (l == 0L) {
            String string = InternalResource.loadString("", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalStateException(string);
        }
        Dataset dataset = null;
        dataset = datasetType.equals(DatasetType.IMAGE) || datasetType.equals(DatasetType.WCS) || datasetType.equals(DatasetType.WMS) ? new DatasetImage(l, datasource) : (datasetType.equals(DatasetType.GRID) || datasetType.equals(DatasetType.DEM) ? new DatasetGrid(l, datasource) : (datasetType.equals(DatasetType.CAD) || datasetType.equals(DatasetType.LINE) || datasetType.equals(DatasetType.POINT) || datasetType.equals(DatasetType.REGION) || datasetType.equals(DatasetType.TABULAR) || datasetType.equals(DatasetType.LINEM) || datasetType.equals(DatasetType.NETWORK) || datasetType.equals(DatasetType.LINKTABLE) || datasetType.equals(DatasetType.TEXT) || datasetType.equals(DatasetType.POINT3D) || datasetType.equals(DatasetType.LINE3D) || datasetType.equals(DatasetType.REGION3D) || datasetType.equals(DatasetType.PARAMETRICLINE) || datasetType.equals(DatasetType.PARAMETRICREGION) || datasetType.equals(DatasetType.MODEL) || datasetType.equals(DatasetType.NETWORK3D) ? new DatasetVector(l, datasource) : (datasetType.equals(DatasetType.TOPOLOGY) ? new DatasetTopology(l, datasource) : (datasetType.equals(DatasetType.GRIDCOLLECTION) ? new DatasetGridCollection(l, datasource) : (datasetType.equals(DatasetType.IMAGECOLLECTION) ? new DatasetImageCollection(l, datasource) : null)))));
        return dataset;
    }

    protected static boolean isVector(Dataset dataset) {
        boolean bl = true;
        bl = dataset == null || dataset.getHandle() == 0L ? false : dataset._$1();
        return bl;
    }

    private boolean _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetNative.jni_GetIsVector(this.getHandle());
    }

    public synchronized void addClosingListener(DatasetClosingListener datasetClosingListener) {
        if (this.m_datasetClosingListeners == null) {
            this.m_datasetClosingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetClosingListeners.contains(datasetClosingListener)) {
            this.m_datasetClosingListeners.add(datasetClosingListener);
        }
    }

    public void removeClosingListener(DatasetClosingListener datasetClosingListener) {
        if (this.m_datasetClosingListeners != null && this.m_datasetClosingListeners.contains(datasetClosingListener)) {
            this.m_datasetClosingListeners.remove(datasetClosingListener);
        }
    }

    protected void fireClosing(DatasetClosingEvent datasetClosingEvent) {
        if (this.m_datasetClosingListeners != null) {
            CopyOnWriteArrayList<DatasetClosingListener> copyOnWriteArrayList = this.m_datasetClosingListeners;
            for (DatasetClosingListener datasetClosingListener : copyOnWriteArrayList) {
                datasetClosingListener.datasetClosing(datasetClosingEvent);
            }
        }
    }

    public synchronized void addClosedListener(DatasetClosedListener datasetClosedListener) {
        if (this.m_datasetClosedListeners == null) {
            this.m_datasetClosedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_datasetClosedListeners.contains(datasetClosedListener)) {
            this.m_datasetClosedListeners.add(datasetClosedListener);
        }
    }

    public void removeClosedListener(DatasetClosedListener datasetClosedListener) {
        if (this.m_datasetClosedListeners != null && this.m_datasetClosedListeners.contains(datasetClosedListener)) {
            this.m_datasetClosedListeners.remove(datasetClosedListener);
        }
    }

    protected void fireClosed(DatasetClosedEvent datasetClosedEvent) {
        if (this.m_datasetClosedListeners != null) {
            CopyOnWriteArrayList<DatasetClosedListener> copyOnWriteArrayList = this.m_datasetClosedListeners;
            for (DatasetClosedListener datasetClosedListener : copyOnWriteArrayList) {
                datasetClosedListener.datasetClosed(datasetClosedEvent);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            CopyOnWriteArrayList<SteppedListener> copyOnWriteArrayList = this.m_steppedListeners;
            for (SteppedListener steppedListener : copyOnWriteArrayList) {
                steppedListener.stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Dataset dataset, int n, long l, String string, String string2) {
        if (dataset != null) {
            SteppedEvent steppedEvent = new SteppedEvent(dataset, n, l, string, string2, m_senderMethodName);
            dataset.fireStepped(steppedEvent);
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            DatasetImageNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }
}

