/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart.conversion;

import com.supermap.chart.conversion.FileTypeChart;
import com.supermap.chart.conversion.ImportSettingChartNative;
import com.supermap.chart.conversion.InternalDatasourceConnectionInfo;
import com.supermap.chart.conversion.InternalEnum;
import com.supermap.chart.conversion.InternalPrjCoordSys;
import com.supermap.chart.conversion.InternalResource;
import com.supermap.data.DatasetGroup;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EncodeType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSys;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportSettingChart
extends InternalHandleDisposable {
    private DatasourceConnectionInfo _$6;
    private PrjCoordSys _$5;
    private ArrayList<Boolean> _$4;
    private Datasource _$3;
    private boolean _$2 = false;
    private DatasetGroup _$1;

    protected ImportSettingChart() {
    }

    public String getSourceFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingChartNative.jni_GetSourceFilePath(this.getHandle());
    }

    public void setSourceFilePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setSourceFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string4 = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string4);
        }
        ImportSettingChartNative.jni_SetSourceFilePath(this.getHandle(), file.getPath());
    }

    public FileTypeChart getSourceFileTypeChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFileTypeChart()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingChartNative.jni_GetSourceFileType(this.getHandle());
        return (FileTypeChart)InternalEnum.parseUGCValue(FileTypeChart.class, n);
    }

    public DatasourceConnectionInfo getTargetDatasourceConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setTargetDatasourceConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasourceConnectionInfo()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (datasourceConnectionInfo == null) {
            if (this._$6 != null) {
                InternalDatasourceConnectionInfo.clearHandle(this._$6);
                this._$6 = null;
            }
        } else {
            long l = InternalHandle.getHandle((InternalHandle)datasourceConnectionInfo);
            if (l == 0L) {
                String string = InternalResource.loadString("setTargetDatasourceConnectionInfo(DatasourceConnectionInfo connectionInfo)", "Datasources_ConnectionInfoIsInvalid", "conversion_resources");
                throw new IllegalStateException(string);
            }
            this._$6 = this.cloneDatasourceConnectionInfo(datasourceConnectionInfo);
            this.setTargetDatasource(null);
            this.setTargetDatasetGroup(null);
        }
    }

    public Datasource getTargetDatasource() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasource()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$3;
    }

    public void setTargetDatasource(Datasource datasource) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasource(Datasource datasource)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this._$3 = datasource;
        if (this._$3 != null) {
            this.setTargetDatasourceConnectionInfo(null);
            this.setTargetDatasetGroup(null);
        }
    }

    public DatasetGroup getTargetDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDatasetGroup()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    public void setTargetDatasetGroup(DatasetGroup datasetGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetDatasetGroup(DatasetGroup datasetGroup)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this._$1 = datasetGroup;
        if (this._$1 != null) {
            this.setTargetDatasourceConnectionInfo(null);
            this.setTargetDatasource(null);
        }
    }

    public EncodeType getTargetEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetEncodeType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingChartNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    public void setTargetEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetEncodeType(EncodeType encodeType )", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingChartNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    protected void clearHandle() {
        if (this._$5 != null) {
            InternalPrjCoordSys.clearHandle(this._$5);
            this._$5 = null;
        }
        this._$6 = null;
        this.setHandle(0L);
    }

    protected DatasourceConnectionInfo cloneDatasourceConnectionInfo(DatasourceConnectionInfo datasourceConnectionInfo) {
        long l = InternalHandle.getHandle((InternalHandle)datasourceConnectionInfo);
        long l2 = ImportSettingChartNative.jni_CloneDatasourceConnectionInfo(l);
        DatasourceConnectionInfo datasourceConnectionInfo2 = InternalDatasourceConnectionInfo.createInstance(l2);
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)datasourceConnectionInfo2, (boolean)true);
        return datasourceConnectionInfo2;
    }

    ArrayList<Boolean> getStates() {
        return this._$4;
    }

    void setStates(ArrayList<Boolean> arrayList) {
        this._$4 = arrayList;
    }

    public boolean isConvertToMercator() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isConvertToMercator()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        this._$2 = ImportSettingChartNative.jni_IsConvertToMercator(this.getHandle());
        return this._$2;
    }

    public void setConvertToMercator(boolean bl) {
        this._$2 = bl;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConvertToMercator(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingChartNative.jni_SetConvertToMercator(this.getHandle(), bl);
    }
}

