/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements InitializingBean {
    private static final int DEFAULT_FAILURE_THRESHOLD = 100;
    private static final int DEFAULT_FAILURE_RANGE_IN_SECONDS = 60;
    private static final String DEFAULT_USERNAME_PARAMETER = "username";
    private static final String SUCCESSFUL_AUTHENTICATION_EVENT = "success";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Min(value=0L)
    private int failureThreshold = 100;
    @Min(value=0L)
    private int failureRangeInSeconds = 60;
    @NotNull
    private String usernameParameter = "username";
    private double thresholdRate;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public void afterPropertiesSet() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        AbstractThrottledSubmissionHandlerInterceptorAdapter.afterPropertiesSet_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        Object object = o;
        Object[] objectArray = new Object[]{httpServletRequest, httpServletResponse, object};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        return Conversions.booleanValue((Object)AbstractThrottledSubmissionHandlerInterceptorAdapter.preHandle_aroundBody3$advice(this, httpServletRequest, httpServletResponse, object, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public final void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
        HttpServletRequest httpServletRequest = request;
        HttpServletResponse httpServletResponse = response;
        Object object = o;
        ModelAndView modelAndView2 = modelAndView;
        Object[] objectArray = new Object[]{httpServletRequest, httpServletResponse, object, modelAndView2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        AbstractThrottledSubmissionHandlerInterceptorAdapter.postHandle_aroundBody5$advice(this, httpServletRequest, httpServletResponse, object, modelAndView2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public final void setFailureRangeInSeconds(int failureRangeInSeconds) {
        this.failureRangeInSeconds = failureRangeInSeconds;
    }

    public final void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    protected double getThresholdRate() {
        return this.thresholdRate;
    }

    protected int getFailureThreshold() {
        return this.failureThreshold;
    }

    protected int getFailureRangeInSeconds() {
        return this.failureRangeInSeconds;
    }

    protected String getUsernameParameter() {
        return this.usernameParameter;
    }

    protected void recordThrottle(HttpServletRequest request) {
        this.log.warn("Throttling submission from {}.  More than {} failed login attempts within {} seconds.", new Object[]{request.getRemoteAddr(), this.failureThreshold, this.failureRangeInSeconds});
    }

    protected abstract void recordSubmissionFailure(HttpServletRequest var1);

    protected abstract boolean exceedsThreshold(HttpServletRequest var1);

    static {
        AbstractThrottledSubmissionHandlerInterceptorAdapter.ajc$preClinit();
    }

    private static final /* synthetic */ Object afterPropertiesSet_aroundBody1$advice(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            ajc$this.thresholdRate = (double)ajc$this.failureThreshold / (double)ajc$this.failureRangeInSeconds;
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ boolean preHandle_aroundBody2(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, JoinPoint joinPoint) {
        if (!"POST".equals(request.getMethod())) {
            return true;
        }
        if (ajc$this.exceedsThreshold(request)) {
            ajc$this.recordThrottle(request);
            response.sendError(403, "Access Denied for user [" + request.getParameter(ajc$this.usernameParameter) + " from IP Address [" + request.getRemoteAddr() + "]");
            return false;
        }
        return true;
    }

    private static final /* synthetic */ Object preHandle_aroundBody3$advice(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            object = returnVal = Conversions.booleanObject((boolean)AbstractThrottledSubmissionHandlerInterceptorAdapter.preHandle_aroundBody2(ajc$this, request, response, o, (JoinPoint)proceedingJoinPoint2));
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static final /* synthetic */ void postHandle_aroundBody4(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView, JoinPoint joinPoint) {
        if (!"POST".equals(request.getMethod())) {
            return;
        }
        RequestContext context = (RequestContext)request.getAttribute("flowRequestContext");
        if (context == null || context.getCurrentEvent() == null) {
            return;
        }
        if (SUCCESSFUL_AUTHENTICATION_EVENT.equals(context.getCurrentEvent().getId())) {
            return;
        }
        ajc$this.recordSubmissionFailure(request);
    }

    private static final /* synthetic */ Object postHandle_aroundBody5$advice(AbstractThrottledSubmissionHandlerInterceptorAdapter ajc$this, HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            AbstractThrottledSubmissionHandlerInterceptorAdapter.postHandle_aroundBody4(ajc$this, request, response, o, modelAndView, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractThrottledSubmissionHandlerInterceptorAdapter.java", AbstractThrottledSubmissionHandlerInterceptorAdapter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "", "", "java.lang.Exception", "void"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "preHandle", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:java.lang.Object", "request:response:o", "java.lang.Exception", "boolean"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "postHandle", "org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter", "javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:java.lang.Object:org.springframework.web.servlet.ModelAndView", "request:response:o:modelAndView", "java.lang.Exception", "void"), 86);
    }
}

