/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.CrudInvoker;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.support.CrudRepositoryInvoker;
import org.springframework.data.repository.support.ReflectionRepositoryInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Repositories
implements Iterable<Class<?>> {
    static final Repositories NONE = new Repositories();
    private final Map<Class<?>, RepositoryFactoryInformation<Object, Serializable>> domainClassToBeanName = new HashMap();
    private final Map<RepositoryFactoryInformation<Object, Serializable>, String> repositories = new HashMap<RepositoryFactoryInformation<Object, Serializable>, String>();
    private final BeanFactory beanFactory;
    private final Set<String> repositoryFactoryBeanNames = new HashSet<String>();

    private Repositories() {
        this.beanFactory = null;
    }

    public Repositories(ListableBeanFactory factory) {
        Assert.notNull((Object)factory);
        this.beanFactory = factory;
        String[] beanNamesForType = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, RepositoryFactoryInformation.class, (boolean)false, (boolean)false);
        this.repositoryFactoryBeanNames.addAll(Arrays.asList(beanNamesForType));
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        this.lookupRepositoryFactoryInformationFor(domainClass);
        return this.domainClassToBeanName.containsKey(domainClass);
    }

    public Object getRepositoryFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        if (information == null) {
            return null;
        }
        return this.beanFactory.getBean(this.repositories.get(information));
    }

    public <T, S extends Serializable> EntityInformation<T, S> getEntityInformationFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getEntityInformation();
    }

    public RepositoryInformation getRepositoryInformationFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getRepositoryInformation();
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getPersistentEntity();
    }

    public List<QueryMethod> getQueryMethodsFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? Collections.emptyList() : information.getQueryMethods();
    }

    public <T> CrudInvoker<T> getCrudInvoker(Class<T> domainClass) {
        RepositoryInformation information = this.getRepositoryInformationFor(domainClass);
        Object repository = this.getRepositoryFor(domainClass);
        Assert.notNull((Object)repository, (String)String.format("No repository found for domain class: %s", domainClass));
        if (repository instanceof CrudRepository) {
            return new CrudRepositoryInvoker((CrudRepository)repository);
        }
        return new ReflectionRepositoryInvoker(repository, information.getCrudMethods());
    }

    private RepositoryFactoryInformation<Object, Serializable> getRepoInfoFor(Class<?> domainClass) {
        Assert.notNull(domainClass);
        Set<RepositoryFactoryInformation<Object, Serializable>> keys = Collections.unmodifiableSet(this.repositories.keySet());
        Class type = ClassUtils.getUserClass(domainClass);
        for (RepositoryFactoryInformation<Object, Serializable> information : keys) {
            if (!type.equals(information.getEntityInformation().getJavaType())) continue;
            return information;
        }
        return this.lookupRepositoryFactoryInformationFor(type);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        this.lookupRepositoryFactoryInformationFor(null);
        return this.domainClassToBeanName.keySet().iterator();
    }

    private RepositoryFactoryInformation<Object, Serializable> lookupRepositoryFactoryInformationFor(Class<?> domainType) {
        if (this.domainClassToBeanName.containsKey(domainType)) {
            return this.domainClassToBeanName.get(domainType);
        }
        for (String repositoryFactoryName : this.repositoryFactoryBeanNames) {
            RepositoryFactoryInformation information = (RepositoryFactoryInformation)this.beanFactory.getBean(repositoryFactoryName, RepositoryFactoryInformation.class);
            RepositoryInformation info = information.getRepositoryInformation();
            this.repositories.put(information, BeanFactoryUtils.transformedBeanName((String)repositoryFactoryName));
            this.domainClassToBeanName.put(info.getDomainType(), information);
            if (!info.getDomainType().equals(domainType)) continue;
            return information;
        }
        return null;
    }
}

