/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Iterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.Table;
import org.xml.sax.Locator;

public class RetrieveMarker
extends FObjMixed {
    private String retrieveClassName;
    private int retrievePosition;
    private int retrieveBoundary;
    private PropertyList propertyList;

    public RetrieveMarker(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        if (this.findAncestor(45) < 0) {
            this.invalidChildError(this.locator, "http://www.w3.org/1999/XSL/Format", "retrieve-marker", "An fo:retrieve-marker is permitted only as the  descendant of an fo:static-content.");
        }
        this.retrieveClassName = pList.get(186).getString();
        this.retrievePosition = pList.get(187).getEnum();
        this.retrieveBoundary = pList.get(185).getEnum();
        if (this.retrieveClassName == null || this.retrieveClassName.equals("")) {
            this.missingPropertyError("retrieve-class-name");
        }
        this.propertyList = pList.getParentPropertyList();
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public String getRetrieveClassName() {
        return this.retrieveClassName;
    }

    public int getRetrievePosition() {
        return this.retrievePosition;
    }

    public int getRetrieveBoundary() {
        return this.retrieveBoundary;
    }

    private PropertyList createPropertyListFor(FObj fo, PropertyList parent) {
        return this.getFOEventHandler().getPropertyListMaker().make(fo, parent);
    }

    private void cloneSingleNode(FONode child, FONode newParent, Marker marker, PropertyList parentPropertyList) throws FOPException {
        if (child != null) {
            FONode newChild = child.clone(newParent, true);
            if (child instanceof FObj) {
                PropertyList newPropertyList = this.createPropertyListFor((FObj)newChild, parentPropertyList);
                Marker.MarkerPropertyList pList = marker.getPropertyListFor(child);
                newChild.processNode(child.getLocalName(), this.getLocator(), pList, newPropertyList);
                if (newChild.getNameId() == 46) {
                    Table t = (Table)child;
                    this.cloneSubtree(t.getColumns().listIterator(), newChild, marker, newPropertyList);
                    this.cloneSingleNode(t.getTableHeader(), newChild, marker, newPropertyList);
                    this.cloneSingleNode(t.getTableFooter(), newChild, marker, newPropertyList);
                }
                this.cloneSubtree(child.getChildNodes(), newChild, marker, newPropertyList);
            } else if (child instanceof FOText) {
                FOText ft = (FOText)newChild;
                ft.bind(parentPropertyList);
            }
            RetrieveMarker.addChildTo(newChild, (FObj)newParent);
            if (newChild instanceof FObjMixed) {
                RetrieveMarker.handleWhiteSpaceFor((FObjMixed)newChild);
            }
        }
    }

    private void cloneSubtree(Iterator parentIter, FONode newParent, Marker marker, PropertyList parentPropertyList) throws FOPException {
        if (parentIter != null) {
            while (parentIter.hasNext()) {
                FONode child = (FONode)parentIter.next();
                this.cloneSingleNode(child, newParent, marker, parentPropertyList);
            }
        }
    }

    private void cloneFromMarker(Marker marker) throws FOPException {
        if (this.firstChild != null) {
            this.currentTextNode = null;
            this.firstChild = null;
        }
        this.cloneSubtree(marker.getChildNodes(), this, marker, this.propertyList);
    }

    public void bindMarker(Marker marker) {
        if (marker.getChildNodes() != null) {
            try {
                this.cloneFromMarker(marker);
            }
            catch (FOPException exc) {
                log.error((Object)("fo:retrieve-marker unable to clone subtree of fo:marker (marker-class-name=" + marker.getMarkerClassName() + ")"), (Throwable)exc);
                return;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Empty marker retrieved...");
        }
    }

    public String getLocalName() {
        return "retrieve-marker";
    }

    public int getNameId() {
        return 41;
    }
}

