/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Collection;
import org.activiti.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class RemoveExecutionVariablesCmd
extends NeedsActiveExecutionCmd<Void> {
    private static final long serialVersionUID = 1L;
    private Collection<String> variableNames;
    private boolean isLocal;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        super(executionId);
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    protected Void execute(CommandContext commandContext, ExecutionEntity execution) {
        if (this.isLocal) {
            execution.removeVariablesLocal(this.variableNames);
        } else {
            execution.removeVariables(this.variableNames);
        }
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot remove variables because execution '" + this.executionId + "' is suspended";
    }
}

