/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.servlet;

import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.HttpFlexSessionProvider;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.io.SerializationContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

public class MessageBrokerHandlerAdapter
implements HandlerAdapter,
ServletConfigAware {
    private static final Log logger = LogFactory.getLog(MessageBrokerHandlerAdapter.class);
    private ServletConfig servletConfig;

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handle(HttpServletRequest req, HttpServletResponse res, Object handler) throws Exception {
        MessageBroker broker = (MessageBroker)handler;
        try {
            broker.initThreadLocals();
            FlexContext.setThreadLocalObjects(null, null, (MessageBroker)broker, (HttpServletRequest)req, (HttpServletResponse)res, (ServletConfig)this.servletConfig);
            AbstractFlexSessionProvider providerToCheck = broker.getFlexSessionManager().getFlexSessionProvider(HttpFlexSession.class);
            Assert.isInstanceOf(HttpFlexSessionProvider.class, (Object)providerToCheck, (String)("MessageBrokerHandlerAdapter requires an instance of " + HttpFlexSessionProvider.class.getName() + " to have been registered with the MessageBroker."));
            HttpFlexSessionProvider provider = (HttpFlexSessionProvider)providerToCheck;
            provider.getOrCreateSession(req);
            String contextPath = req.getContextPath();
            String pathInfo = req.getPathInfo();
            String endpointPath = req.getServletPath();
            if (pathInfo != null) {
                endpointPath = endpointPath + pathInfo;
            }
            Endpoint endpoint = null;
            try {
                endpoint = broker.getEndpoint(endpointPath, contextPath);
            }
            catch (MessageException me) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Received invalid request for endpoint path '" + endpointPath + "'."));
                }
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
                ModelAndView modelAndView = null;
                FlexContext.clearThreadLocalObjects();
                SerializationContext.clearThreadLocalObjects();
                return modelAndView;
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Channel endpoint " + endpoint.getId() + " received request."));
                }
                endpoint.service(req, res);
            }
            catch (UnsupportedOperationException ue) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Channel endpoint " + endpoint.getId() + " received request for an unsupported operation."), (Throwable)ue);
                }
                if (!res.isCommitted()) {
                    res.sendError(405);
                }
            }
        }
        finally {
            FlexContext.clearThreadLocalObjects();
            SerializationContext.clearThreadLocalObjects();
        }
        return null;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public boolean supports(Object handler) {
        return handler instanceof MessageBroker;
    }
}

