/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.messaging;

import flex.messaging.MessageBroker;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.AMFEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.services.MessageService;
import flex.messaging.services.Service;
import flex.messaging.services.messaging.adapters.ActionScriptAdapter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.flex.core.AbstractServiceConfigProcessor;
import org.springframework.util.CollectionUtils;

public class MessageServiceConfigProcessor
extends AbstractServiceConfigProcessor {
    private static final Log log = LogFactory.getLog(MessageServiceConfigProcessor.class);

    public void findDefaultChannel(MessageBroker broker, Service service) {
        if (!CollectionUtils.isEmpty((Collection)broker.getDefaultChannels())) {
            return;
        }
        Iterator channels = broker.getChannelIds().iterator();
        while (channels.hasNext()) {
            Endpoint endpoint = broker.getEndpoint((String)channels.next());
            if (!(endpoint instanceof AMFEndpoint) || !this.isPollingEnabled(endpoint)) continue;
            service.addDefaultChannel(endpoint.getId());
            return;
        }
        log.warn((Object)"No appropriate default channels were detected for the MessageService.  The channels must be explicitly set on any exported service.");
    }

    protected String getServiceAdapterClassName() {
        return ActionScriptAdapter.class.getName();
    }

    protected String getServiceAdapterId() {
        return "actionscript";
    }

    protected String getServiceClassName() {
        return MessageService.class.getName();
    }

    protected String getServiceId() {
        return "message-service";
    }

    private boolean isPollingEnabled(Endpoint endpoint) {
        ConfigMap endpointConfig = endpoint.describeEndpoint().getPropertyAsMap("properties", null);
        if (endpointConfig != null && endpointConfig.getPropertyAsMap("polling-enabled", null) != null) {
            return endpointConfig.getPropertyAsMap("polling-enabled", null).getPropertyAsBoolean("", false);
        }
        return false;
    }
}

