/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.http;

import flex.messaging.FlexContext;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.Amf3Output;
import flex.messaging.io.amf.AmfTrace;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmfView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/x-amf";
    private static final Log log = LogFactory.getLog(AmfView.class);
    private Set<String> renderedAttributes;
    private boolean disableCaching = true;

    public AmfView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
    }

    public Set<String> getRenderedAttributes() {
        return this.renderedAttributes;
    }

    public void setRenderedAttributes(Set<String> renderedAttributes) {
        this.renderedAttributes = renderedAttributes;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getContentType());
        response.setCharacterEncoding("UTF-8");
        if (this.disableCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object value = this.filterModel(model);
        try {
            AmfTrace trace = null;
            if (log.isDebugEnabled()) {
                trace = new AmfTrace();
            }
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            SerializationContext context = new SerializationContext();
            Amf3Output out = new Amf3Output(context);
            if (trace != null) {
                out.setDebugTrace(trace);
            }
            out.setOutputStream((OutputStream)outBuffer);
            out.writeObject(value);
            out.flush();
            outBuffer.flush();
            response.setContentLength(outBuffer.size());
            outBuffer.writeTo((OutputStream)response.getOutputStream());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrote AMF message:\n" + trace));
            }
        }
        finally {
            FlexContext.clearThreadLocalObjects();
            SerializationContext.clearThreadLocalObjects();
        }
    }

    protected Object filterModel(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> renderedAttributes = !CollectionUtils.isEmpty(this.renderedAttributes) ? this.renderedAttributes : model.keySet();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (entry.getValue() instanceof BindingResult || !renderedAttributes.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        if (result.size() == 1) {
            return result.values().iterator().next();
        }
        return result;
    }
}

