/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.MessageBroker;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginManager;
import org.springframework.flex.config.MessageBrokerConfigProcessor;

public class LoginCommandConfigProcessor
implements MessageBrokerConfigProcessor {
    private final LoginCommand loginCommand;
    private boolean perClientAuthentication = false;

    public LoginCommandConfigProcessor(LoginCommand loginCommand) {
        this.loginCommand = loginCommand;
    }

    public MessageBroker processAfterStartup(MessageBroker broker) {
        return broker;
    }

    public MessageBroker processBeforeStartup(MessageBroker broker) {
        LoginManager loginManager = broker.getLoginManager();
        loginManager.setLoginCommand(this.loginCommand);
        loginManager.setPerClientAuthentication(this.perClientAuthentication);
        return broker;
    }

    public void setPerClientAuthentication(boolean perClientAuthentication) {
        this.perClientAuthentication = perClientAuthentication;
    }
}

