/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BaseHTTPEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.flex.config.MessageBrokerConfigProcessor;
import org.springframework.flex.core.EndpointAdvisor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointConfigProcessor
implements MessageBrokerConfigProcessor,
BeanClassLoaderAware {
    private final EndpointAdvisor[] advisors;
    private ClassLoader proxyClassLoader = ClassUtils.getDefaultClassLoader();

    public EndpointConfigProcessor(List<EndpointAdvisor> advisors) {
        Assert.notEmpty(advisors, (String)"A non-empty list of EndpointServiceMessagePointcutAdvisors is required");
        this.advisors = advisors.toArray(new EndpointAdvisor[advisors.size()]);
    }

    @Override
    public MessageBroker processAfterStartup(MessageBroker broker) {
        for (String key : broker.getEndpoints().keySet()) {
            Endpoint endpoint = (Endpoint)broker.getEndpoints().get(key);
            if (!(endpoint instanceof BaseHTTPEndpoint)) continue;
            ProxyFactory factory = new ProxyFactory();
            factory.setProxyTargetClass(true);
            factory.addAdvisors((Advisor[])this.advisors);
            factory.setTarget((Object)endpoint);
            factory.setFrozen(true);
            Endpoint proxy = (Endpoint)factory.getProxy(this.proxyClassLoader);
            this.fixFilterChain(endpoint, proxy);
            broker.getEndpoints().put(key, proxy);
        }
        return broker;
    }

    @Override
    public MessageBroker processBeforeStartup(MessageBroker broker) {
        return broker;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
    }

    private void fixFilterChain(Object endpoint, Object proxy) {
        Field filterChainField = ReflectionUtils.findField(endpoint.getClass(), (String)"filterChain");
        if (filterChainField != null) {
            Assert.isAssignable(AMFFilter.class, filterChainField.getType(), (String)"filterChain field is expected to be of type AMFFilter");
            ReflectionUtils.makeAccessible((Field)filterChainField);
            for (AMFFilter filter = (AMFFilter)ReflectionUtils.getField((Field)filterChainField, (Object)endpoint); filter != null; filter = filter.getNext()) {
                Field endpointField = ReflectionUtils.findField(filter.getClass(), (String)"endpoint");
                if (endpointField == null) continue;
                ReflectionUtils.makeAccessible((Field)endpointField);
                ReflectionUtils.setField((Field)endpointField, (Object)filter, (Object)proxy);
            }
        }
    }
}

