/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.flex.config.RuntimeEnvironment;
import org.springframework.flex.config.xml.MessageInterceptors;
import org.springframework.flex.config.xml.ParsingUtils;
import org.springframework.flex.config.xml.SpringSecurityConfigHelper;
import org.springframework.flex.config.xml.SpringSecurityConfigResolver;
import org.springframework.flex.security3.AntPathRequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBrokerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME = "org.springframework.flex.core.MessageBrokerFactoryBean";
    private static final String MESSAGE_BROKER_HANDLER_ADAPTER_CLASS_NAME = "org.springframework.flex.servlet.MessageBrokerHandlerAdapter";
    private static final String DEFAULT_HANDLER_MAPPING_CLASS_NAME = "org.springframework.web.servlet.handler.SimpleUrlHandlerMapping";
    private static final String ENDPOINT_PROCESSOR_CLASS_NAME = "org.springframework.flex.core.EndpointConfigProcessor";
    private static final String EXCEPTION_TRANSLATION_CLASS_NAME = "org.springframework.flex.core.ExceptionTranslationAdvice";
    private static final String MESSAGE_INTERCEPTION_CLASS_NAME = "org.springframework.flex.core.MessageInterceptionAdvice";
    private static final String SERVICE_MESSAGE_ADVISOR_CLASS_NAME = "org.springframework.flex.core.EndpointServiceMessagePointcutAdvisor";
    private static final String REMOTING_PROCESSOR_CLASS_NAME = "org.springframework.flex.remoting.RemotingServiceConfigProcessor";
    private static final String MESSAGING_PROCESSOR_CLASS_NAME = "org.springframework.flex.messaging.MessageServiceConfigProcessor";
    private static final String DATASERVICES_PROCESSOR_CLASS_NAME = "flex.springintegration.core.DataServicesConfigProcessor";
    private static final String REMOTING_ANNOTATION_PROCESSOR_CLASS_NAME = "org.springframework.flex.config.RemotingAnnotationPostProcessor";
    private static final String HIBERNATE_CONFIG_PROCESSOR_CLASS_NAME = "org.springframework.flex.config.HibernateSerializationConfigPostProcessor";
    private static final String CUSTOM_EDITOR_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.config.CustomEditorConfigurer";
    private static final String JSON_CONFIG_MAP_EDITOR_CLASS_NAME = "org.springframework.flex.config.json.JsonConfigMapPropertyEditor";
    private static final String LOGIN_COMMAND_PROCESSOR_CLASS_NAME = "org.springframework.flex.core.LoginCommandConfigProcessor";
    private static final String CONFIG_MAP_CLASS_NAME = "flex.messaging.config.ConfigMap";
    private static final String CONFIGURATION_MANAGER_ATTR = "configuration-manager";
    private static final String EXCEPTION_LOGGER_ATTR = "exception-logger";
    private static final String SERVICES_CONFIG_PATH_ATTR = "services-config-path";
    private static final String MAPPING_ORDER_ATTR = "mapping-order";
    private static final String DISABLE_DEFAULT_MAPPING_ATTR = "disable-default-mapping";
    private static final String PATTERN_ATTR = "pattern";
    private static final String REF_ATTR = "ref";
    private static final String POSITION_ATTR = "position";
    private static final String BEFORE_ATTR = "before";
    private static final String AFTER_ATTR = "after";
    private static final String AUTH_MANAGER_ATTR = "authentication-manager";
    private static final String ACCESS_MANAGER_ATTR = "access-decision-manager";
    private static final String LOGIN_COMMAND_ATTR = "login-command";
    private static final String INVALIDATE_HTTP_SESSION_ATTR = "invalidate-http-session";
    private static final String PER_CLIENT_AUTHENTICATION_ATTR = "per-client-authentication";
    private static final String ACCESS_ATTR = "access";
    private static final String CHANNEL_ATTR = "channel";
    private static final String URL_MAP_PROPERTY = "urlMap";
    private static final String ORDER_PROPERTY = "order";
    private static final String CONFIG_PROCESSORS_PROPERTY = "configProcessors";
    private static final String INVALIDATE_HTTP_SESSION_PROPERTY = "invalidateHttpSession";
    private static final String PER_CLIENT_AUTHENTICATION_PROPERTY = "perClientAuthentication";
    private static final String AUTH_MANAGER_PROPERTY = "authenticationManager";
    private static final String ACCESS_MANAGER_PROPERTY = "accessDecisionManager";
    private static final String OBJECT_DEF_SOURCE_PROPERTY = "objectDefinitionSource";
    private static final String EXCEPTION_TRANSLATORS_PROPERTY = "exceptionTranslators";
    private static final String MESSAGE_INTERCEPTORS_PROPERTY = "messageInterceptors";
    private static final String CUSTOM_EDITORS_PROPERTY = "customEditors";
    private static final String MAPPING_PATTERN_ELEMENT = "mapping";
    private static final String CONFIG_PROCESSOR_ELEMENT = "config-processor";
    private static final String EXCEPTION_TRANSLATOR_ELEMENT = "exception-translator";
    private static final String MESSAGE_INTERCEPTOR_ELEMENT = "message-interceptor";
    private static final String SECURED_ELEMENT = "secured";
    private static final String SECURED_CHANNEL_ELEMENT = "secured-channel";
    private static final String SECURED_ENDPOINT_PATH_ELEMENT = "secured-endpoint-path";
    private static final String REMOTING_SERVICE_ELEMENT = "remoting-service";
    private static final String MESSAGE_SERVICE_ELEMENT = "message-service";
    private static final String DEFAULT_MAPPING_PATH = "/*";
    private final SpringSecurityConfigHelper securityHelper = SpringSecurityConfigResolver.resolve();

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        Object source = parserContext.extractSource((Object)element);
        ManagedSet configProcessors = new ManagedSet();
        configProcessors.setSource(source);
        ManagedList advisors = new ManagedList();
        advisors.setSource(source);
        ManagedSet translators = new ManagedSet();
        translators.setSource(source);
        TreeMap<Integer, RuntimeBeanReference> interceptors = new TreeMap<Integer, RuntimeBeanReference>();
        if (!StringUtils.hasText((String)element.getAttribute("id"))) {
            element.setAttribute("id", "_messageBroker");
        }
        this.validateMessageBroker(element, parserContext);
        ParsingUtils.mapOptionalAttributes(element, parserContext, builder, SERVICES_CONFIG_PATH_ATTR);
        ParsingUtils.mapOptionalBeanRefAttributes(element, builder, parserContext, CONFIGURATION_MANAGER_ATTR);
        this.registerHandlerAdapterIfNecessary(element, parserContext);
        if (!Boolean.parseBoolean(element.getAttribute(DISABLE_DEFAULT_MAPPING_ATTR))) {
            this.registerHandlerMappings(element, parserContext, DomUtils.getChildElementsByTagName((Element)element, (String)MAPPING_PATTERN_ELEMENT));
        }
        this.registerCustomConfigProcessors(parserContext, (Set<RuntimeBeanReference>)configProcessors, DomUtils.getChildElementsByTagName((Element)element, (String)CONFIG_PROCESSOR_ELEMENT));
        this.registerConfigMapEditorIfNecessary(element, parserContext);
        this.configureMessageService(element, parserContext, (ManagedSet<RuntimeBeanReference>)configProcessors, DomUtils.getChildElementByTagName((Element)element, (String)MESSAGE_SERVICE_ELEMENT));
        this.configureRemotingService(element, parserContext, (ManagedSet<RuntimeBeanReference>)configProcessors, DomUtils.getChildElementByTagName((Element)element, (String)REMOTING_SERVICE_ELEMENT));
        this.registerExceptionTranslation(element, parserContext, (ManagedList<RuntimeBeanReference>)advisors, (ManagedSet<RuntimeBeanReference>)translators, DomUtils.getChildElementsByTagName((Element)element, (String)EXCEPTION_TRANSLATOR_ELEMENT));
        this.configureCustomInterceptors(element, parserContext, (ManagedList<RuntimeBeanReference>)advisors, interceptors, DomUtils.getChildElementsByTagName((Element)element, (String)MESSAGE_INTERCEPTOR_ELEMENT));
        this.configureSecurity(element, parserContext, (ManagedSet<RuntimeBeanReference>)configProcessors, (ManagedList<RuntimeBeanReference>)advisors, (ManagedSet<RuntimeBeanReference>)translators, interceptors, DomUtils.getChildElementByTagName((Element)element, (String)SECURED_ELEMENT));
        this.registerDataServicesConfigProcessorIfRequired(parserContext, (ManagedSet<RuntimeBeanReference>)configProcessors, (ManagedSet<RuntimeBeanReference>)translators, interceptors, element, element.getAttribute("id"));
        ManagedSet managedInterceptors = new ManagedSet();
        managedInterceptors.setSource(source);
        managedInterceptors.addAll(interceptors.values());
        this.registerMessageInterceptionAdvice(element, parserContext, (ManagedList<RuntimeBeanReference>)advisors, (ManagedSet<RuntimeBeanReference>)managedInterceptors);
        this.registerEndpointProcessor(parserContext, (ManagedSet<RuntimeBeanReference>)configProcessors, (ManagedList<RuntimeBeanReference>)advisors, element, element.getAttribute("id"));
        if (!configProcessors.isEmpty()) {
            builder.addPropertyValue(CONFIG_PROCESSORS_PROPERTY, (Object)configProcessors);
        }
        parserContext.popAndRegisterContainingComponent();
    }

    protected String getBeanClassName(Element element) {
        return MESSAGE_BROKER_FACTORY_BEAN_CLASS_NAME;
    }

    private void configureMessageService(Element parent, ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, Element messageServiceElement) {
        Element source = messageServiceElement != null ? messageServiceElement : parent;
        BeanDefinitionBuilder messagingProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGING_PROCESSOR_CLASS_NAME);
        if (messageServiceElement != null) {
            ParsingUtils.mapAllAttributes(messageServiceElement, parserContext, messagingProcessorBuilder);
        }
        String brokerId = parent.getAttribute("id");
        ParsingUtils.registerInfrastructureComponent(source, parserContext, messagingProcessorBuilder, brokerId + "MessagingProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(brokerId + "MessagingProcessor"));
    }

    private void configureRemotingService(Element parent, ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, Element remotingServiceElement) {
        Element source = remotingServiceElement != null ? remotingServiceElement : parent;
        BeanDefinitionBuilder remotingProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)REMOTING_PROCESSOR_CLASS_NAME);
        if (remotingServiceElement != null) {
            ParsingUtils.mapAllAttributes(remotingServiceElement, parserContext, remotingProcessorBuilder);
        }
        String brokerId = parent.getAttribute("id");
        ParsingUtils.registerInfrastructureComponent(source, parserContext, remotingProcessorBuilder, brokerId + "RemotingProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(brokerId + "RemotingProcessor"));
        this.registerFlexRemotingAnnotationPostProcessorIfNecessary(source, parserContext);
        this.registerHibernateSerializationConfigPostProcessorIfNecessary(source, parserContext);
    }

    private void configureSecurity(Element parent, ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, ManagedList<RuntimeBeanReference> advisors, ManagedSet<RuntimeBeanReference> translators, Map<Integer, RuntimeBeanReference> interceptors, Element securedElement) {
        String accessManager;
        if (securedElement == null) {
            return;
        }
        boolean invalidateHttpSession = Boolean.parseBoolean(securedElement.getAttribute(INVALIDATE_HTTP_SESSION_ATTR));
        boolean perClientAuthentication = Boolean.parseBoolean(securedElement.getAttribute(PER_CLIENT_AUTHENTICATION_ATTR));
        String authManager = securedElement.getAttribute(AUTH_MANAGER_ATTR);
        if (!StringUtils.hasText((String)authManager)) {
            authManager = this.securityHelper.getAuthenticationManagerId();
        }
        if (!StringUtils.hasText((String)(accessManager = securedElement.getAttribute(ACCESS_MANAGER_ATTR)))) {
            accessManager = this.securityHelper.getAccessManagerId();
        }
        this.registerSecurityConfigPostProcessorIfNecessary(parserContext, securedElement);
        String brokerId = parent.getAttribute("id");
        this.registerLoginCommand(brokerId, parserContext, configProcessors, securedElement, authManager, invalidateHttpSession, perClientAuthentication);
        BeanDefinitionBuilder exceptionTranslatorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getSecurityExceptionTranslatorClassName());
        String exceptionTranslatorBeanId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, exceptionTranslatorBuilder);
        translators.add((Object)new RuntimeBeanReference(exceptionTranslatorBeanId));
        BeanDefinitionBuilder perClientInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getPerClientAuthenticationInterceptorClassName());
        String perClientInterceptorBeanId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, perClientInterceptorBuilder);
        if (perClientAuthentication && !interceptors.containsKey(MessageInterceptors.PER_CLIENT_AUTH_INTERCEPTOR.getOrder())) {
            interceptors.put(MessageInterceptors.PER_CLIENT_AUTH_INTERCEPTOR.getOrder(), new RuntimeBeanReference(perClientInterceptorBeanId));
        }
        if (!interceptors.containsKey(MessageInterceptors.LOGIN_MESSAGE_INTERCEPTOR.getOrder())) {
            BeanDefinitionBuilder loginInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getLoginMessageInterceptorClassName());
            String loginInterceptorBeanId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, loginInterceptorBuilder);
            interceptors.put(MessageInterceptors.LOGIN_MESSAGE_INTERCEPTOR.getOrder(), new RuntimeBeanReference(loginInterceptorBeanId));
        }
        this.registerEndpointInterceptorIfNecessary(securedElement, parserContext, interceptors, authManager, accessManager);
    }

    private void registerConfigMapEditorIfNecessary(Element source, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_jsonConfigMapEditorConfigurer")) {
            BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)CUSTOM_EDITOR_CONFIGURER_CLASS_NAME);
            ManagedMap editors = new ManagedMap();
            editors.put((Object)CONFIG_MAP_CLASS_NAME, (Object)JSON_CONFIG_MAP_EDITOR_CLASS_NAME);
            configurerBuilder.addPropertyValue(CUSTOM_EDITORS_PROPERTY, (Object)editors);
            ParsingUtils.registerInfrastructureComponent(source, parserContext, configurerBuilder, "_jsonConfigMapEditorConfigurer");
        }
    }

    private void registerCustomConfigProcessors(ParserContext parserContext, Set<RuntimeBeanReference> configProcessors, List<Element> configProcessorElements) {
        if (!CollectionUtils.isEmpty(configProcessorElements)) {
            for (Element configProcessorElement : configProcessorElements) {
                configProcessors.add(new RuntimeBeanReference(configProcessorElement.getAttribute(REF_ATTR)));
            }
        }
    }

    private void registerEndpointInterceptorIfNecessary(Element securedElement, ParserContext parserContext, Map<Integer, RuntimeBeanReference> interceptors, String authManager, String accessManager) {
        if (securedElement.hasChildNodes() && !interceptors.containsKey(MessageInterceptors.ENDPOINT_INTERCEPTOR.getOrder())) {
            BeanDefinitionBuilder interceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getEndpointInterceptorClassName());
            interceptorBuilder.addPropertyReference(AUTH_MANAGER_PROPERTY, authManager);
            if (StringUtils.hasText((String)accessManager)) {
                interceptorBuilder.addPropertyReference(ACCESS_MANAGER_PROPERTY, accessManager);
            }
            BeanDefinitionBuilder endpointDefSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getEndpointDefinitionSourceClassName());
            HashMap<String, Object> endpointMap = new HashMap<String, Object>();
            List securedChannelElements = DomUtils.getChildElementsByTagName((Element)securedElement, (String)SECURED_CHANNEL_ELEMENT);
            if (!CollectionUtils.isEmpty((Collection)securedChannelElements)) {
                for (Element securedChannel : securedChannelElements) {
                    String access = securedChannel.getAttribute(ACCESS_ATTR);
                    String channel = securedChannel.getAttribute(CHANNEL_ATTR);
                    Object attributeDefinition = this.securityHelper.parseConfigAttributes(access);
                    endpointMap.put(channel, attributeDefinition);
                }
            }
            LinkedHashMap<AntPathRequestMatcher, Object> requestMap = new LinkedHashMap<AntPathRequestMatcher, Object>();
            List securedEndpointPathElements = DomUtils.getChildElementsByTagName((Element)securedElement, (String)SECURED_ENDPOINT_PATH_ELEMENT);
            if (!CollectionUtils.isEmpty((Collection)securedEndpointPathElements)) {
                for (Element securedPath : securedEndpointPathElements) {
                    requestMap.put(new AntPathRequestMatcher(securedPath.getAttribute(PATTERN_ATTR)), this.securityHelper.parseConfigAttributes(securedPath.getAttribute(ACCESS_ATTR)));
                }
            }
            endpointDefSourceBuilder.addConstructorArgValue(requestMap);
            endpointDefSourceBuilder.addConstructorArgValue(endpointMap);
            String endpointDefSourceId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, endpointDefSourceBuilder);
            interceptorBuilder.addPropertyReference(OBJECT_DEF_SOURCE_PROPERTY, endpointDefSourceId);
            String interceptorId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, interceptorBuilder);
            interceptors.put(MessageInterceptors.ENDPOINT_INTERCEPTOR.getOrder(), new RuntimeBeanReference(interceptorId));
        }
    }

    private void registerDataServicesConfigProcessorIfRequired(ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, ManagedSet<RuntimeBeanReference> translators, Map<Integer, RuntimeBeanReference> interceptors, Element securedElement, String brokerId) {
        if (!(!RuntimeEnvironment.isLCDS() || interceptors.isEmpty() && translators.isEmpty())) {
            Map<Integer, RuntimeBeanReference> nioInterceptors;
            BeanDefinitionBuilder lcdsConfigProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DATASERVICES_PROCESSOR_CLASS_NAME);
            lcdsConfigProcessorBuilder.addPropertyValue(EXCEPTION_TRANSLATORS_PROPERTY, translators);
            if (!interceptors.containsKey(MessageInterceptors.PER_CLIENT_AUTH_INTERCEPTOR.getOrder())) {
                BeanDefinitionBuilder perClientInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getPerClientAuthenticationInterceptorClassName());
                String perClientInterceptorBeanId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, perClientInterceptorBuilder);
                nioInterceptors = new TreeMap<Integer, RuntimeBeanReference>(interceptors);
                nioInterceptors.put(MessageInterceptors.PER_CLIENT_AUTH_INTERCEPTOR.getOrder(), new RuntimeBeanReference(perClientInterceptorBeanId));
            } else {
                nioInterceptors = interceptors;
            }
            ManagedSet managedInterceptors = new ManagedSet();
            managedInterceptors.addAll(nioInterceptors.values());
            managedInterceptors.setSource(parserContext.extractSource((Object)securedElement));
            lcdsConfigProcessorBuilder.addPropertyValue(MESSAGE_INTERCEPTORS_PROPERTY, (Object)managedInterceptors);
            ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, lcdsConfigProcessorBuilder, brokerId + "DataServicesConfigProcessor");
            configProcessors.add((Object)new RuntimeBeanReference(brokerId + "DataServicesConfigProcessor"));
        }
    }

    private void registerEndpointProcessor(ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, ManagedList<RuntimeBeanReference> advisors, Element securedElement, String brokerId) {
        BeanDefinitionBuilder endpointProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)ENDPOINT_PROCESSOR_CLASS_NAME);
        endpointProcessorBuilder.addConstructorArgValue(advisors);
        ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, endpointProcessorBuilder, brokerId + "EndpointProcessor");
        configProcessors.add((Object)new RuntimeBeanReference(brokerId + "EndpointProcessor"));
    }

    private void registerExceptionTranslation(Element element, ParserContext parserContext, ManagedList<RuntimeBeanReference> advisors, ManagedSet<RuntimeBeanReference> translators, List<Element> exceptionTranslatorElements) {
        if (!CollectionUtils.isEmpty(exceptionTranslatorElements)) {
            for (Element exceptionTranslatorElement : exceptionTranslatorElements) {
                translators.add((Object)new RuntimeBeanReference(exceptionTranslatorElement.getAttribute(REF_ATTR)));
            }
        }
        BeanDefinitionBuilder advisorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SERVICE_MESSAGE_ADVISOR_CLASS_NAME);
        BeanDefinitionBuilder exceptionTranslationBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)EXCEPTION_TRANSLATION_CLASS_NAME);
        exceptionTranslationBuilder.addPropertyValue(EXCEPTION_TRANSLATORS_PROPERTY, translators);
        ParsingUtils.mapOptionalBeanRefAttributes(element, exceptionTranslationBuilder, parserContext, EXCEPTION_LOGGER_ATTR);
        String exceptionTranslationId = ParsingUtils.registerInfrastructureComponent(element, parserContext, exceptionTranslationBuilder);
        advisorBuilder.addConstructorArgReference(exceptionTranslationId);
        String advisorId = ParsingUtils.registerInfrastructureComponent(element, parserContext, advisorBuilder);
        advisors.add((Object)new RuntimeBeanReference(advisorId));
    }

    private void registerFlexRemotingAnnotationPostProcessorIfNecessary(Element source, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_flexRemotingAnnotationPostProcessor")) {
            BeanDefinitionBuilder processorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)REMOTING_ANNOTATION_PROCESSOR_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(source, parserContext, processorBuilder, "_flexRemotingAnnotationPostProcessor");
        }
    }

    private void registerHibernateSerializationConfigPostProcessorIfNecessary(Element source, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_hibernateSerializationConfigPostProcessor")) {
            BeanDefinitionBuilder processorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)HIBERNATE_CONFIG_PROCESSOR_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(source, parserContext, processorBuilder, "_hibernateSerializationConfigPostProcessor");
        }
    }

    private void registerHandlerAdapterIfNecessary(Element element, ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition("_messageBrokerHandlerAdapter")) {
            BeanDefinitionBuilder handlerAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGE_BROKER_HANDLER_ADAPTER_CLASS_NAME);
            ParsingUtils.registerInfrastructureComponent(element, parserContext, handlerAdapterBuilder, "_messageBrokerHandlerAdapter");
        }
    }

    private void registerHandlerMappings(Element parent, ParserContext parserContext, List<Element> mappingPatternElements) {
        BeanDefinitionBuilder handlerMappingBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_HANDLER_MAPPING_CLASS_NAME);
        if (StringUtils.hasText((String)parent.getAttribute(MAPPING_ORDER_ATTR))) {
            handlerMappingBuilder.addPropertyValue(ORDER_PROPERTY, (Object)Integer.parseInt(parent.getAttribute(MAPPING_ORDER_ATTR)));
        }
        HashMap<String, String> mappings = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(mappingPatternElements)) {
            mappings.put(DEFAULT_MAPPING_PATH, parent.getAttribute("id"));
        } else {
            for (Element mappingElement : mappingPatternElements) {
                mappings.put(mappingElement.getAttribute(PATTERN_ATTR), parent.getAttribute("id"));
            }
        }
        handlerMappingBuilder.addPropertyValue(URL_MAP_PROPERTY, mappings);
        ParsingUtils.registerInfrastructureComponent(parent, parserContext, handlerMappingBuilder, parent.getAttribute("id") + "DefaultHandlerMapping");
    }

    private void registerLoginCommand(String brokerId, ParserContext parserContext, ManagedSet<RuntimeBeanReference> configProcessors, Element securedElement, String authManager, boolean invalidateHttpSession, boolean perClientAuthentication) {
        String loginCommandId = securedElement.getAttribute(LOGIN_COMMAND_ATTR);
        if (!StringUtils.hasText((String)loginCommandId)) {
            loginCommandId = brokerId + "LoginCommand";
            BeanDefinitionBuilder loginCommandBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getLoginCommandClassName());
            loginCommandBuilder.addConstructorArgReference(authManager);
            loginCommandBuilder.addPropertyValue(PER_CLIENT_AUTHENTICATION_PROPERTY, (Object)perClientAuthentication);
            loginCommandBuilder.getRawBeanDefinition().setAttribute(INVALIDATE_HTTP_SESSION_PROPERTY, (Object)invalidateHttpSession);
            ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, loginCommandBuilder, loginCommandId);
        }
        BeanDefinitionBuilder loginCommandProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)LOGIN_COMMAND_PROCESSOR_CLASS_NAME);
        loginCommandProcessorBuilder.addConstructorArgReference(loginCommandId);
        loginCommandProcessorBuilder.addPropertyValue(PER_CLIENT_AUTHENTICATION_PROPERTY, (Object)perClientAuthentication);
        String loginCommandProcessorId = ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, loginCommandProcessorBuilder);
        configProcessors.add((Object)new RuntimeBeanReference(loginCommandProcessorId));
    }

    private void registerSecurityConfigPostProcessorIfNecessary(ParserContext parserContext, Element securedElement) {
        if (!parserContext.getRegistry().containsBeanDefinition("_loginCommandPostProcessor")) {
            BeanDefinitionBuilder securityConfigPostProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.securityHelper.getSecurityConfigPostProcessorClassName());
            securityConfigPostProcessorBuilder.setAutowireMode(2);
            securityConfigPostProcessorBuilder.setDependencyCheck(0);
            ParsingUtils.registerInfrastructureComponent(securedElement, parserContext, securityConfigPostProcessorBuilder, "_loginCommandPostProcessor");
        }
    }

    private void configureCustomInterceptors(Element element, ParserContext parserContext, ManagedList<RuntimeBeanReference> advisors, Map<Integer, RuntimeBeanReference> interceptors, List<Element> messageInterceptorElements) {
        if (!CollectionUtils.isEmpty(messageInterceptorElements)) {
            for (Element messageInterceptorElement : messageInterceptorElements) {
                int key = MessageInterceptors.FIRST.getOrder();
                if (messageInterceptorElement.hasAttribute(POSITION_ATTR)) {
                    key = MessageInterceptors.valueOf(messageInterceptorElement.getAttribute(POSITION_ATTR)).getOrder();
                } else if (messageInterceptorElement.hasAttribute(AFTER_ATTR)) {
                    key = MessageInterceptors.valueOf(messageInterceptorElement.getAttribute(AFTER_ATTR)).getOrder() + 1;
                } else if (messageInterceptorElement.hasAttribute(BEFORE_ATTR)) {
                    key = MessageInterceptors.valueOf(messageInterceptorElement.getAttribute(BEFORE_ATTR)).getOrder() - 50;
                }
                while (interceptors.get(key) != null) {
                    ++key;
                }
                interceptors.put(key, new RuntimeBeanReference(messageInterceptorElement.getAttribute(REF_ATTR)));
            }
        }
    }

    private void registerMessageInterceptionAdvice(Element element, ParserContext parserContext, ManagedList<RuntimeBeanReference> advisors, ManagedSet<RuntimeBeanReference> interceptors) {
        BeanDefinitionBuilder advisorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SERVICE_MESSAGE_ADVISOR_CLASS_NAME);
        BeanDefinitionBuilder messageInterceptionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MESSAGE_INTERCEPTION_CLASS_NAME);
        messageInterceptionBuilder.addPropertyValue(MESSAGE_INTERCEPTORS_PROPERTY, interceptors);
        String messageInterceptionId = ParsingUtils.registerInfrastructureComponent(element, parserContext, messageInterceptionBuilder);
        advisorBuilder.addConstructorArgReference(messageInterceptionId);
        String advisorId = ParsingUtils.registerInfrastructureComponent(element, parserContext, advisorBuilder);
        advisors.add((Object)new RuntimeBeanReference(advisorId));
    }

    private void validateMessageBroker(Element element, ParserContext parserContext) {
        if (!"/WEB-INF/flex/services-config.xml".equals(element.getAttribute(SERVICES_CONFIG_PATH_ATTR)) && StringUtils.hasText((String)element.getAttribute(CONFIGURATION_MANAGER_ATTR))) {
            parserContext.getReaderContext().error("The services-config-path cannot be set when using a custom configuration-manager reference.  Set the configurationPath on the custom ConfigurationManager instead.", (Object)element);
        }
    }
}

