/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.License;
import com.supermap.data.LicenseFeatureInfo;
import com.supermap.data.Point2D;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.layout.InternalEnum;
import com.supermap.layout.InternalGeoStyle;
import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalImageType;
import com.supermap.layout.InternalResource;
import com.supermap.layout.InternalToolkitLayout;
import com.supermap.layout.LayoutElements;
import com.supermap.layout.LayoutSelection;
import com.supermap.layout.MapLayoutDrawingEvent;
import com.supermap.layout.MapLayoutDrawingListener;
import com.supermap.layout.MapLayoutDrawnEvent;
import com.supermap.layout.MapLayoutDrawnListener;
import com.supermap.layout.MapLayoutNative;
import com.supermap.layout.Paper;
import com.supermap.layout.PrintFileType;
import com.supermap.layout.Printer;
import com.supermap.layout.Ruler;
import com.supermap.layout.RulerLines;
import com.supermap.layout.RulerSetting;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.MapLayoutControl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class MapLayout
extends InternalHandleDisposable {
    private Dimension _$15 = new Dimension(256, 256);
    private RulerSetting _$14;
    private Paper _$13;
    private Printer _$12;
    private RulerLines _$11;
    private MapLayoutControl _$10;
    private static final int _$9 = 5;
    private Workspace _$8;
    transient Vector m_mapDrawingListeners;
    transient Vector m_mapDrawnListeners;
    private LayoutSelection _$7;
    private LayoutElements _$6;
    private long _$5 = 0L;
    private License _$4;
    private GeoStyle _$3;
    private static final double _$2 = 10000.0;
    private Ruler _$1;

    public MapLayout() {
        this.checkLicense();
        long l = MapLayoutNative.jni_New();
        this.setHandle(l, true);
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
        MapLayoutNative.jni_RegisteAllEvents(l, this);
    }

    public MapLayout(Workspace workspace) {
        this.checkLicense();
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = MapLayoutNative.jni_New();
        this.setHandle(l2, true);
        MapLayoutNative.jni_RegisteAllEvents(l2, this);
        this.setWorkspace(workspace);
        this._$8 = workspace;
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    MapLayout(long l) {
        this.checkLicense();
        this.setHandle(l, false);
        MapLayoutNative.jni_RegisteAllEvents(l, this);
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    MapLayout(long l, MapLayoutControl mapLayoutControl) {
        this.checkLicense();
        this.setHandle(l, false);
        MapLayoutNative.jni_RegisteAllEvents(l, this);
        this._$10 = mapLayoutControl;
        this.getPaper();
        this.getPrinter();
        MapLayoutNative.jni_setName(this.getHandle(), "UntitledMapLayout");
        MapLayoutNative.jni_SetModified(this.getHandle(), false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String name)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        MapLayoutNative.jni_setName(this.getHandle(), string);
    }

    public Paper getPaper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13 == null) {
            this._$13 = new Paper(this);
        }
        return this._$13;
    }

    public Printer getPrinter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrinter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 == null) {
            this._$12 = new Printer(this);
        }
        return this._$12;
    }

    public Ruler getRuler() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRuler()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 == null) {
            this._$1 = new Ruler(this);
        }
        return this._$1;
    }

    public RulerLines getRulerLines() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRulerLines()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 == null) {
            this._$11 = new RulerLines(this);
        }
        return this._$11;
    }

    public RulerSetting getRulerSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRulerSetting()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$14 == null) {
            this._$14 = new RulerSetting(this);
        }
        return this._$14;
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapLayoutNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapLayoutNative.jni_getViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rectangle2D", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getZoomRatio(this.getHandle(), 10000.0);
    }

    public void setZoomRatio(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setZoomRatio(this.getHandle(), d / 10000.0);
    }

    public double getMaxZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getMaxZoomRatio(this.getHandle(), 10000.0);
    }

    public void setMaxZoomRatio(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setMaxZoomRatio(this.getHandle(), d / 10000.0);
    }

    public double getMinZoomRatio() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinZoomRatio()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getMinZoomRatio(this.getHandle(), 10000.0);
    }

    public void setMinZoomRatio(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinZoomRatio(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setMinZoomRatio(this.getHandle(), d / 10000.0);
    }

    public int getHorizontalPaperCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHorizontalPaperCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getHorizontalPaperCount(this.getHandle());
    }

    public void setHorizontalPaperCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHorizontalPaperCount(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setHorizontalPaperCount(this.getHandle(), n);
    }

    public int getVerticalPaperCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVerticalPaperCount()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getVerticalPaperCount(this.getHandle());
    }

    public void setVerticalPaperCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVerticalPaperCount(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setVerticalPaperCount(this.getHandle(), n);
    }

    public boolean getPrintPreview() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrintPreview()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getPaperPreview(this.getHandle());
    }

    public void setPrintPreview(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrintPreview()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setPaperPreview(this.getHandle(), bl);
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$8;
    }

    public void setWorkspace(Workspace workspace) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        if (this._$8 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$8)) == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "MapLayout_DontDisposeOldWorkspace", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 != null && !this._$8.getConnectionInfo().getServer().equals("")) {
            this.close();
        }
        if (workspace == null) {
            this._$8 = null;
        } else {
            l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
            if (l == 0L) {
                String string = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            MapLayoutNative.jni_SetWorkspace(this.getHandle(), l);
            this._$8 = workspace;
        }
    }

    public LayoutElements getElements() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getElements()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$6 == null) {
            this._$6 = new LayoutElements(this);
        }
        return this._$6;
    }

    public Dimension getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = null;
        dimension = this._$10 == null ? new Dimension(this._$15) : new Dimension(this._$10.getWidth(), this._$10.getHeight());
        return dimension;
    }

    public void setImageSize(Dimension dimension) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize(Dimension size)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (dimension.getWidth() > 0.0 && dimension.getHeight() > 0.0) {
            MapLayoutNative.jni_setImageSize(this.getHandle(), dimension.getWidth(), dimension.getHeight());
        }
        this._$15 = dimension;
    }

    public LayoutSelection getSelection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null) {
            long l = MapLayoutNative.jni_getSelection(this.getHandle());
            this._$7 = new LayoutSelection(l);
        }
        return this._$7;
    }

    public void setSelection(LayoutSelection layoutSelection) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSelection(LayoutSelection layoutSelection)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (layoutSelection == null) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)layoutSelection);
        if (l == 0L) {
            String string = InternalResource.loadString("layoutSelection", "Global_ArgumentObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setSelection(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)layoutSelection));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)layoutSelection));
    }

    public boolean open(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("open(String name)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = MapLayoutNative.jni_open(this.getHandle(), string);
        this._$3();
        return bl;
    }

    public boolean loadTemplate(String string) {
        boolean bl;
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("loadTemplate(String templateName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$5()) {
            String string4 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string4);
        }
        if (this._$6 != null) {
            this._$6.clearHandle();
        }
        if (bl = MapLayoutNative.jni_loadTemplate(this.getHandle(), string)) {
            this._$6 = new LayoutElements(this);
        }
        return bl;
    }

    public boolean saveAsTemplate(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("saveAsTemplate(String templateName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        return MapLayoutNative.jni_saveAsTemplate(this.getHandle(), string);
    }

    public void zoomToPaper() {
        double d;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaper()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double d2 = this.getPaper().getWidth();
        if (d2 > (d = this.getPaper().getHeight())) {
            this.zoomToPaperWidth();
        } else {
            this.zoomToPaperHeight();
        }
    }

    public void zoomToPaperWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaperWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_zoomToPaperWidth(this.getHandle());
    }

    public void zoomToPaperHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoomToPaperHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_zoomToPaperHeight(this.getHandle());
    }

    public void zoom(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("ratio", "MapLayout_ZoomRatioShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_Zoom(this.getHandle(), d);
    }

    public void pan(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pan(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_Pan(this.getHandle(), d, d2);
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_Refresh(this.getHandle());
    }

    public Point2D pixelToLayout(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_pixelToLayout(this.getHandle(), point.x, point.y, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public Point layoutToPixel(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutToPixel(Point point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapLayoutNative.jni_layoutToPixel(this.getHandle(), point2D.getX(), point2D.getY(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public boolean outputLayoutToBMP(String string, int n) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputLayoutToBMP(String fileName, int dpi)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$5()) {
            String string5 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string5);
        }
        if (string == null || string.trim().equals("")) {
            String string6 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = this._$1(string, ".bmp");
        if (this._$8.getDatasources() == null || this._$8.getDatasources().getCount() == 0) {
            String string8 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string8);
        }
        int n2 = InternalEnum.getUGCValue(InternalImageType.BMP);
        return MapLayoutNative.jni_OutputMapToBMP(this.getHandle(), string7, n);
    }

    public boolean outputLayoutToJPG(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".jpg");
        return this._$1(string5, InternalImageType.JPG, this._$15.width, this._$15.height);
    }

    public boolean outputLayoutToJPG(String string, int n, int n2) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".jpg");
        int n3 = InternalEnum.getUGCValue(InternalImageType.JPG);
        return MapLayoutNative.jni_PrintToFile(this.getHandle(), string5, n3, n, n2, false);
    }

    public boolean outputLayoutToPNG(String string, boolean bl) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = this._$1(string, ".png");
        if (this._$15.width <= 0) {
            String string7 = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this._$15.height <= 0) {
            String string8 = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string8);
        }
        if (this._$8.getDatasources() == null || this._$8.getDatasources().getCount() == 0) {
            String string9 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string9);
        }
        boolean bl2 = false;
        bl2 = MapLayoutNative.jni_OutputMapToPNG(this.getHandle(), string6, InternalImageType.PNG.value(), this._$15.width, this._$15.height, bl);
        return bl2;
    }

    public boolean outputLayoutToEPS(String string) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputLayoutToEPS(String fileName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".eps");
        return this._$1(string5, InternalImageType.EPS, this._$15.width, this._$15.height);
    }

    public boolean outputLayoutToEMF(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputLayoutToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".emf");
        return this._$1(string5, InternalImageType.EMF, this._$15.width, this._$15.height);
    }

    public BufferedImage outputLayoutToBitmap() {
        this._$2();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputLayoutToBitmap", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this._$15.width, this._$15.height);
        MapLayoutNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage));
        BufferedImage bufferedImage = new BufferedImage(this._$15.width, this._$15.height, 5);
        bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
        return bufferedImage;
    }

    public boolean outputLayoutToGIF(String string, boolean bl) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputLayoutToGIF(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".gif");
        if (!this._$5()) {
            String string6 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string6);
        }
        if (string == null || string.trim().equals("")) {
            String string7 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this._$15.width < 0) {
            String string8 = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string8);
        }
        if (this._$15.height < 0) {
            String string9 = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string9);
        }
        if (this._$8.getDatasources() == null || this._$8.getDatasources().getCount() == 0) {
            String string10 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string10);
        }
        int n = InternalEnum.getUGCValue(InternalImageType.GIF);
        return MapLayoutNative.jni_OutputLayoutToGIF(this.getHandle(), string5, n, this._$15.width, this._$15.height, bl);
    }

    public boolean printToFile(String string, PrintFileType printFileType, int n) {
        return this.printToFile(string, printFileType, n, false);
    }

    public boolean printToFile(String string, PrintFileType printFileType, int n, boolean bl) {
        this._$2();
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("printToFile(String fileName, int dpi)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$5()) {
            String string5 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string5);
        }
        if (string == null || string.trim().equals("")) {
            String string6 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string6);
        }
        String string7 = this._$1(string, printFileType);
        int n2 = InternalEnum.getUGCValue(printFileType);
        boolean bl2 = false;
        bl2 = MapLayoutNative.jni_PrintToFile(this.getHandle(), string7, n2, n, 100, bl);
        return bl2;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 != null) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$8);
            if (l == 0L) {
                String string = InternalResource.loadString("close()", "MapLayout_CloseMapBeforeDisposeWksp", "layout_resources");
                throw new IllegalStateException(string);
            }
            this._$3();
            MapLayoutNative.jni_close(this.getHandle());
        }
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$8 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$8) == 0L) {
            String string3 = InternalResource.loadString("fromXML(String xml)", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = MapLayoutNative.jni_FromXML(this.getHandle(), string);
            this._$3();
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5()) {
            String string = InternalResource.loadString("toXML()", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_ToXML(this.getHandle());
    }

    public GeoStyle getBackgroundStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackgroundStyle()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null && (l = MapLayoutNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this._$3 = InternalGeoStyle.createInstance(l);
        }
        return this._$3;
    }

    public void setBackgroundStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackgroundStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle.clone());
        MapLayoutNative.jni_SetBackgroundStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isModified()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsModified(this.getHandle());
    }

    public void setModified(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetModified(this.getHandle(), bl);
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetOverlapDisplayed(this.getHandle(), bl);
    }

    public boolean isTextAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextAntialias()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsTextAntialias(this.getHandle());
    }

    public void setTextAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetTextAntialias(this.getHandle(), bl);
    }

    public boolean isLineAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLineAntialias()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_IsLineAntialias(this.getHandle());
    }

    public void setLineAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_SetLineAntialias(this.getHandle(), bl);
    }

    public int getOverlapLengthOfPrinterPaper() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapLengthOfPrinterPaper()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getOverlapLengthOfPrinterPaper(this.getHandle());
    }

    public void setOverlapLengthOfPrinterPaper(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapLengthOfPrinterPaper(int value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n > 100) {
            String string = InternalResource.loadString("value", "MapLayout_OverlapLengthOfPrinterPaperShouldBetween0And100", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        MapLayoutNative.jni_setOverlapLengthOfPrinterPaper(this.getHandle(), n);
    }

    public boolean ensureVisible(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double d = rectangle2D.getLeft();
        double d2 = rectangle2D.getRight();
        double d3 = rectangle2D.getTop();
        double d4 = rectangle2D.getBottom();
        return MapLayoutNative.jni_EnsureVisible(this.getHandle(), d, d3, d2, d4);
    }

    public Point2D layoutToLogical(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("layoutToLogical(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_LayoutToLogical(this.getHandle(), dArray, point2D.getX(), point2D.getY());
        Point2D point2D2 = new Point2D(dArray[0], dArray[1]);
        return point2D2;
    }

    public Point2D logicalToLayout(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("logicalToLayout(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double d = Math.round(point2D.getX() * 10.0);
        double d2 = Math.round(point2D.getY() * 10.0);
        double[] dArray = new double[2];
        MapLayoutNative.jni_LogicalToLayout(this.getHandle(), dArray, d, d2);
        Point2D point2D2 = new Point2D(dArray[0], dArray[1]);
        return point2D2;
    }

    public Point logicalToPixel(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("logicalToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double d = Math.round(point2D.getX() * 10.0);
        double d2 = Math.round(point2D.getY() * 10.0);
        int[] nArray = new int[2];
        MapLayoutNative.jni_LogicalToPixel(this.getHandle(), nArray, d, d2);
        Point point = new Point(nArray[0], nArray[1]);
        return point;
    }

    public Point2D pixelToLogical(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToLogical(Point point)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[2];
        MapLayoutNative.jni_PixelToLogical(this.getHandle(), dArray, point.getX(), point.getY());
        Point2D point2D = new Point2D(dArray[0] / 10.0, dArray[1] / 10.0);
        return point2D;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$8) == 0L) {
            String string = InternalResource.loadString("dispose()", "MapLayout_DontDisposeOldWorkspace", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.clearHandle();
        MapLayoutNative.jni_Delete(this.getHandle());
        this.setHandle(0L);
        this._$1();
    }

    public boolean adjustLayoutPaperSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("adjustLayoutPaperSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_AdjustLayoutPaperSize(this.getHandle(), true, true);
    }

    public LayoutSelection hitTest(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D pt, double tolerance)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "ArgumentShouldNotBeNegative", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        LayoutSelection layoutSelection = null;
        long l = MapLayoutNative.jni_HitTest(this.getHandle(), d2, d3, d);
        if (l != 0L) {
            layoutSelection = new LayoutSelection(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)layoutSelection, (boolean)true);
        }
        return layoutSelection;
    }

    public synchronized void addDrawingListener(MapLayoutDrawingListener mapLayoutDrawingListener) {
        if (this.m_mapDrawingListeners == null) {
            this.m_mapDrawingListeners = new Vector();
        }
        if (!this.m_mapDrawingListeners.contains(mapLayoutDrawingListener)) {
            this.m_mapDrawingListeners.add(mapLayoutDrawingListener);
        }
    }

    public synchronized void removeDrawingListener(MapLayoutDrawingListener mapLayoutDrawingListener) {
        if (this.m_mapDrawingListeners != null && this.m_mapDrawingListeners.contains(mapLayoutDrawingListener)) {
            this.m_mapDrawingListeners.remove(mapLayoutDrawingListener);
        }
    }

    protected void fireDrawing(MapLayoutDrawingEvent mapLayoutDrawingEvent) {
        if (this.m_mapDrawingListeners != null) {
            Vector vector = this.m_mapDrawingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapLayoutDrawingListener)vector.elementAt(i)).mapLayoutDrawing(mapLayoutDrawingEvent);
            }
        }
    }

    static void drawingCallBack(MapLayout mapLayout, long l) {
        if (mapLayout != null) {
            Boolean bl = InternalToolkitLayout.getHandleBooleanValue(l);
            MapLayoutDrawingEvent mapLayoutDrawingEvent = new MapLayoutDrawingEvent((Object)mapLayout, mapLayout, bl);
            mapLayout.fireDrawing(mapLayoutDrawingEvent);
            InternalToolkitLayout.setHandleBooleanValue(l, mapLayoutDrawingEvent.getCancel());
        }
    }

    public synchronized void addDrawnListener(MapLayoutDrawnListener mapLayoutDrawnListener) {
        if (this.m_mapDrawnListeners == null) {
            this.m_mapDrawnListeners = new Vector();
        }
        if (!this.m_mapDrawnListeners.contains(mapLayoutDrawnListener)) {
            this.m_mapDrawnListeners.add(mapLayoutDrawnListener);
        }
    }

    public synchronized void removeDrawnListener(MapLayoutDrawnListener mapLayoutDrawnListener) {
        if (this.m_mapDrawnListeners != null && this.m_mapDrawnListeners.contains(mapLayoutDrawnListener)) {
            this.m_mapDrawnListeners.remove(mapLayoutDrawnListener);
        }
    }

    protected void fireDrawn(MapLayoutDrawnEvent mapLayoutDrawnEvent) {
        if (this.m_mapDrawnListeners != null) {
            Vector vector = this.m_mapDrawnListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapLayoutDrawnListener)vector.elementAt(i)).mapLayoutDrawn(mapLayoutDrawnEvent);
            }
        }
    }

    static void drawnCallBack(MapLayout mapLayout) {
        if (mapLayout != null) {
            MapLayoutDrawnEvent mapLayoutDrawnEvent = new MapLayoutDrawnEvent((Object)mapLayout, mapLayout);
            mapLayout.fireDrawn(mapLayoutDrawnEvent);
        }
    }

    private boolean _$1(String string, InternalImageType internalImageType, int n, int n2) {
        if (!this._$5()) {
            String string2 = InternalResource.loadString("", "MapLayout_WorkspaceIsEmpty", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().equals("")) {
            String string3 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        if (n < 0) {
            String string4 = InternalResource.loadString("imageWidth", "MapLayout_ImageWidthShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 < 0) {
            String string5 = InternalResource.loadString("imageHeight", "MapLayout_ImageHeightShouldBePositive", "layout_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$8.getDatasources() == null || this._$8.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "MapLayout_WorkspaceHasNoDatasource", "layout_resources");
            throw new IllegalStateException(string6);
        }
        int n3 = InternalEnum.getUGCValue(internalImageType);
        return MapLayoutNative.jni_OutputMapToFile(this.getHandle(), string, n3, n, n2);
    }

    private boolean _$5() {
        if (this._$8 == null) {
            return false;
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$8);
        return l != 0L;
    }

    private boolean _$1(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    private String _$1(String string, String string2) {
        String string3 = null;
        if (string.toLowerCase().endsWith(string2)) {
            int n = string.toLowerCase().lastIndexOf(string2);
            string3 = string.substring(0, n) + string2;
        } else {
            string3 = string + string2;
        }
        return string3;
    }

    private String _$1(String string, PrintFileType printFileType) {
        int n = printFileType.value();
        String string2 = "";
        switch (n) {
            case 123: {
                string2 = ".png";
                break;
            }
            case 122: {
                string2 = ".jpg";
                break;
            }
            case 121: {
                string2 = ".bmp";
                break;
            }
            case 103: {
                string2 = ".tif";
            }
        }
        return this._$1(string, string2);
    }

    protected static void clearHandle(MapLayout mapLayout) {
        mapLayout.clearHandle();
    }

    protected static MapLayout createInstance(long l, MapLayoutControl mapLayoutControl) {
        return new MapLayout(l, mapLayoutControl);
    }

    protected void clearHandle() {
        this._$3();
        this._$4();
        this._$8 = null;
    }

    private void _$4() {
        if (this._$5 != 0L) {
            MapLayoutNative.jni_DeleteSelfEventHandle(this._$5);
            this._$5 = 0L;
        }
    }

    private void _$3() {
        if (this._$7 != null) {
            this._$7.clearHandle();
            this._$7 = null;
        }
        if (this._$6 != null) {
            this._$6.clearHandle();
            this._$6 = null;
        }
        if (this._$11 != null) {
            this._$11.clearHandle();
            this._$11 = null;
        }
        this._$10 = null;
        if (this._$12 != null) {
            this._$12.internalDispose();
            this._$12 = null;
        }
    }

    private void _$2() {
        int n = this._$4.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }

    protected void checkLicense() {
        ArrayList<ProductType> arrayList = InternalToolkitLayout.managerProducts(InternalToolkitLayout.getLayoutProducts());
        this._$4 = InternalToolkitLayout.verifyLicense(arrayList);
        LicenseFeatureInfo licenseFeatureInfo = this._$4.getFeatureInfo();
        InternalToolkitLayout.setLayoutRuntimeLicenseMode(licenseFeatureInfo.isTrial());
        InternalToolkitLayout.updateStatus();
    }

    private void _$1() {
        if (this._$4 != null) {
            this._$4.disconnect();
            this._$4.dispose();
            this._$4 = null;
        }
    }

    public void setSymbolScalable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutNative.jni_setSymbolScalable(this.getHandle(), bl);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutNative.jni_getSymbolScalable(this.getHandle());
    }
}

