/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.error;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.json.JsonViewCallback;

public class StandartErrorConverter
implements JsonViewCallback {
    private String modelCleanUpMode = "KEEP_ALL";
    private String hasGlobalErrorsKey = "hasGlobalErrors";
    private String globalErrorsKey = "globalerrors";
    private String hasFieldErrorsKey = "hasFieldErrors";
    private String fieldErrorsKey = "fielderrors";

    public void onPopulateErrors(Map model, RequestContext rc, BindingResult br) throws Exception {
        if ("KEEP_ERRORS_ONLY".equals(this.modelCleanUpMode)) {
            model.clear();
        } else if ("REMOVE_COMMAND_BEAN".equals(this.modelCleanUpMode)) {
            model.remove(br.getObjectName());
        }
        ArrayList<String> globalErrors = new ArrayList<String>();
        for (Object er : br.getGlobalErrors()) {
            ObjectError error = (ObjectError)er;
            String message = rc.getMessage((MessageSourceResolvable)error);
            globalErrors.add(message);
        }
        model.put(this.hasGlobalErrorsKey, br.hasGlobalErrors());
        if (!globalErrors.isEmpty()) {
            model.put(this.globalErrorsKey, globalErrors);
        }
        HashMap<String, String> feldErrors = new HashMap<String, String>();
        for (Object er : br.getFieldErrors()) {
            FieldError error = (FieldError)er;
            String objName = error.getField();
            String message = rc.getMessage((MessageSourceResolvable)error);
            feldErrors.put(objName, message);
        }
        model.put(this.hasFieldErrorsKey, br.hasFieldErrors());
        if (!feldErrors.isEmpty()) {
            model.put(this.fieldErrorsKey, feldErrors);
        }
    }

    public void onPopulateSuccess(Map model, RequestContext rc, BindingResult br) {
    }

    public String getModelCleanUpMode() {
        return this.modelCleanUpMode;
    }

    public void setModelCleanUpMode(String modelCleanUpMode) {
        this.modelCleanUpMode = modelCleanUpMode;
    }

    public String getHasGlobalErrorsKey() {
        return this.hasGlobalErrorsKey;
    }

    public void setHasGlobalErrorsKey(String hasGlobalErrorsKey) {
        this.hasGlobalErrorsKey = hasGlobalErrorsKey;
    }

    public String getGlobalErrorsKey() {
        return this.globalErrorsKey;
    }

    public void setGlobalErrorsKey(String globalErrorsKey) {
        this.globalErrorsKey = globalErrorsKey;
    }

    public String getHasFieldErrorsKey() {
        return this.hasFieldErrorsKey;
    }

    public void setHasFieldErrorsKey(String hasFieldErrorsKey) {
        this.hasFieldErrorsKey = hasFieldErrorsKey;
    }

    public String getFieldErrorsKey() {
        return this.fieldErrorsKey;
    }

    public void setFieldErrorsKey(String fieldErrorsKey) {
        this.fieldErrorsKey = fieldErrorsKey;
    }
}

