/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.util;

import java.io.InputStream;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.core.reflect.ReflectionMethodHelper;

public final class Util {
    public static final String DEFAULT_KEY_WORD_CLASS = "class";
    private static String keyWordClass = "class";
    private static final Map<String, DateFormat> dateFormats = new HashMap<String, DateFormat>();

    public static DateFormat registerDateFormat(String key, DateFormat pvDateFormat) {
        return dateFormats.put(key, pvDateFormat);
    }

    public static DateFormat registerDateFormat(String format) {
        return Util.registerDateFormat(format, new SimpleDateFormat(format, Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterDateFormat(String key) {
        Map<String, DateFormat> map = dateFormats;
        synchronized (map) {
            dateFormats.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDateFormats(Map<String, DateFormat> map) {
        Map<String, DateFormat> map2 = dateFormats;
        synchronized (map2) {
            dateFormats.clear();
            dateFormats.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<DateFormat> getDateFormats() {
        Map<String, DateFormat> map = dateFormats;
        synchronized (map) {
            return Collections.unmodifiableCollection(dateFormats.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDateFormats(Map<String, DateFormat> copy) {
        Map<String, DateFormat> map = dateFormats;
        synchronized (map) {
            if (copy != null) {
                copy.putAll(dateFormats);
            }
            dateFormats.clear();
        }
    }

    private Util() {
    }

    public static void setKeyWordClass(String pvKeyWordClass) {
        if (pvKeyWordClass != null && pvKeyWordClass.length() > 0) {
            keyWordClass = pvKeyWordClass;
            ReflectionMethodHelper.clearPropertiesCache();
        }
    }

    public static String getKeyWordClass() {
        return keyWordClass;
    }

    public static void resetKeyWordClass() {
        Util.setKeyWordClass(DEFAULT_KEY_WORD_CLASS);
    }

    public static boolean initJdkLogger() {
        return Util.initJdkLogger(Util.class.getResourceAsStream("jdk14-logging.properties"));
    }

    public static boolean initJdkLogger(InputStream pvInputStream) {
        try {
            LogManager.getLogManager().readConfiguration(pvInputStream);
            Logger logger = Logger.getLogger("global");
            LogManager.getLogManager().addLogger(logger);
            logger.finest("Jdk14Logger initialisiert ...");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Date string2Date(String pvDateString) {
        if (pvDateString == null) {
            throw new IllegalArgumentException(pvDateString);
        }
        try {
            return new Date(Long.parseLong(pvDateString));
        }
        catch (Exception e) {
            if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
                NonCriticalExceptionHandler.handleException(Util.class, e, "1st pass string2Date: " + pvDateString);
            }
            try {
                return Timestamp.valueOf(pvDateString);
            }
            catch (Exception e2) {
                if (NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) {
                    NonCriticalExceptionHandler.handleException(Util.class, e2, "2nd pass string2Date: " + pvDateString);
                }
                Collection<DateFormat> dfList = Util.getDateFormats();
                for (DateFormat df : dfList) {
                    try {
                        return df.parse(pvDateString);
                    }
                    catch (ParseException e3) {
                        if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) continue;
                        NonCriticalExceptionHandler.handleException(Util.class, e3, "3nd pass string2Date: " + pvDateString);
                    }
                }
                throw new IllegalArgumentException(pvDateString);
            }
        }
    }

    public static Class<?> getArrayType(Object pvListObj) {
        Class<Object> lvType = Object.class;
        if (pvListObj == null) {
            return lvType;
        }
        if (pvListObj.getClass().isArray()) {
            Object[] o = (Object[])pvListObj;
            if (o.length > 0) {
                Class<?> lvClass = o[0].getClass();
                if (Map.class.isAssignableFrom(lvClass)) {
                    return Object.class;
                }
                for (int i = 0; i < o.length; ++i) {
                    if (lvClass.equals(o[i].getClass())) continue;
                    return lvType;
                }
                return lvClass;
            }
            return o.getClass().getComponentType();
        }
        if (pvListObj instanceof Collection) {
            Collection coll = (Collection)pvListObj;
            if (coll.size() > 0) {
                Class<?> lvClass = coll.iterator().next().getClass();
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    if (lvClass.equals(it.next().getClass())) continue;
                    return lvType;
                }
                return lvClass;
            }
            return lvType;
        }
        return lvType;
    }

    public static void delLastComma(StringBuffer s) {
        int lvPos = s.length() - 1;
        if (lvPos > 0 && s.charAt(lvPos) == ',') {
            s.deleteCharAt(lvPos);
        }
    }

    public static boolean isStringInArray(String[] pvList, String pvSearchString) {
        for (String pvi : pvList) {
            if (!pvi.equals(pvSearchString)) continue;
            return true;
        }
        return false;
    }

    public static Map<Object, Object> filterMapByKeys(Map<Object, Object> pvSearchMap, String[] pvList) {
        if (pvList == null || pvList.length == 0) {
            return pvSearchMap;
        }
        TreeMap<Object, Object> lvReturnMap = new TreeMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : pvSearchMap.entrySet()) {
            if (!Util.isStringInArray(pvList, (String)entry.getKey())) continue;
            lvReturnMap.put(entry.getKey(), entry.getValue());
        }
        return lvReturnMap;
    }

    static {
        Util.registerDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        Util.registerDateFormat("yyyy-MM-dd");
    }
}

