/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Dataset;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SymbolType;
import com.supermap.data.Workspace;
import com.supermap.mapping.Map;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeLabel;
import com.supermap.mapping.TrackingLayerDrawingEvent;
import com.supermap.mapping.TrackingLayerDrawingListener;
import com.supermap.ui.Action;
import com.supermap.ui.InteractionMode;
import com.supermap.ui.MapControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class SymbolPreViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MapControl _$6;
    private Workspace _$5;
    private Map _$4;
    private Dataset _$3;
    private ThemeLabel _$2;
    private TrackingLayerDrawingListener _$1;

    public SymbolPreViewPanel(Workspace workspace, SymbolType symbolType) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), "\u9884\u89c8", 0, 0, null, null));
        this.setBackground(Color.WHITE);
        this._$5 = workspace;
        if (symbolType.equals((Object)SymbolType.MARKER)) {
            this.setPreferredSize(new Dimension(80, 180));
            this.setMinimumSize(new Dimension(80, 180));
        } else if (symbolType.equals((Object)SymbolType.LINE)) {
            this.setPreferredSize(new Dimension(80, 180));
            this.setMinimumSize(new Dimension(80, 180));
        } else if (symbolType.equals((Object)SymbolType.FILL)) {
            this.setPreferredSize(new Dimension(250, 140));
            this.setMinimumSize(new Dimension(250, 140));
            this.setMaximumSize(new Dimension(250, 140));
        }
        this.add((Component)this.getPreViewMapControl(), "Center");
        this._$6.setAction(Action.NULL);
        this._$6.setMarginPanEnabled(true);
        this._$6.setInteractionMode(InteractionMode.CUSTOMALL);
    }

    public SymbolPreViewPanel(Dataset dataset) {
        this._$3 = dataset;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), "\u9884\u89c8", 0, 0, null, null));
        this.setBackground(Color.WHITE);
        this._$5 = this._$3.getDatasource().getWorkspace();
        this.add((Component)this.getPreViewMapControl(), "Center");
        this._$6.setMarginPanEnabled(true);
        this._$6.setAction(Action.PAN);
    }

    protected Dataset getDataset() {
        return this._$3;
    }

    protected MapControl getPreViewMapControl() {
        if (this._$6 == null) {
            this._$6 = new MapControl();
            this._$6.setAction(Action.PAN);
            this._$6.setFocusable(false);
            if (this._$5 != null) {
                this._$6.getMap().setWorkspace(this._$5);
            }
            this._$4 = this._$6.getMap();
        }
        return this._$6;
    }

    protected void refreshPreViewMapControl(SymbolType symbolType, GeoStyle geoStyle) {
        GeoPoint geoPoint = null;
        if (symbolType.equals((Object)SymbolType.MARKER)) {
            geoPoint = new GeoPoint(0.0, 0.0);
        } else if (symbolType.equals((Object)SymbolType.LINE)) {
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(new Point2D(-9.0, 0.0));
            point2Ds.add(new Point2D(9.0, 0.0));
            geoPoint = new GeoLine(point2Ds);
        } else {
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(new Point2D(-8.0, 8.0));
            point2Ds.add(new Point2D(8.0, 8.0));
            point2Ds.add(new Point2D(8.0, -8.0));
            point2Ds.add(new Point2D(-8.0, -8.0));
            geoPoint = new GeoRegion(point2Ds);
        }
        geoPoint.setStyle(geoStyle);
        this._$4.getTrackingLayer().clear();
        this._$4.getTrackingLayer().add((Geometry)geoPoint, "geometry");
        this._$4.refresh();
    }

    protected void refreshPreViewMapControl(Theme theme) {
        this._$4.getLayers().clear();
        this._$4.getLayers().add(this._$3, theme, true);
        this._$4.refresh();
    }

    protected void addMapTrackingLayerDrawingListener() {
        this._$1 = new TrackingLayerDrawingListener(){

            public void trackingLayerDrawing(TrackingLayerDrawingEvent trackingLayerDrawingEvent) {
                SymbolPreViewPanel.this._$4.setViewBounds(new Rectangle2D(-10.0, -10.0, 10.0, 10.0));
            }
        };
        this._$4.addTrackingLayerDrawingListener(this._$1);
    }

    protected void removeMapTrackingLayerDrawingListener() {
        this._$4.removeTrackingLayerDrawingListener(this._$1);
    }

    protected Workspace getWorkspace() {
        return this._$5;
    }
}

