/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.Datasource;
import com.supermap.data.EngineType;
import com.supermap.ui.InternalImageIconFactory;
import com.supermap.ui.NodeDataType;
import com.supermap.ui.TreeNodeData;
import com.supermap.ui.TreeNodeDecorator;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class DatasourceNodeDecorator
implements TreeNodeDecorator {
    DatasourceNodeDecorator() {
    }

    public void decorate(JLabel jLabel, TreeNodeData treeNodeData) {
        if (treeNodeData.getType().equals((Object)NodeDataType.DATASOURCE)) {
            Datasource datasource = (Datasource)treeNodeData.getData();
            jLabel.setText(datasource.getAlias());
            ImageIcon imageIcon = (ImageIcon)jLabel.getIcon();
            EngineType engineType = datasource.getEngineType();
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            if (engineType.equals((Object)EngineType.UDB)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_UDB.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.ORACLEPLUS)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_ORACLE.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.IMAGEPLUGINS)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_IMAGEPLUGINS.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.OGC)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_OGC.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.SQLPLUS)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_SQL.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.GOOGLEMAPS)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_GOOGLEMAPS.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.DB2)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_DB2.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.KINGBASE)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_KINGBASE.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.POSTGRESQL)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_POSTGRESQL.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.BAIDUMAPS)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_BAIDUMAPS.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.DM)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_DMPLUS.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.ISERVERREST)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_ISERVERREST.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.MAPWORLD)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_MAPWORLD.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.ORACLESPATIAL)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_ORACLESPATIAL.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.SUPERMAPCLOUD)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_SUPERMAPCLOUD.getImage(), 0, 0, jLabel);
            } else if (engineType.equals((Object)EngineType.VECTORFILE)) {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_VECTORFILE.getImage(), 0, 0, jLabel);
            } else {
                graphics.drawImage(InternalImageIconFactory.DATASOURCE_DEFAULT.getImage(), 0, 0, jLabel);
            }
            imageIcon.setImage(bufferedImage);
        }
    }
}

