/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Maps;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Resources;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceVersion;
import com.supermap.mapping.ChartSetting;
import com.supermap.mapping.GridSetting;
import com.supermap.mapping.ImageType;
import com.supermap.mapping.InternalDataset;
import com.supermap.mapping.InternalDatasets;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoRegion;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalImageType;
import com.supermap.mapping.InternalMapControl;
import com.supermap.mapping.InternalPrjCoordSys;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.InternalResources;
import com.supermap.mapping.InternalToolkitMapping;
import com.supermap.mapping.Layer;
import com.supermap.mapping.Layers;
import com.supermap.mapping.MapClosedEvent;
import com.supermap.mapping.MapClosedListener;
import com.supermap.mapping.MapColorMode;
import com.supermap.mapping.MapDrawContinuingEvent;
import com.supermap.mapping.MapDrawContinuingListener;
import com.supermap.mapping.MapDrawingEvent;
import com.supermap.mapping.MapDrawingListener;
import com.supermap.mapping.MapDrawnEvent;
import com.supermap.mapping.MapDrawnListener;
import com.supermap.mapping.MapNative;
import com.supermap.mapping.MapOpenedEvent;
import com.supermap.mapping.MapOpenedListener;
import com.supermap.mapping.MapOverlapDisplayedOptions;
import com.supermap.mapping.MapPainter;
import com.supermap.mapping.PDFOptions;
import com.supermap.mapping.ScreenLayer;
import com.supermap.mapping.Selection;
import com.supermap.mapping.TrackingLayer;
import com.supermap.mapping.TrackingLayerDrawingEvent;
import com.supermap.mapping.TrackingLayerDrawingListener;
import com.supermap.mapping.TrackingLayerDrawnEvent;
import com.supermap.mapping.TrackingLayerDrawnListener;
import com.supermap.ui.Action;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.MapControl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class Map
extends InternalHandleDisposable {
    private Dimension _$17 = new Dimension(256, 256);
    private Workspace _$16 = null;
    private Layers _$15 = null;
    private TrackingLayer _$14 = null;
    private ScreenLayer _$13 = null;
    private GeoRegion _$12 = null;
    private GeoStyle _$11 = null;
    private PrjCoordSys _$10 = null;
    private MapControl _$9 = null;
    private GridSetting _$8 = null;
    private Resources _$7 = null;
    transient Vector m_mapDrawingListeners;
    transient Vector m_mapDrawnListeners;
    transient Vector m_mapDrawContinuingListeners;
    transient Vector m_mapSteppedListeners;
    transient Vector m_trackingLayerDrawingListeners;
    transient Vector m_trackingLayerDrawnListeners;
    transient Vector m_mapOpenedListeners;
    transient Vector m_mapClosedListeners;
    private long _$6 = 0L;
    private boolean _$5 = true;
    private static String _$4;
    private ChartSetting _$3 = null;
    private MapOverlapDisplayedOptions _$2 = null;
    private CoordSysTransParameter _$1 = null;
    ReentrantLock m_lock;

    public Map() {
        this.m_lock = new ReentrantLock();
        long l = MapNative.jni_New();
        this.setHandle(l, true);
        this._$6 = MapNative.jni_RegisteAllEvents(l, this);
        this._$6();
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    public Map(Workspace workspace) {
        this.m_lock = new ReentrantLock();
        if (workspace == null) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
        if (l == 0L) {
            String string = InternalResource.loadString("workspace", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = MapNative.jni_New();
        this.setHandle(l2, true);
        this._$6 = MapNative.jni_RegisteAllEvents(l2, this);
        this._$6();
        this.setWorkspace(workspace);
        this._$16 = workspace;
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)workspace);
    }

    private Map(long l, MapControl mapControl, ReentrantLock reentrantLock) {
        this.m_lock = reentrantLock;
        this.setHandle(l, false);
        this._$9 = mapControl;
        MapNative.jni_RegisteAllEvents(l, this);
        MapNative.jni_SetName(this.getHandle(), "UntitledMap");
        MapNative.jni_SetModified(this.getHandle(), false);
    }

    private Map(long l) {
        this.m_lock = new ReentrantLock();
        this.setHandle(l, false);
        MapNative.jni_RegisteAllEvents(l, this);
    }

    private Map(long l, String string) {
        this.m_lock = new ReentrantLock();
        this.setHandle(l, false);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        MapNative.jni_SetName(this.getHandle(), string);
    }

    public boolean isClipRegionEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isClipRegionEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsClipRegionEnabled(this.getHandle());
    }

    public void setClipRegionEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegionEnabled(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetClipRegionEnabled(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public GeoRegion getClipRegion() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$12 == null && (l = MapNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this._$12 = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$12, (boolean)false);
        }
        return this._$12;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetClipRegion(this.getHandle(), l2);
        if (this._$12 == null && (l = MapNative.jni_GetClipRegion(this.getHandle())) != 0L) {
            this._$12 = (GeoRegion)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$12, (boolean)false);
        }
        if (this._$12 != null) {
            this._$12.fromXML(geoRegion.toXML());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
        this.m_lock.unlock();
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDescription()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setDescription(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        MapNative.jni_SetDescription(this.getHandle(), string);
    }

    public double getAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAngle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetAngle(this.getHandle());
    }

    public void setAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAngle(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetAngle(this.getHandle(), d);
        this.m_lock.unlock();
    }

    public GeoStyle getBackgroundStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBackgroundStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$11 == null && (l = MapNative.jni_GetBackGroundStyle(this.getHandle())) != 0L) {
            this._$11 = InternalGeoStyle.createInstance(l);
        }
        return this._$11;
    }

    public void setBackgroundStyle(GeoStyle geoStyle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBackgroundStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geoStyle == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        GeoStyle geoStyle2 = geoStyle.clone();
        long l2 = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle2);
        MapNative.jni_SetBackgroundStyle(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.m_lock.unlock();
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public Rectangle2D getViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public boolean isViewBoundsLocked() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsViewBoundsLocked(this.getHandle());
    }

    public void setViewBoundsLocked(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsViewBoundsLocked(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Rectangle2D getLockedViewBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewBounds()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetLockedViewBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setLockedViewBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewBounds(Rectangle2D value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "Map_ViewBoundsWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetLockedViewBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_GetCenter(this.getHandle(), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCenter(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
        this.m_lock.unlock();
    }

    public MapColorMode getColorMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetColorMode(this.getHandle());
        return (MapColorMode)InternalEnum.parseUGCValue(MapColorMode.class, n);
    }

    public void setColorMode(MapColorMode mapColorMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorMode(MapColorMode value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mapColorMode == null) {
            String string = InternalResource.loadString("mapColorMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue(mapColorMode);
        this.m_lock.lock();
        MapNative.jni_SetColorMode(this.getHandle(), n);
        this.m_lock.unlock();
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsSmoothingMode(this.getHandle());
    }

    public void setAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsAntialias(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsSmoothingMode(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public boolean isTextAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsTextAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        this.m_lock.lock();
        bl = MapNative.jni_GetIsTextFixedAngle(this.getHandle());
        this.m_lock.unlock();
        return bl;
    }

    public void setTextAngleFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsTextAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsTextFixedAngle(this.getHandle(), bl);
    }

    public boolean isTextOrientationFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsTextOrientationFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsFixedTextOrientation(this.getHandle());
    }

    public void setTextOrientationFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsTextOrientationFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsFixedTextOrientation(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public boolean isMarkerAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsMarkerAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsMarkerFixedAngle(this.getHandle());
    }

    public void setMarkerAngleFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsMarkerAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsMarkerFixedAngle(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsModified(this.getHandle());
    }

    public void setModified(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setModified(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsModified(this.getHandle(), bl);
    }

    public boolean isPaintBackground() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsPaintBackground()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsPaintBackground(this.getHandle());
    }

    public void setPaintBackground(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsPaintBackground(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsPaintBackground(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public double getMaxVisibleTextSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleTextSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxVisibleTextSize(this.getHandle());
    }

    public void setMaxVisibleTextSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleTextSize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Map_MaxVisibleTextSizeError", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxVisibleTextSize(this.getHandle(), d);
    }

    public double getMinVisibleTextSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleTextSize()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMinVisibleTextSize(this.getHandle());
    }

    public void setMinVisibleTextSize(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleTextSize(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Map_MinVisibleTextSizeError", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMinVisibleTextSize(this.getHandle(), d);
    }

    public int getMaxVisibleVertex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleVertex()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxVisibleVertex(this.getHandle());
    }

    public void setMaxVisibleVertex(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleVertex(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Map_MaxVisibleVertexShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxVisibleVertex(this.getHandle(), n);
    }

    public double getScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetScale(this.getHandle());
    }

    public void setScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "MapSacleShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = MapNative.jni_SetScale(this.getHandle(), d);
        this.m_lock.unlock();
        if (!bl) {
            String string = InternalResource.loadString("value", "MapScaleIsZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public double getMinScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMinScale(this.getHandle());
    }

    public void setMinScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMinScale(this.getHandle(), d);
    }

    public double getMaxScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMaxScale(this.getHandle());
    }

    public void setMaxScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMaxScale(this.getHandle(), d);
    }

    public Unit getCoordUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoordUnit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetCoordUnit(this.getHandle());
        return (Unit)InternalEnum.parseUGCValue(Unit.class, n);
    }

    public void setCoordUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoordUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)unit);
        MapNative.jni_SetCoordUnit(this.getHandle(), n);
    }

    public Unit getDistanceUnit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceUnit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetDistanceUnit(this.getHandle());
        return (Unit)InternalEnum.parseUGCValue(Unit.class, n);
    }

    public void setDistanceUnit(Unit unit) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDistanceUnit(Unit value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (unit == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)unit);
        MapNative.jni_SetDistanceUnit(this.getHandle(), n);
    }

    public TrackingLayer getTrackingLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$14 == null) {
            long l = MapNative.jni_GetTrackingLayer(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this._$14 = TrackingLayer.createInstance(l, this);
        }
        return this._$14;
    }

    public ScreenLayer getScreenLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScreenLayer()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$13 == null) {
            long l = MapNative.jni_GetScreenLayer(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this._$13 = ScreenLayer.createInstance(l, this);
        }
        return this._$13;
    }

    public boolean isDynamicProjection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsDynamicProjection()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsDynamicProjection(this.getHandle());
    }

    public void setDynamicProjection(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsDynamicProjection(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetIsDynamicProjection(this.getHandle(), bl);
        this.m_lock.unlock();
    }

    public PrjCoordSys getPrjCoordSys() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPrjCoordSys()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$10 == null && (l = MapNative.jni_GetPrjCoordSys(this.getHandle())) != 0L) {
            this._$10 = InternalPrjCoordSys.createInstance(l, false);
        }
        return this._$10;
    }

    public void setPrjCoordSys(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)prjCoordSys);
        MapNative.jni_SetPrjCoordSys(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)prjCoordSys);
        this.m_lock.unlock();
    }

    public CoordSysTransMethod getDynamicPrjTransMethond() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = MapNative.jni_GetTransMethod(this.getHandle());
        return (CoordSysTransMethod)InternalEnum.parseUGCValue(CoordSysTransMethod.class, n);
    }

    public void setDynamicPrjTransMethond(CoordSysTransMethod coordSysTransMethod) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTransMethod(this.getHandle(), coordSysTransMethod.value());
    }

    public CoordSysTransParameter getDynamicPrjTransParameter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 == null) {
            long l = MapNative.jni_GetTransParameter(this.getHandle());
            this._$1 = new CoordSysTransParameter(l, false);
        }
        return this._$1;
    }

    public void setDynamicPrjTransParameter(CoordSysTransParameter coordSysTransParameter) {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPrjCoordSys(PrjCoordSys value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l2 = l = coordSysTransParameter == null ? 0L : InternalHandle.getHandle((com.supermap.data.InternalHandle)coordSysTransParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_setTransParameter(this.getHandle(), l);
    }

    public Layers getLayers() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5()) {
            String string = InternalResource.loadString("getLayers()", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        if (this._$15 == null && (l = MapNative.jni_GetLayersHandle(this.getHandle())) != 0L) {
            this._$15 = Layers.createInstance(l, this, this.m_lock);
        }
        this.m_lock.unlock();
        return this._$15;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorkspace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkspace(Workspace workspace) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        try {
            long l;
            this.m_lock.lock();
            String string = "";
            if (this._$16 != null) {
                l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16);
                if (l == 0L) {
                    String string2 = InternalResource.loadString("setWorkspace()", "Map_DontDisposeOldWorkspace", "mapping_resources");
                    throw new IllegalStateException(string2);
                }
                string = this.toXML();
            }
            this.close();
            if (workspace == null) {
                this._$16 = null;
            } else {
                l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)workspace);
                if (l == 0L) {
                    String string3 = InternalResource.loadString("workspace", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                    throw new IllegalArgumentException(string3);
                }
                MapNative.jni_SetWorkspace(this.getHandle(), l);
                this._$16 = workspace;
            }
            if (!string.trim().equals("")) {
                this.fromXML(string);
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public Dimension getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = null;
        dimension = this._$9 == null ? new Dimension(this._$17) : new Dimension(this._$9.getWidth(), this._$9.getHeight());
        return dimension;
    }

    public void setImageSize(Dimension dimension) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsModified()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dimension == null) {
            String string = InternalResource.loadString("size", "Global_ArgumentNull", "mapping_resources");
            throw new NullPointerException(string);
        }
        if (dimension.getWidth() <= 0.0) {
            String string = InternalResource.loadString("size", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (dimension.getHeight() <= 0.0) {
            String string = InternalResource.loadString("size", "Map_ClientHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this._$17.width = dimension.width;
        this._$17.height = dimension.height;
        this.m_lock.lock();
        if (this._$9 == null) {
            MapNative.jni_SetImageSize(this.getHandle(), dimension.width, dimension.height);
        } else {
            this._$9.setSize(this._$17);
            MapNative.jni_SetImageSize(this.getHandle(), dimension.width, dimension.height);
        }
        this.m_lock.unlock();
    }

    public boolean isOverlapDisplayed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOverlapDisplayed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetIsOverlapDisplayed(this.getHandle());
    }

    public void setOverlapDisplayed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetIsOverlapDisplayed(this.getHandle(), bl);
    }

    public MapOverlapDisplayedOptions getOverlapDisplayedOptions() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOverlapDisplayedOptions()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$2 == null && (l = MapNative.jni_GetOverlapDisplayedOptionsHandle(this.getHandle())) != 0L) {
            this._$2 = new MapOverlapDisplayedOptions(l, false);
        }
        return this._$2;
    }

    public void setOverlapDisplayedOptions(MapOverlapDisplayedOptions mapOverlapDisplayedOptions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOverlapDisplayedOptions(MapOverlapDisplayedOptions value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (mapOverlapDisplayedOptions == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)mapOverlapDisplayedOptions) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)mapOverlapDisplayedOptions);
        MapNative.jni_SetOverlapDisplayedOptionsHandle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)mapOverlapDisplayedOptions));
    }

    public GridSetting getGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGrid()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            this._$8 = new GridSetting(this);
        }
        return this._$8;
    }

    public void setGrid(GridSetting gridSetting) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGrid(GridSetting value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$8 == null) {
            this._$8 = new GridSetting(this);
        }
        this._$8.setDashStyle(gridSetting.getDashStyle());
        this._$8.setHorizontalSpacing(gridSetting.getHorizontalSpacing());
        this._$8.setSizeFixed(gridSetting.isSizeFixed());
        this._$8.setSnapable(gridSetting.isSnapable());
        this._$8.setSolidStyle(gridSetting.getSolidStyle());
        this._$8.setType(gridSetting.getType());
        this._$8.setVerticalSpacing(gridSetting.getVerticalSpacing());
        this._$8.setVisible(gridSetting.isVisible());
    }

    @Deprecated
    public Resources getResouces() {
        return this.getResources();
    }

    public Resources getResources() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResouces()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$7 == null && (l = MapNative.jni_GetResouces(this.getHandle())) != 0L) {
            this._$7 = InternalResources.createInstance(this._$16, l);
        }
        return this._$7;
    }

    public void setResources(Resources resources) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResources(Resources resources)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (resources == null) {
            MapNative.jni_SetResources(this.getHandle(), 0L);
            if (this._$7 != null) {
                InternalResources.clearHandle(this._$7);
            }
        } else {
            long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)resources);
            if (l == 0L) {
                String string = InternalResource.loadString("resources", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            long l2 = MapNative.jni_SetResources(this.getHandle(), l);
            if (this._$7 != null) {
                InternalResources.refreshHandle(this._$7, l2);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)resources);
    }

    public Rectangle2D getCustomBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapNative.jni_GetCustomBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setCustomBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomBounds(Rectangle2D rectangle2D)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_SetCustomBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
        this.m_lock.unlock();
    }

    public boolean isCustomBoundsEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCustomBoundsEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsCustomBoundsEnabled(this.getHandle());
    }

    public void setCustomBoundsEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomBoundsEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetCustomBoundsEnabled(this.getHandle(), bl);
    }

    public boolean isVisibleScalesEnabled() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsVisibleScalesEnabled(this.getHandle());
    }

    public void setVisibleScalesEnabled(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleScalesEnabled()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetVisibleScalesEnabled(this.getHandle(), bl);
    }

    public double[] getVisibleScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetVisibleScales(this.getHandle());
    }

    public void setVisibleScales(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            String string = InternalResource.loadString("setVisibleScales()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetVisibleScales(this.getHandle(), dArray);
    }

    public boolean isTextAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsTextAntialias(this.getHandle());
    }

    public void setTextAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetTextAntialias(this.getHandle(), bl);
    }

    public boolean isLineAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isLineAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsLineAntialias(this.getHandle());
    }

    public void setLineAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetLineAntialias(this.getHandle(), bl);
    }

    public boolean outputMapToEMF(String string) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToEMF(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".emf");
        return MapNative.jni_OutputMapToEMF(this.getHandle(), string5, this._$17.width, this._$17.height);
    }

    boolean outputMapToPDF(String string, PDFOptions pDFOptions) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToPDF(String fileName, PDFOptions options)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (this._$17.width <= 0) {
            String string5 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$17.height <= 0) {
            String string6 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string7 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string7);
        }
        if (!this._$1(string)) {
            String string8 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        String string9 = this._$1(string, ".pdf");
        int n = 0;
        if (pDFOptions.isPointStyleRetained()) {
            n |= 1;
        }
        if (pDFOptions.isLineStyleRetained()) {
            n |= 2;
        }
        if (pDFOptions.isRegionStyleRetained()) {
            n |= 4;
        }
        int n2 = 0;
        n2 = pDFOptions.isVector() ? 0 : 1;
        boolean bl = pDFOptions.isEntire();
        return MapNative.jni_OutputMapToPDF(this.getHandle(), string9, this._$17.width, this._$17.height, n2, n, bl);
    }

    public BufferedImage outputMapToBitmap() {
        if (!this.IsCanOutputChartPicture()) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this._$17.width, this._$17.height);
        if (InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage) != 0L) {
            MapNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage));
            BufferedImage bufferedImage = new BufferedImage(this._$17.width, this._$17.height, 5);
            bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(), 0, 0, null);
            internalBufferImage.dispose();
            return bufferedImage;
        }
        String string = InternalResource.loadString("outputMapToBitmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
        throw new IllegalStateException(string);
    }

    public BufferedImage outputMapToBitmap(boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        InternalBufferImage internalBufferImage = new InternalBufferImage(this._$17.width, this._$17.height, bl);
        if (InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage) != 0L) {
            MapNative.jni_OutputMapToBitmap(this.getHandle(), InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)internalBufferImage), bl);
            BufferedImage bufferedImage = new BufferedImage(this._$17.width, this._$17.height, 6);
            bufferedImage.getGraphics().drawImage(internalBufferImage.getMemoryImage(bl), 0, 0, null);
            internalBufferImage.dispose();
            return bufferedImage;
        }
        String string = InternalResource.loadString("outputMapToBitmap()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
        throw new IllegalStateException(string);
    }

    public boolean ensureVisible(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleGeo(this.getHandle(), l, 1.0);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public boolean ensureVisible(Geometry geometry, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Geometry geometry, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_EnsureVisibleRatioShouldBeMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleGeo(this.getHandle(), l, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        return bl;
    }

    public boolean ensureVisible(Recordset recordset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Recordset recordset)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleRecordset(this.getHandle(), l, 1.0);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return bl;
    }

    public boolean ensureVisible(Recordset recordset, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Recordset recordset, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_EnsureVisibleRatioShouldBeMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleDisposable.getHandle((com.supermap.data.InternalHandle)recordset);
        if (l == 0L) {
            String string = InternalResource.loadString("recordset", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = MapNative.jni_EnsureVisibleRecordset(this.getHandle(), l, d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)recordset);
        return bl;
    }

    public boolean ensureVisible(Layer layer) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer layer)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return MapNative.jni_EnsureVisibleLayer(this.getHandle(), l, 1.0);
    }

    public boolean ensureVisible(Layer layer, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ensureVisible(Layer layer, double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (layer == null) {
            String string = InternalResource.loadString("layer", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(layer);
        if (l == 0L) {
            String string = InternalResource.loadString("layer", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return MapNative.jni_EnsureVisibleLayer(this.getHandle(), l, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("open(String name)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$16 == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16) == 0L) {
            String string3 = InternalResource.loadString("open(String name)", "Map_SetTheWorkspaceFirst", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        Maps maps = this._$16.getMaps();
        int n = maps.indexOf(string);
        if (n == -1) {
            String string5 = InternalResource.loadString("name", "Global_SpecifiedNameNotExist", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        this.m_lock.lock();
        boolean bl = false;
        try {
            Dimension dimension = this.getImageSize();
            bl = MapNative.jni_Open(this.getHandle(), maps.get(n));
            this.setImageSize(dimension);
            if (bl) {
                this._$2();
                this.getLayers();
                MapOpenedEvent mapOpenedEvent = new MapOpenedEvent((Object)this, this);
                this.fireMapOpened(mapOpenedEvent);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("close()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$16 != null) {
            long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16);
            if (l == 0L) {
                String string = InternalResource.loadString("close()", "Map_CloseMapBeforeDisposeWksp", "mapping_resources");
                throw new IllegalStateException(string);
            }
            if (this._$9 != null) {
                InternalMapControl.clearEdit(this._$9);
            }
            this._$12 = null;
            this.m_lock.lock();
            try {
                Dimension dimension = this.getImageSize();
                MapNative.jni_Close(this.getHandle());
                this.setImageSize(dimension);
                this._$2();
                MapClosedEvent mapClosedEvent = new MapClosedEvent((Object)this, this);
                this.fireMapClosed(mapClosedEvent);
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    public Selection[] findSelection(boolean bl) {
        Selection selection;
        Object object;
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSelection(boolean allVisibleLayer)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Layers layers = this.getLayers();
        int n2 = layers.getCount();
        ArrayList<Selection> arrayList = new ArrayList<Selection>();
        if (bl) {
            for (n = 0; n < n2; ++n) {
                object = layers.get(n);
                selection = object.getSelection();
                if (selection == null || selection.getCount() <= 0) continue;
                arrayList.add(selection);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                object = layers.get(n);
                selection = object.getSelection();
                if (selection == null) continue;
                arrayList.add(selection);
            }
        }
        n = arrayList.size();
        object = new Selection[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (Selection)((Object)arrayList.get(i));
        }
        arrayList.clear();
        arrayList = null;
        return object;
    }

    public boolean outputMapToBMP(String string) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToBMP(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".bmp");
        return this._$1(string5, InternalImageType.BMP, this._$17.width, this._$17.height);
    }

    public boolean outputMapToJPG(String string) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToJPG(String fileName, int imageWidth, int imageHeight)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".jpg");
        return this._$1(string5, InternalImageType.JPG, this._$17.width, this._$17.height);
    }

    public boolean outputMapToPNG(String string, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        String string6 = this._$1(string, ".png");
        if (this._$17.width <= 0) {
            String string7 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this._$17.height <= 0) {
            String string8 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string9 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string9);
        }
        boolean bl2 = false;
        bl2 = MapNative.jni_OutputMapToPNG(this.getHandle(), string6, InternalImageType.PNG.value(), this._$17.width, this._$17.height, bl);
        return bl2;
    }

    public boolean outputTrackingLayerToPNG(String string, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$17.width <= 0) {
            String string6 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this._$17.height <= 0) {
            String string7 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string8 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string8);
        }
        String string9 = this._$1(string, ".png");
        return MapNative.jni_OutputTrackingLayerToPNG1(this.getHandle(), string9, bl, this._$17.width, this._$17.height);
    }

    public boolean outputTrackingLayerToPNG(String string, boolean bl, int n, Rectangle2D rectangle2D) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = this._$1(string, ".png");
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        return MapNative.jni_OutputTrackingLayerToPNG(this.getHandle(), string7, bl, n, dArray);
    }

    public boolean outputScreenLayerToPNG(String string, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = this._$1(string, ".png");
        return MapNative.jni_OutputScreenLayerToPNG(this.getHandle(), string7, bl);
    }

    public boolean outputScreenLayerToPNG(String string, boolean bl, int n, Rectangle2D rectangle2D) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = this._$1(string, ".png");
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        return MapNative.jni_OutputScreenLayerToPNG(this.getHandle(), string7, bl, n, dArray);
    }

    public boolean outputMapToFile(String string, ImageType imageType, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (!this._$5()) {
            String string3 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (!this._$1(string)) {
            String string5 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = ".bmp";
        if (imageType.equals((Object)ImageType.JPG)) {
            string7 = ".jpg";
        } else if (imageType.equals((Object)ImageType.PNG)) {
            string7 = ".png";
        } else if (imageType.equals((Object)ImageType.GIF)) {
            string7 = ".gif";
        } else if (imageType.equals((Object)ImageType.TIFF)) {
            string7 = ".tif";
        } else if (imageType.equals((Object)ImageType.PDF)) {
            string7 = ".pdf";
        } else if (imageType.equals((Object)ImageType.EMF)) {
            string7 = ".emf";
        } else if (imageType.equals((Object)ImageType.EPS)) {
            string7 = ".eps";
        }
        string = this._$1(string, string7);
        return MapNative.jni_OutputMapToFile1(this.getHandle(), string, imageType.value(), bl);
    }

    public boolean outputMapToFile(String string, ImageType imageType, int n, Rectangle2D rectangle2D, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (imageType != ImageType.BMP && imageType != ImageType.JPG && imageType != ImageType.PNG && imageType != ImageType.TIFF) {
            String string2 = InternalResource.loadString("", "Map_OutputImageTypeIsNOTSupported", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("outputTrackingLayerToPNG(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        if (!this._$5()) {
            String string4 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (!this._$1(string)) {
            String string6 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string7 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string7);
        }
        String string8 = ".bmp";
        if (imageType.equals((Object)ImageType.JPG)) {
            string8 = ".jpg";
        } else if (imageType.equals((Object)ImageType.PNG)) {
            string8 = ".png";
        } else if (imageType.equals((Object)ImageType.GIF)) {
            string8 = ".gif";
        } else if (imageType.equals((Object)ImageType.TIFF)) {
            string8 = ".tif";
        } else if (imageType.equals((Object)ImageType.PDF)) {
            string8 = ".pdf";
        } else if (imageType.equals((Object)ImageType.EMF)) {
            string8 = ".emf";
        } else if (imageType.equals((Object)ImageType.EPS)) {
            string8 = ".eps";
        }
        string = this._$1(string, string8);
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        return MapNative.jni_OutputMapToFile2(this.getHandle(), string, imageType.value(), n, dArray, bl);
    }

    public DatasetImage outputMapToDatasetImage(Datasource datasource, String string, double d, Rectangle2D rectangle2D, EncodeType encodeType) {
        if (datasource == null) {
            String string2 = InternalResource.loadString("datasource", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        if (l == 0L) {
            String string3 = InternalResource.loadString("datasource", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string4 = InternalResource.loadString("datasetName", "Layer_ArgumentOfDatasetNameIsIllegal", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        Rectangle2D rectangle2D2 = this.getViewBounds();
        if (rectangle2D2.getWidth() < d || rectangle2D2.getHeight() < d) {
            String string5 = InternalResource.loadString("resolution", "ResolutionIsTooHigh", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (rectangle2D.isEmpty()) {
            rectangle2D = rectangle2D2;
        }
        int n = (int)(rectangle2D.getWidth() / d);
        int n2 = (int)(rectangle2D.getHeight() / d);
        if (n < 10 || n2 < 10) {
            String string6 = InternalResource.loadString("resolution", "ResolutionIsTooHigh", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        int n3 = InternalEnum.getUGCValue((Enum)encodeType);
        long l2 = MapNative.jni_OutputMapToDatasetImage(this.getHandle(), this, l, string, d, dArray, n3);
        DatasetImage datasetImage = null;
        if (l2 != 0L) {
            datasetImage = (DatasetImage)InternalDataset.createInstance(l2, DatasetType.IMAGE, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetImage);
        }
        return datasetImage;
    }

    public boolean outputMapToEPS(String string) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToEPS(String fileName)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        return this._$1(string, InternalImageType.EPS, this._$17.width, this._$17.height);
    }

    public boolean outputMapToGIF(String string, boolean bl) {
        if (!this.IsCanOutputChartPicture()) {
            return false;
        }
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("outputMapToGIF(String fileName, boolean isBackTransparent)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("fileName", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (!this._$1(string)) {
            String string4 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        String string5 = this._$1(string, ".gif");
        if (!this._$5()) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        if (string == null || string.trim().equals("")) {
            String string7 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (this._$17.width <= 0) {
            String string8 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        if (this._$17.height <= 0) {
            String string9 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string10 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string10);
        }
        int n = InternalEnum.getUGCValue(InternalImageType.GIF);
        return MapNative.jni_OutputMapToGIF(this.getHandle(), string5, n, this._$17.width, this._$17.height, bl);
    }

    public void zoom(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("zoom(double ratio)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("ratio", "Map_ZoomRatioShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        MapNative.jni_Zoom(this.getHandle(), d);
        this.m_lock.unlock();
    }

    public void pan(double d, double d2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pan(double offsetX, double offsetY)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        MapNative.jni_Pan(this.getHandle(), d, d2);
        this.m_lock.unlock();
    }

    public Point mapToPixel(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapNative.jni_MapToPixel(this.getHandle(), point2D.getX(), point2D.getY(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        return new Point(n, n2);
    }

    public Point2D mapToLogical(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_MapToLogical(this.getHandle(), point2D.getX(), point2D.getY(), dArray);
        Point2D point2D2 = new Point2D(dArray[0] / 10.0, dArray[1] / 10.0);
        return point2D2;
    }

    public Point2D logicalToMap(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_LogicalToMap(this.getHandle(), Math.round(point2D.getX() * 10.0), Math.round(point2D.getY() * 10.0), dArray);
        Point2D point2D2 = new Point2D(dArray[0], dArray[1]);
        return point2D2;
    }

    public Point logicalToPixel(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = new int[2];
        MapNative.jni_LogicalToPixel(this.getHandle(), point2D.getX(), point2D.getY(), nArray);
        Point point = new Point(nArray[0], (int)(this.getImageSize().getHeight() + (double)nArray[1]));
        return point;
    }

    public Point2D pixelToLogical(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mapToPixel(Point2D point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_PixelToLogical(this.getHandle(), point.x, (int)((double)point.y - this.getImageSize().getHeight()), dArray);
        Point2D point2D = new Point2D(dArray[0], dArray[1]);
        return point2D;
    }

    public Point2D pixelToMap(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("pixelToMap(Point point)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = InternalResource.loadString("point", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        MapNative.jni_PixelToMap(this.getHandle(), point.x, point.y, dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        return new Point2D(d, d2);
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_Refresh(this.getHandle());
        if (this._$9 != null && this._$9.isDisplayable()) {
            InternalMapControl.mapControlInvalidate(this._$9);
        }
    }

    public void refreshTrackingLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refresh()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 == null) {
            this._$5 = true;
        }
        if (!this._$5 && !InternalMapControl.isPanButtonDown(this._$9)) {
            MapNative.jni_Refresh(this.getHandle());
            if (this._$9 != null && this._$9.isDisplayable()) {
                InternalMapControl.mapControlInvalidate(this._$9);
            }
            this._$5 = true;
        } else if (this._$5) {
            MapNative.jni_RefreshTrackingLayer(this.getHandle());
            if (this._$9 != null && this._$9.isDisplayable()) {
                InternalMapControl.mapControlInvalidate(this._$9);
            }
        }
    }

    public void refreshEx(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("refreshEx(Rectangle2D rect)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$9 != null && this._$9.isDisplayable()) {
            InternalMapControl.refreshEx(this._$9, rectangle2D);
        }
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("viewEntire()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        Dimension dimension = this.getImageSize();
        MapNative.jni_ViewEntire(this.getHandle(), dimension.width, dimension.height);
        if (this._$9 != null) {
            this._$5 = false;
        }
        this.refresh();
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml, boolean ignoreCaption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$16 == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16) == 0L) {
            String string3 = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        return this._$1(string, 0);
    }

    public boolean fromXML(String string, WorkspaceVersion workspaceVersion) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromXML(String xml, WorkspaceVersion version)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this._$16 == null || com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16) == 0L) {
            String string3 = InternalResource.loadString("fromXML(String xml)", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n = workspaceVersion.value();
        return this._$1(string, n);
    }

    private boolean _$1(String string, int n) {
        this.m_lock.lock();
        boolean bl = false;
        if (string != null && string.trim().length() != 0 && (bl = MapNative.jni_FromXML2(this.getHandle(), string, n))) {
            this._$1();
            this.getLayers();
            if (this._$9 != null) {
                InternalMapControl.setEditEnvironment(this._$9);
            }
        }
        this.m_lock.unlock();
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toXML()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5()) {
            String string = InternalResource.loadString("toXML()", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_ToXML(this.getHandle());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$16 != null && com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16) == 0L) {
            String string = InternalResource.loadString("dispose()", "Map_DontDisposeWkspBeforeMap", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.close();
        MapNative.jni_Delete(this.getHandle());
        this.clearHandle();
    }

    public boolean isOrthographView() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOrthographView()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsOrthographView(this.getHandle());
    }

    public void setOrthographView(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOrthographView(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetOrthographView(this.getHandle(), bl);
    }

    public boolean isDisableDynamicEffect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisableDynamicEffect()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsDisableDynamicEffect(this.getHandle());
    }

    public void setDisableDynamicEffect(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisableDynamicEffect(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetDisableDynamicEffect(this.getHandle(), bl);
    }

    public boolean isDisableAutoAvoidEffect() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDisableAutoAvoidEffect()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsDisableAutoAvoidEffect(this.getHandle());
    }

    public void setDisableAutoAvoidEffect(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisableAutoAvoidEffect(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetDisableAutoAvoidEffect(this.getHandle(), bl);
    }

    public String getHashCode(ImageType imageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHashCode(ImageType imageType)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetHashCode(this.getHandle(), imageType.value());
    }

    protected static Map createInstance(long l, MapControl mapControl, ReentrantLock reentrantLock) {
        return new Map(l, mapControl, reentrantLock);
    }

    protected static Map createInstance(long l) {
        return new Map(l);
    }

    protected static Map createInstance(long l, String string) {
        return new Map(l, string);
    }

    protected static void clearHandle(Map map) {
        map.clearHandle();
    }

    protected static void resetImageSize(Map map, double d, double d2) {
        map._$17.setSize(d, d2);
    }

    private void _$6() {
        MapNative.jni_Reset(this.getHandle());
        this.setImageSize(this._$17);
    }

    private boolean _$5() {
        if (this._$16 == null) {
            return false;
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$16);
        return l != 0L;
    }

    private boolean _$1(String string, InternalImageType internalImageType, int n, int n2) {
        if (!this._$5()) {
            String string2 = InternalResource.loadString("", "Map_WorkspaceIsEmpty", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().equals("")) {
            String string3 = InternalResource.loadString("fileName:" + string, "Global_PathIsNotValid", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        if (n <= 0) {
            String string4 = InternalResource.loadString("imageWidth", "Map_ImageWidthShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (n2 <= 0) {
            String string5 = InternalResource.loadString("imageHeight", "Map_ImageHeightShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this._$16.getDatasources() == null || this._$16.getDatasources().getCount() == 0) {
            String string6 = InternalResource.loadString("", "Map_WorkspaceHasNoDatasource", "mapping_resources");
            throw new IllegalStateException(string6);
        }
        int n3 = InternalEnum.getUGCValue(internalImageType);
        return MapNative.jni_OutputMapToFile(this.getHandle(), string, n3, n, n2);
    }

    protected void clearHandle() {
        this._$1();
        this._$3();
        this._$4();
        this._$16 = null;
        this.setHandle(0L);
    }

    private void _$4() {
        if (this._$3 != null) {
            this._$3.clearHandle();
        }
    }

    private void _$3() {
        if (this._$6 != 0L) {
            MapNative.jni_DeleteSelfEventHandle(this._$6);
            this._$6 = 0L;
        }
    }

    private void _$2() {
        if (this._$15 != null) {
            ArrayList<Layer> arrayList = this._$15.getLayersList();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Layer layer = arrayList.get(i);
                layer.clearHandle();
            }
            arrayList.clear();
            this._$15 = null;
        }
    }

    private void _$1() {
        if (this._$15 != null) {
            this._$15.clearHandle();
            this._$15 = null;
        }
        if (this._$14 != null) {
            this._$14.clearHandle();
            this._$14 = null;
        }
        if (this._$13 != null) {
            this._$13.clearHandle();
            this._$13 = null;
        }
        if (this._$11 != null) {
            InternalGeoStyle.clearHandle(this._$11);
            this._$11 = null;
        }
        if (this._$10 != null) {
            InternalPrjCoordSys.clearHandle(this._$10);
            this._$10 = null;
        }
        if (this._$2 != null) {
            this._$2.clearHandle();
            this._$2 = null;
        }
        if (this._$12 != null) {
            InternalGeoRegion.clearHandle(this._$12);
            this._$12 = null;
        }
        if (this._$7 != null) {
            InternalResources.clearHandle(this._$7);
            this._$7 = null;
        }
        if (this._$1 != null) {
            this._$1.clearHandle();
            this._$1 = null;
        }
    }

    private String _$1(String string, String string2) {
        String string3 = null;
        if (string.toLowerCase().endsWith(string2)) {
            int n = string.toLowerCase().lastIndexOf(string2);
            string3 = string.substring(0, n) + string2;
        } else {
            string3 = string + string2;
        }
        return string3;
    }

    private boolean _$1(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.getParent() == null) {
            bl = true;
        } else {
            File file2 = new File(file.getParent());
            if (file2.exists()) {
                bl = true;
            }
        }
        return bl;
    }

    public synchronized void addDrawingListener(MapDrawingListener mapDrawingListener) {
        if (this.m_mapDrawingListeners == null) {
            this.m_mapDrawingListeners = new Vector();
        }
        if (!this.m_mapDrawingListeners.contains(mapDrawingListener)) {
            this.m_mapDrawingListeners.add(mapDrawingListener);
        }
    }

    public synchronized void removeDrawingListener(MapDrawingListener mapDrawingListener) {
        if (this.m_mapDrawingListeners != null && this.m_mapDrawingListeners.contains(mapDrawingListener)) {
            this.m_mapDrawingListeners.remove(mapDrawingListener);
        }
    }

    protected void fireDrawing(MapDrawingEvent mapDrawingEvent) {
        if (this.m_mapDrawingListeners != null) {
            Vector vector = this.m_mapDrawingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapDrawingListener)vector.elementAt(i)).mapDrawing(mapDrawingEvent);
            }
        }
    }

    static void drawingCallBack(Map map, long l, long l2) {
        if (map != null) {
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(l);
            MapDrawingEvent mapDrawingEvent = new MapDrawingEvent((Object)map, map, (boolean)bl);
            map.fireDrawing(mapDrawingEvent);
            InternalToolkitMapping.setHandleBooleanValue(l, mapDrawingEvent.getCancel());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addDrawnListener(MapDrawnListener mapDrawnListener) {
        if (this.m_mapDrawnListeners == null) {
            this.m_mapDrawnListeners = new Vector();
        }
        if (!this.m_mapDrawnListeners.contains(mapDrawnListener)) {
            this.m_mapDrawnListeners.add(mapDrawnListener);
        }
    }

    public synchronized void removeDrawnListener(MapDrawnListener mapDrawnListener) {
        if (this.m_mapDrawnListeners != null && this.m_mapDrawnListeners.contains(mapDrawnListener)) {
            this.m_mapDrawnListeners.remove(mapDrawnListener);
        }
    }

    protected void fireDrawn(MapDrawnEvent mapDrawnEvent) {
        if (this.m_mapDrawnListeners != null) {
            Vector vector = this.m_mapDrawnListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapDrawnListener)vector.elementAt(i)).mapDrawn(mapDrawnEvent);
            }
        }
    }

    static void drawnCallBack(Map map, long l) {
        if (map != null) {
            MapPainter mapPainter = new MapPainter(map, l);
            MapDrawnEvent mapDrawnEvent = new MapDrawnEvent((Object)map, map, mapPainter);
            map.fireDrawn(mapDrawnEvent);
            mapPainter.copyBufferImageToUGC();
            mapPainter.realeaseGraphics();
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addDrawContinuingListener(MapDrawContinuingListener mapDrawContinuingListener) {
        if (this.m_mapDrawContinuingListeners == null) {
            this.m_mapDrawContinuingListeners = new Vector();
        }
        if (!this.m_mapDrawContinuingListeners.contains(mapDrawContinuingListener)) {
            this.m_mapDrawContinuingListeners.add(mapDrawContinuingListener);
        }
    }

    public synchronized void removeDrawContinuingListener(MapDrawContinuingListener mapDrawContinuingListener) {
        if (this.m_mapDrawContinuingListeners != null && this.m_mapDrawContinuingListeners.contains(mapDrawContinuingListener)) {
            this.m_mapDrawContinuingListeners.remove(mapDrawContinuingListener);
        }
    }

    protected void fireDrawContinuing(MapDrawContinuingEvent mapDrawContinuingEvent) {
        if (this.m_mapDrawContinuingListeners != null) {
            Vector vector = this.m_mapDrawContinuingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapDrawContinuingListener)vector.elementAt(i)).mapDrawContinuing(mapDrawContinuingEvent);
            }
        }
    }

    static void drawContinuingCallBack(Map map, int n, long l) {
        if (map != null) {
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(l);
            MapDrawContinuingEvent mapDrawContinuingEvent = new MapDrawContinuingEvent((Object)map, map, n, bl);
            map.fireDrawContinuing(mapDrawContinuingEvent);
            boolean bl2 = false;
            if (map.getMapControl() != null) {
                Action action = map.getMapControl().getAction();
                Point point = map.getMapControl().getMousePosition(false);
                bl2 = InternalToolkitMapping.isEscape(action.value(), point != null);
            }
            InternalToolkitMapping.setHandleBooleanValue(l, mapDrawContinuingEvent.getCancel() || bl2);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_mapSteppedListeners == null) {
            this.m_mapSteppedListeners = new Vector();
        }
        if (!this.m_mapSteppedListeners.contains(steppedListener)) {
            this.m_mapSteppedListeners.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_mapSteppedListeners != null && this.m_mapSteppedListeners.contains(steppedListener)) {
            this.m_mapSteppedListeners.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_mapSteppedListeners != null) {
            Vector vector = this.m_mapSteppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Map map, int n, long l, String string, String string2, long l2) {
        if (map != null) {
            _$4 = "outputMapToDatasetImage";
            boolean bl = InternalToolkitMapping.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)map, n, l, string, string2, _$4, bl);
            map.fireStepped(steppedEvent);
            InternalToolkitMapping.setHandleBooleanValue(l2, steppedEvent.getCancel());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addTrackingLayerDrawingListener(TrackingLayerDrawingListener trackingLayerDrawingListener) {
        if (this.m_trackingLayerDrawingListeners == null) {
            this.m_trackingLayerDrawingListeners = new Vector();
        }
        if (!this.m_trackingLayerDrawingListeners.contains(trackingLayerDrawingListener)) {
            this.m_trackingLayerDrawingListeners.add(trackingLayerDrawingListener);
        }
    }

    public synchronized void removeTrackingLayerDrawingListener(TrackingLayerDrawingListener trackingLayerDrawingListener) {
        if (this.m_trackingLayerDrawingListeners != null && this.m_trackingLayerDrawingListeners.contains(trackingLayerDrawingListener)) {
            this.m_trackingLayerDrawingListeners.remove(trackingLayerDrawingListener);
        }
    }

    protected void fireTrackingLayerDrawing(TrackingLayerDrawingEvent trackingLayerDrawingEvent) {
        if (this.m_trackingLayerDrawingListeners != null) {
            Vector vector = this.m_trackingLayerDrawingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackingLayerDrawingListener)vector.elementAt(i)).trackingLayerDrawing(trackingLayerDrawingEvent);
            }
        }
    }

    static void trackingLayerDrawingCallBack(Map map, long l) {
        if (map != null) {
            Boolean bl = InternalToolkitMapping.getHandleBooleanValue(l);
            TrackingLayerDrawingEvent trackingLayerDrawingEvent = new TrackingLayerDrawingEvent((Object)map, map.getTrackingLayer(), new ArrayList<Geometry>(), bl);
            map.fireTrackingLayerDrawing(trackingLayerDrawingEvent);
            InternalToolkitMapping.setHandleBooleanValue(l, trackingLayerDrawingEvent.getCancel());
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    public synchronized void addTrackingLayerDrawnListener(TrackingLayerDrawnListener trackingLayerDrawnListener) {
        if (this.m_trackingLayerDrawnListeners == null) {
            this.m_trackingLayerDrawnListeners = new Vector();
        }
        if (!this.m_trackingLayerDrawnListeners.contains(trackingLayerDrawnListener)) {
            this.m_trackingLayerDrawnListeners.add(trackingLayerDrawnListener);
        }
    }

    public synchronized void removeTrackingLayerDrawnListener(TrackingLayerDrawnListener trackingLayerDrawnListener) {
        if (this.m_trackingLayerDrawnListeners != null && this.m_trackingLayerDrawnListeners.contains(trackingLayerDrawnListener)) {
            this.m_trackingLayerDrawnListeners.remove(trackingLayerDrawnListener);
        }
    }

    protected void fireTrackingLayerDrawn(TrackingLayerDrawnEvent trackingLayerDrawnEvent) {
        if (this.m_trackingLayerDrawnListeners != null) {
            Vector vector = this.m_trackingLayerDrawnListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackingLayerDrawnListener)vector.elementAt(i)).trackingLayerDrawn(trackingLayerDrawnEvent);
            }
        }
    }

    public synchronized void addMapOpenedListener(MapOpenedListener mapOpenedListener) {
        if (this.m_mapOpenedListeners == null) {
            this.m_mapOpenedListeners = new Vector();
        }
        if (!this.m_mapOpenedListeners.contains(mapOpenedListener)) {
            this.m_mapOpenedListeners.add(mapOpenedListener);
        }
    }

    public synchronized void removeMapOpenedListener(MapOpenedListener mapOpenedListener) {
        if (this.m_mapOpenedListeners != null && this.m_mapOpenedListeners.contains(mapOpenedListener)) {
            this.m_mapOpenedListeners.remove(mapOpenedListener);
        }
    }

    protected void fireMapOpened(MapOpenedEvent mapOpenedEvent) {
        if (this.m_mapOpenedListeners != null) {
            Vector vector = this.m_mapOpenedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapOpenedListener)vector.elementAt(i)).mapOpened(mapOpenedEvent);
            }
        }
    }

    public synchronized void addMapClosedListener(MapClosedListener mapClosedListener) {
        if (this.m_mapClosedListeners == null) {
            this.m_mapClosedListeners = new Vector();
        }
        if (!this.m_mapClosedListeners.contains(mapClosedListener)) {
            this.m_mapClosedListeners.add(mapClosedListener);
        }
    }

    public synchronized void removeMapClosedListener(MapClosedListener mapClosedListener) {
        if (this.m_mapClosedListeners != null && this.m_mapClosedListeners.contains(mapClosedListener)) {
            this.m_mapClosedListeners.remove(mapClosedListener);
        }
    }

    protected void fireMapClosed(MapClosedEvent mapClosedEvent) {
        if (this.m_mapClosedListeners != null) {
            Vector vector = this.m_mapClosedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MapClosedListener)vector.elementAt(i)).mapClosed(mapClosedEvent);
            }
        }
    }

    static void trackingLayerDrawnCallBack(Map map) {
        if (map != null) {
            TrackingLayerDrawnEvent trackingLayerDrawnEvent = new TrackingLayerDrawnEvent((Object)map, map.getTrackingLayer());
            map.fireTrackingLayerDrawn(trackingLayerDrawnEvent);
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)map));
        }
    }

    static void refreshCallBack(Map map) {
        if (map != null && map._$9 != null) {
            map.refresh();
        }
    }

    MapControl getMapControl() {
        return this._$9;
    }

    protected static boolean getCanRefreshTrackingLayer(Map map) {
        return map.getCanRefreshTrackingLayer();
    }

    protected boolean getCanRefreshTrackingLayer() {
        return this._$5;
    }

    protected static void setCanRefreshTrackingLayer(Map map, boolean bl) {
        if (map != null) {
            map.setCanRefreshTrackingLayer(bl);
        }
    }

    protected void setCanRefreshTrackingLayer(boolean bl) {
        this._$5 = bl;
    }

    public boolean isFillMarkerAngleFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMarkerAngleFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsFillMarkerAngleFixed(this.getHandle());
    }

    public void setFillMarkerAngleFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMarkerAngleFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetFillMarkerAngleFixed(this.getHandle(), bl);
    }

    public boolean isSymbolFillIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSymbolFillIgnored()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsSymbolFillIgnored(this.getHandle());
    }

    public void setSymbolFillIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolFillIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetSymbolFillIgnored(this.getHandle(), bl);
    }

    public ChartSetting getChartSetting() {
        if (InternalToolkitMapping.getChartLicenseState() == -1) {
            return null;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null) {
            long l = 0L;
            l = MapNative.jni_GetChartSettingHandle(this.getHandle());
            if (l == 0L) {
                String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string);
            }
            this._$3 = new ChartSetting(l);
        }
        return this._$3;
    }

    public boolean isContainLayerChart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_isContainLayerChart(this.getHandle());
    }

    protected boolean IsCanOutputChartPicture() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getChartSetting()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return InternalToolkitMapping.getChartLicenseState() == 0 || !MapNative.jni_isContainLayerChart(this.getHandle());
    }

    public boolean isUseSystemDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isUseSystemDPI()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsUseSystemDPI(this.getHandle());
    }

    public void setUseSystemDPI(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUseSystemDPI(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetUseSystemDPI(this.getHandle(), bl);
    }

    public double getDPI() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDPI()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_GetMapDPI(this.getHandle());
    }

    public void setDPI(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 60.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        MapNative.jni_SetMapDPI(this.getHandle(), d);
    }

    public boolean isCompatibleFontHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapNative.jni_IsCompatibleFontHeight(this.getHandle());
    }

    public void setCompatibleFontHeight(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDPI(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        MapNative.jni_SetCompatibleFontHeight(this.getHandle(), bl);
    }

    static {
        InternalToolkitMapping.CheckChartLicenseState();
    }
}

