/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetGridInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Toolkit;

public class DatasetGridInfo
extends InternalHandleDisposable {
    private boolean _$3 = false;

    public DatasetGridInfo() {
        this.setHandle(DatasetGridInfoNative.jni_New(), true);
        this.reset();
    }

    public DatasetGridInfo(DatasetGridInfo datasetGridInfo) {
        if (datasetGridInfo == null) {
            String string = InternalResource.loadString("datasetGridInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetGridInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetGridInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetGridInfoNative.jni_Clone(datasetGridInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetGridInfo);
    }

    public DatasetGridInfo(String string, int n, int n2, PixelFormat pixelFormat, EncodeType encodeType) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (pixelFormat == null) {
            String string3 = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string3);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string4 = InternalResource.loadString("pixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (encodeType == null) {
            String string5 = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        this.setHandle(DatasetGridInfoNative.jni_New(), true);
        this.reset();
        this.setName(string);
        this.setWidth(n);
        this.setHeight(n2);
        this.setPixelFormat(pixelFormat);
        this.setEncodeType(encodeType);
    }

    public DatasetGridInfo(String string, int n, int n2, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption blockSizeOption) {
        if (string == null || string.trim().length() == 0) {
            String string2 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (pixelFormat == null) {
            String string3 = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string3);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string4 = InternalResource.loadString("pixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        if (encodeType == null) {
            String string5 = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string5);
        }
        this.setHandle(DatasetGridInfoNative.jni_New(), true);
        this.reset();
        this.setName(string);
        this.setWidth(n);
        this.setHeight(n2);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(blockSizeOption);
        this.setEncodeType(encodeType);
    }

    public DatasetGridInfo(String string, DatasetGrid datasetGrid) {
        if (datasetGrid == null) {
            String string2 = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string2);
        }
        long l = datasetGrid.getHandle();
        if (l == 0L) {
            String string3 = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        long l2 = DatasetGridInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(string);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        InternalInvalidState internalInvalidState = Dataset.isValidDatasetName(string);
        if (internalInvalidState != null) {
            String string4 = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string4 = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string4 = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string4 = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string4 = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string4 = "Dataset_NameErrorPrefix";
            }
            String string5 = InternalResource.loadString("value", string4, "data_resources");
            throw new IllegalArgumentException(string5);
        }
        DatasetGridInfoNative.jni_SetName(this.getHandle(), string);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetGridInfoNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetGridInfoNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridInfoNative.jni_SetWidth(this.getHandle(), n);
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridInfoNative.jni_SetHeight(this.getHandle(), n);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string = InternalResource.loadString("value", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridInfoNative.jni_SetPixelFormat(this.getHandle(), pixelFormat.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption blockSizeOption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridInfoNative.jni_SetBlockSize(this.getHandle(), blockSizeOption.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetGridInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!Toolkit.isValidEncodeType(false, encodeType)) {
            String string = InternalResource.loadString("encodeType", "Global_UnsupportedEncodeType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGridInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public double getNoValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetNoValue(this.getHandle());
    }

    public void setNoValue(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridInfoNative.jni_SetNoValue(this.getHandle(), d);
    }

    public double getMinValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetMinValue(this.getHandle());
    }

    public void setMinValue(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridInfoNative.jni_SetMinValue(this.getHandle(), d);
    }

    public double getMaxValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGridInfoNative.jni_GetMaxValue(this.getHandle());
    }

    public void setMaxValue(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGridInfoNative.jni_SetMaxValue(this.getHandle(), d);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",Bounds = {");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},Width = ");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(",Height = ");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append(",NoValue = ");
        stringBuffer.append(this.getNoValue());
        stringBuffer.append(",MinValue = ");
        stringBuffer.append(this.getMinValue());
        stringBuffer.append(",MaxValue = ");
        stringBuffer.append(this.getMaxValue());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetGridInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            DatasetGridInfoNative.jni_Reset(this.getHandle());
        }
    }
}

