/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingKMZNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingKMZ
extends ImportSetting {
    public ImportSettingKMZ() {
        long l = ImportSettingKMZNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingKMZ(ImportSettingKMZ importSettingKMZ) {
        if (importSettingKMZ == null) {
            String string = InternalResource.loadString("ImportSettingKMZ", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = importSettingKMZ.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingKMZ", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingKMZNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingKMZ.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingKMZ.getTargetDatasource());
        this.setUnvisibleObjectIgnored(importSettingKMZ.isUnvisibleObjectIgnored());
        this.setImportingAsCAD(importSettingKMZ.isImportingAsCAD());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingKMZ));
    }

    public ImportSettingKMZ(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingKMZ(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingKMZ(String string, DatasourceConnectionInfo datasourceConnectionInfo, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMZNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMZNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }

    public boolean isUnvisibleObjectIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMZNative.jni_GetUnvisibleObjectIgnored(this.getHandle());
    }

    public void setUnvisibleObjectIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMZNative.jni_SetUnvisibleObjectIgnored(this.getHandle(), bl);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingKMZNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMZNative.jni_SetImportEmptyDT(this.getHandle(), bl);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMZNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

