/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettingsNative;
import com.supermap.data.Datasource;
import java.util.ArrayList;

class RelationSettings {
    private ArrayList<RelationSetting> _$1 = new ArrayList();

    public RelationSettings() {
    }

    public RelationSettings(RelationSettings relationSettings) {
        RelationSetting[] relationSettingArray = relationSettings.toArray();
        this.addRange(relationSettingArray);
    }

    public int getCount() {
        return this._$1.size();
    }

    public RelationSetting get(int n) {
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this._$1.get(n);
    }

    public void set(int n, RelationSetting relationSetting) {
        if (relationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this._$1.set(n, relationSetting);
    }

    public int add(RelationSetting relationSetting) {
        if (relationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$1.add(relationSetting);
        return this._$1.size();
    }

    public int addRange(RelationSetting[] relationSettingArray) {
        int n;
        if (relationSettingArray == null) {
            String string = InternalResource.loadString("transferRelationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        for (n = 0; n < relationSettingArray.length; ++n) {
            if (relationSettingArray[n] != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = InternalResource.loadString("transferRelationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < relationSettingArray.length; ++n) {
            this._$1.add(relationSettingArray[n]);
        }
        return relationSettingArray.length;
    }

    public boolean remove(int n) {
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this._$1.remove(n);
        return true;
    }

    public int removeRange(int n, int n2) {
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = n + n2;
        if (n3 < 0 || n3 >= this.getCount()) {
            String string = InternalResource.loadString("index+count", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n3 - 1; i >= n; ++i) {
            this._$1.remove(i);
        }
        return n2;
    }

    public void clear() {
        this._$1.clear();
    }

    public RelationSetting[] toArray() {
        int n = this._$1.size();
        RelationSetting[] relationSettingArray = new RelationSetting[n];
        for (int i = 0; i < relationSettingArray.length; ++i) {
            relationSettingArray[i] = new RelationSetting(this._$1.get(i));
        }
        return relationSettingArray;
    }

    long setRelationToUGC() {
        int n = this._$1.size();
        long l = RelationSettingsNative.jni_RelationNew();
        for (int i = 0; i < n; ++i) {
            this._$1.get(i).setRelationToUGC(l);
        }
        return l;
    }

    long setStopExitToUGC() {
        int n = this._$1.size();
        long l = RelationSettingsNative.jni_StopAndExitNew();
        for (int i = 0; i < n; ++i) {
            this._$1.get(i).setStopExitToUGC(l);
        }
        return l;
    }

    long setNetworkToUGC() {
        int n = this._$1.size();
        long l = RelationSettingsNative.jni_NetworkNew();
        for (int i = 0; i < n; ++i) {
            this._$1.get(i).setNetworkToUGC(l);
        }
        return l;
    }

    void getRelationFromUGC(Datasource datasource, long l) {
        long[] lArray = RelationSettingsNative.jni_GetRelationHandls(l);
        this._$1 = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getRelationFromUGC(datasource, lArray[i]);
            this._$1.add(relationSetting);
        }
    }

    void getStopExitFromUGC(Datasource datasource, long l) {
        long[] lArray = RelationSettingsNative.jni_GetStopAndExitHandls(l);
        this._$1 = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getStopExitFromUGC(datasource, lArray[i]);
            this._$1.add(relationSetting);
        }
    }

    void getNetworkFromUGC(Datasource datasource, long l) {
        long[] lArray = RelationSettingsNative.jni_GetNetworkHandls(l);
        this._$1 = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getNetworkFromUGC(datasource, lArray[i]);
            this._$1.add(relationSetting);
        }
    }
}

