/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.local.LocalClientHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;

public class ClapClientHelper
extends LocalClientHelper {
    public ClapClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.CLAP);
    }

    public void handle(Request request, Response response) {
        ClassLoader classLoader;
        String scheme = request.getResourceRef().getScheme();
        request.getResourceRef().normalize();
        if (scheme.equalsIgnoreCase(Protocol.CLAP.getSchemeName())) {
            LocalReference cr = new LocalReference(request.getResourceRef());
            classLoader = null;
            if (cr.getClapAuthorityType() == 1) {
                Object classLoaderAttribute = request.getAttributes().get("org.restlet.clap.classloader");
                classLoader = classLoaderAttribute != null ? (ClassLoader)classLoaderAttribute : ((Object)((Object)this)).getClass().getClassLoader();
            } else if (cr.getClapAuthorityType() == 2) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else if (cr.getClapAuthorityType() == 3) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
        } else {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only CLAP is supported.");
        }
        this.handleClassLoader(request, response, classLoader);
    }

    protected void handleClassLoader(Request request, Response response, ClassLoader classLoader) {
        MetadataService metadataService = this.getMetadataService(request);
        if (request.getMethod().equals((Object)Method.GET) || request.getMethod().equals((Object)Method.HEAD)) {
            String path = request.getResourceRef().getPath();
            URL url = null;
            Date modificationDate = null;
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if (classLoader != null) {
                url = classLoader.getResource(Reference.decode((String)path));
            } else {
                this.getLogger().warning("Unable to get the resource. The selected classloader is null.");
            }
            if (url != null && url.getProtocol().equals("file")) {
                File file = new File(url.getFile());
                modificationDate = new Date(file.lastModified());
                if (file.isDirectory()) {
                    url = null;
                }
            }
            if (url != null) {
                try {
                    InputRepresentation output = new InputRepresentation(url.openStream(), metadataService.getDefaultMediaType());
                    output.setIdentifier(request.getResourceRef());
                    output.setModificationDate(modificationDate);
                    long timeToLive = this.getTimeToLive();
                    if (timeToLive == 0L) {
                        output.setExpirationDate(new Date());
                    } else if (timeToLive > 0L) {
                        output.setExpirationDate(new Date(System.currentTimeMillis() + 1000L * timeToLive));
                    }
                    String name = path.substring(path.lastIndexOf(47) + 1);
                    this.updateMetadata(metadataService, name, (Variant)output);
                    response.setEntity((Representation)output);
                    response.setStatus(Status.SUCCESS_OK);
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to open the representation's input stream", ioe);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }
}

