/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.util.LittleEndian;

public class PwdUtils {
    static byte[] seeds = new byte[]{-69, -1, -1, -70, -1, -1, -71, -128, 0, -66, 15, 0, -65, 15, 0};

    public static void encrypt(byte[] data, FilePassRecord fpr) {
        byte[] keyseq = PwdUtils.getKeySequence(fpr.getPassword().getBytes(), fpr.getKey());
        int i = 0;
        while (i < data.length) {
            short id = LittleEndian.getShort(data, i + 0);
            short size = LittleEndian.getShort(data, i + 2);
            if (id == 133) {
                PwdUtils.writeRecord(i + 4, data, 4, size, keyseq);
            } else if (id != 2057 && id != 47 && id != 225) {
                PwdUtils.writeRecord(i + 4, data, 0, size, keyseq);
            }
            i += 4 + size;
        }
    }

    public static short getEncryptionKey(byte[] pwd) {
        int key = 0;
        int key_base = 32768;
        int key_final = 65535;
        int index = 0;
        while (index < pwd.length) {
            byte chr = (byte)(pwd[pwd.length - 1 - index] & 0x7F);
            int bit_index = 0;
            while (bit_index < 8) {
                if (((key_base = key_base << 1 & 0xFFFF | key_base >> 15) & 1) == 1) {
                    key_base = (key_base ^ 0x1020) & 0xFFFF;
                }
                if (((key_final = key_final << 1 & 0xFFFF | key_final >> 15) & 1) == 1) {
                    key_final = (key_final ^ 0x1020) & 0xFFFF;
                }
                if ((chr & 1) == 1) {
                    key = (key ^ key_base) & 0xFFFF;
                }
                chr = (byte)(chr >> 1);
                ++bit_index;
            }
            ++index;
        }
        key = (key ^ key_final) & 0xFFFF;
        return (short)(key & 0xFFFF);
    }

    public static byte[] getKeySequence(byte[] pwd, short key) {
        byte[] keyseq = new byte[16];
        int count = pwd.length;
        System.arraycopy(pwd, 0, keyseq, 0, count);
        System.arraycopy(seeds, 0, keyseq, count, 16 - count);
        byte lower = (byte)(key & 0xFF);
        byte high = (byte)(key >> 8 & 0xFF);
        int i = 0;
        while (i < 16) {
            int n = i;
            keyseq[n] = (byte)(keyseq[n] ^ lower);
            int n2 = i + 1;
            keyseq[n2] = (byte)(keyseq[n2] ^ high);
            i += 2;
        }
        int i2 = 0;
        while (i2 < 16) {
            keyseq[i2] = (byte)(keyseq[i2] << 2 | keyseq[i2] >> 6 & 3);
            ++i2;
        }
        return keyseq;
    }

    public static short getPasswordHash(byte[] pwd) {
        short hash = 0;
        int i = 0;
        while (i < pwd.length) {
            int x = pwd[i] << i + 1;
            hash = (short)(hash ^ (short)(x & Short.MAX_VALUE | x >> 15));
            ++i;
        }
        hash = (short)(hash ^ (short)pwd.length);
        hash = (short)(hash ^ 0xFFFFCE4B);
        return hash;
    }

    public static void readRecord(int stream, byte[] recordData, int k, int recordSize, byte[] keyseq) {
        int index = stream + k + recordSize & 0xF;
        int i = 0;
        while (i < recordSize - k) {
            byte b = recordData[i + stream + k];
            b = (byte)(b << 3 | b >> 5 & 7);
            recordData[i + stream + k] = (byte)(b ^ keyseq[index]);
            index = index + 1 & 0xF;
            ++i;
        }
    }

    public static void writeRecord(int stream, byte[] recordData, int k, int recordSize, byte[] keyseq) {
        int index = stream + k + recordSize & 0xF;
        int i = 0;
        while (i < recordSize - k) {
            byte b = (byte)(recordData[i + stream + k] ^ keyseq[index]);
            recordData[i + stream + k] = b = (byte)(b >> 3 & 0x1F | b << 5);
            index = index + 1 & 0xF;
            ++i;
        }
    }
}

