/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    private HexDump() {
    }

    public static void dump(InputStream in, PrintStream out, int start, int bytesToDump) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (bytesToDump == -1) {
            int c = in.read();
            while (c != -1) {
                buf.write(c);
                c = in.read();
            }
        } else {
            int bytesRemaining = bytesToDump;
            while (bytesRemaining-- > 0) {
                int c = in.read();
                if (c != -1) {
                    buf.write(c);
                    continue;
                }
                break;
            }
        }
        byte[] data = buf.toByteArray();
        HexDump.dump(data, 0L, out, start, data.length);
    }

    private static String dump(byte value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        int j = 0;
        while (j < 2) {
            buf.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    private static String dump(long value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        int j = 0;
        while (j < 8) {
            buf.append(_hexcodes[(int)(value >> _shifts[j]) & 0xF]);
            ++j;
        }
        return buf.toString();
    }

    public static String dump(byte[] data, long offset, int index) {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int j = index;
        while (j < data.length) {
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            int k2 = 0;
            while (k2 < chars_read) {
                if (data[k2 + j] >= 32 && data[k2 + j] < 127) {
                    buffer.append((char)data[k2 + j]);
                } else {
                    buffer.append('.');
                }
                ++k2;
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
            j += 16;
        }
        return buffer.toString();
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(data, offset, stream, index, data.length - index);
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index, int length) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (index < 0 || data.length != 0 && index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + " into array of length " + data.length);
        }
        if (data.length == 0) {
            return;
        }
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        int data_length = Math.min(data.length, index + length);
        int j = index;
        while (j < data_length) {
            int chars_read = data_length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(HexDump.dump(display_offset)).append(' ');
            int k = 0;
            while (k < 16) {
                if (k < chars_read) {
                    buffer.append(HexDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
                ++k;
            }
            int k2 = 0;
            while (k2 < chars_read) {
                if (data[k2 + j] >= 32 && data[k2 + j] < 127) {
                    buffer.append((char)data[k2 + j]);
                } else {
                    buffer.append('.');
                }
                ++k2;
            }
            buffer.append(EOL);
            stream.write(buffer.toString().getBytes());
            stream.flush();
            buffer.setLength(0);
            display_offset += (long)chars_read;
            j += 16;
        }
    }

    private static String toHex(long value, int digits) {
        StringBuffer result = new StringBuffer(digits);
        int j = 0;
        while (j < digits) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (8 - digits)] & 0xFL)]);
            ++j;
        }
        return result.toString();
    }

    public static String toHex(int value) {
        return HexDump.toHex(value, 8);
    }

    public static String toHex(byte value) {
        return HexDump.toHex(value, 2);
    }

    public static String toHex(short value) {
        return HexDump.toHex(value, 4);
    }

    public static String toHex(byte[] value) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('[');
        int x = 0;
        while (x < value.length) {
            retVal.append(HexDump.toHex(value[x]));
            retVal.append(", ");
            ++x;
        }
        retVal.append(']');
        return retVal.toString();
    }
}

