/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.ListManagedBlock;

public class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private static final int _block_size = 64;
    private static final int _blocks_per_big_block = 8;
    private byte[] _data = new byte[64];
    private static final byte _default_fill = -1;

    private SmallDocumentBlock() {
    }

    private SmallDocumentBlock(byte[] data, int index) {
        this();
        System.arraycopy(data, index * 64, this._data, 0, 64);
    }

    public static int calcSize(int size) {
        return size * 64;
    }

    public static SmallDocumentBlock[] convert(BlockWritable[] store, int size) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int j = 0;
        while (j < store.length) {
            store[j].writeBlocks(stream);
            ++j;
        }
        byte[] data = stream.toByteArray();
        SmallDocumentBlock[] rval = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(size)];
        int index = 0;
        while (index < rval.length) {
            rval[index] = new SmallDocumentBlock(data, index);
            ++index;
        }
        return rval;
    }

    public static SmallDocumentBlock[] convert(byte[] array, int size) {
        SmallDocumentBlock[] rval = new SmallDocumentBlock[(size + 64 - 1) / 64];
        int offset = 0;
        int k = 0;
        while (k < rval.length) {
            rval[k] = new SmallDocumentBlock();
            if (offset < array.length) {
                int length = Math.min(64, array.length - offset);
                System.arraycopy(array, offset, rval[k]._data, 0, length);
                if (length != 64) {
                    Arrays.fill(rval[k]._data, length, 64, (byte)-1);
                }
            } else {
                Arrays.fill(rval[k]._data, (byte)-1);
            }
            offset += 64;
            ++k;
        }
        return rval;
    }

    private static int convertToBlockCount(int size) {
        return (size + 64 - 1) / 64;
    }

    public static List extract(ListManagedBlock[] blocks) throws IOException {
        ArrayList<SmallDocumentBlock> sdbs = new ArrayList<SmallDocumentBlock>();
        int j = 0;
        while (j < blocks.length) {
            byte[] data = blocks[j].getData();
            int k = 0;
            while (k < 8) {
                sdbs.add(new SmallDocumentBlock(data, k));
                ++k;
            }
            ++j;
        }
        return sdbs;
    }

    public static int fill(List blocks) {
        int count = blocks.size();
        int big_block_count = (count + 8 - 1) / 8;
        int full_count = big_block_count * 8;
        while (count < full_count) {
            blocks.add(SmallDocumentBlock.makeEmptySmallDocumentBlock());
            ++count;
        }
        return big_block_count;
    }

    public byte[] getData() throws IOException {
        return this._data;
    }

    private static SmallDocumentBlock makeEmptySmallDocumentBlock() {
        SmallDocumentBlock block = new SmallDocumentBlock();
        Arrays.fill(block._data, (byte)-1);
        return block;
    }

    public static void read(BlockWritable[] blocks, byte[] buffer, int offset) {
        int firstBlockIndex = offset / 64;
        int firstBlockOffset = offset % 64;
        int lastBlockIndex = (offset + buffer.length - 1) / 64;
        if (firstBlockIndex == lastBlockIndex) {
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, 0, buffer.length);
        } else {
            int buffer_offset = 0;
            System.arraycopy(((SmallDocumentBlock)blocks[firstBlockIndex])._data, firstBlockOffset, buffer, buffer_offset, 64 - firstBlockOffset);
            buffer_offset += 64 - firstBlockOffset;
            int j = firstBlockIndex + 1;
            while (j < lastBlockIndex) {
                System.arraycopy(((SmallDocumentBlock)blocks[j])._data, 0, buffer, buffer_offset, 64);
                buffer_offset += 64;
                ++j;
            }
            System.arraycopy(((SmallDocumentBlock)blocks[lastBlockIndex])._data, 0, buffer, buffer_offset, buffer.length - buffer_offset);
        }
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        stream.write(this._data);
    }
}

