/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.HeaderBlockConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.IntegerField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LongField;

public class HeaderBlockReader
implements HeaderBlockConstants {
    private IntegerField _bat_count;
    private byte[] _data = new byte[512];
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _xbat_count;
    private IntegerField _xbat_start;

    public HeaderBlockReader(InputStream stream) throws IOException {
        int byte_count = IOUtils.readFully(stream, this._data);
        if (byte_count != 512) {
            String type = " byte" + (byte_count == 1 ? "" : "s");
            throw new IOException("Unable to read entire header; " + byte_count + type + " read; expected " + 512 + " bytes");
        }
        LongField signature = new LongField(0, this._data);
        if (signature.get() != -2226271756974174256L) {
            throw new IOException("Invalid header signature; read " + signature.get() + ", expected " + -2226271756974174256L);
        }
        this._bat_count = new IntegerField(44, this._data);
        this._property_start = new IntegerField(48, this._data);
        this._sbat_start = new IntegerField(60, this._data);
        this._xbat_start = new IntegerField(68, this._data);
        this._xbat_count = new IntegerField(72, this._data);
    }

    public int[] getBATArray() {
        int[] result = new int[109];
        int offset = 76;
        int j = 0;
        while (j < 109) {
            result[j] = LittleEndian.getInt(this._data, offset);
            offset += 4;
            ++j;
        }
        return result;
    }

    public int getBATCount() {
        return this._bat_count.get();
    }

    public int getPropertyStart() {
        return this._property_start.get();
    }

    public int getSBATStart() {
        return this._sbat_start.get();
    }

    public int getXBATCount() {
        return this._xbat_count.get();
    }

    public int getXBATIndex() {
        return this._xbat_start.get();
    }
}

