/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.util.IntegerField;

public class BATBlock
extends BigBlock {
    private byte[] _data = new byte[512];
    private static final byte _default_value = -1;
    private static final int _entries_per_block = 128;
    private static final int _entries_per_xbat_block = 127;
    private IntegerField[] _fields;
    private static final int _xbat_chain_offset = 508;

    private BATBlock(int[] entries, int start_index, int end_index) {
        this();
        int k = start_index;
        while (k < end_index) {
            this._fields[k - start_index].set(entries[k], this._data);
            ++k;
        }
    }

    private BATBlock() {
        Arrays.fill(this._data, (byte)-1);
        this._fields = new IntegerField[128];
        int offset = 0;
        int j = 0;
        while (j < 128) {
            this._fields[j] = new IntegerField(offset);
            offset += 4;
            ++j;
        }
    }

    public static int calculateStorageRequirements(int entryCount) {
        return (entryCount + 128 - 1) / 128;
    }

    public static int calculateXBATStorageRequirements(int entryCount) {
        return (entryCount + 127 - 1) / 127;
    }

    public static BATBlock[] createBATBlocks(int[] entries) {
        int block_count = BATBlock.calculateStorageRequirements(entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int j = 0;
        while (j < entries.length) {
            blocks[index++] = new BATBlock(entries, j, remaining > 128 ? j + 128 : entries.length);
            remaining -= 128;
            j += 128;
        }
        return blocks;
    }

    public static BATBlock[] createXBATBlocks(int[] entries, int startBlock) {
        int block_count = BATBlock.calculateXBATStorageRequirements(entries.length);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        if (block_count != 0) {
            int j = 0;
            while (j < entries.length) {
                blocks[index++] = new BATBlock(entries, j, remaining > 127 ? j + 127 : entries.length);
                remaining -= 127;
                j += 127;
            }
            index = 0;
            while (index < blocks.length - 1) {
                blocks[index].setXBATChain(startBlock + index + 1);
                ++index;
            }
            blocks[index].setXBATChain(-2);
        }
        return blocks;
    }

    public static final int entriesPerBlock() {
        return 128;
    }

    public static final int entriesPerXBATBlock() {
        return 127;
    }

    public static final int getXBATChainOffset() {
        return 508;
    }

    private void setXBATChain(int chainIndex) {
        this._fields[127].set(chainIndex, this._data);
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

