/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyFactory;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.PropertyBlock;
import org.apache.poi.poifs.storage.RawDataBlockList;

public class PropertyTable
implements BATManaged,
BlockWritable {
    private BlockWritable[] _blocks;
    private List _properties;
    private int _start_block = -2;

    public PropertyTable(int startBlock, RawDataBlockList blockList) throws IOException {
        this._blocks = null;
        this._properties = PropertyFactory.convertToProperties(blockList.fetchBlocks(startBlock));
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public PropertyTable() {
        this._properties = new ArrayList();
        this.addProperty(new RootProperty());
        this._blocks = null;
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public int countBlocks() {
        return this._blocks == null ? 0 : this._blocks.length;
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    public int getStartBlock() {
        return this._start_block;
    }

    private void populatePropertyTree(DirectoryProperty root) throws IOException {
        int index = root.getChildIndex();
        if (!Property.isValidIndex(index)) {
            return;
        }
        Stack children = new Stack();
        children.push(this._properties.get(index));
        while (!children.empty()) {
            Property property = (Property)children.pop();
            root.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(index = property.getPreviousChildIndex())) {
                children.push(this._properties.get(index));
            }
            if (!Property.isValidIndex(index = property.getNextChildIndex())) continue;
            children.push(this._properties.get(index));
        }
    }

    public void preWrite() {
        Property[] properties = this._properties.toArray(new Property[0]);
        int k = 0;
        while (k < properties.length) {
            properties[k].setIndex(k);
            ++k;
        }
        this._blocks = PropertyBlock.createPropertyBlockArray(this._properties);
        int k2 = 0;
        while (k2 < properties.length) {
            properties[k2].preWrite();
            ++k2;
        }
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public void setStartBlock(int index) {
        this._start_block = index;
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        if (this._blocks != null) {
            int j = 0;
            while (j < this._blocks.length) {
                this._blocks[j].writeBlocks(stream);
                ++j;
            }
        }
    }
}

