/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.poifs.property.Parent;
import org.apache.poi.poifs.property.Property;

public class DirectoryProperty
extends Property
implements Parent {
    private List _children = new ArrayList();
    private Set _children_names = new HashSet();

    protected DirectoryProperty(int index, byte[] array, int offset) {
        super(index, array, offset);
    }

    public DirectoryProperty(String name) {
        this.setName(name);
        this.setSize(0);
        this.setPropertyType((byte)1);
        this.setStartBlock(0);
        this.setNodeColor((byte)1);
    }

    public void addChild(Property property) throws IOException {
        String name = property.getName();
        if (this._children_names.contains(name)) {
            throw new IOException("Duplicate name \"" + name + "\"");
        }
        this._children_names.add(name);
        this._children.add(property);
    }

    public boolean changeName(Property property, String newName) {
        boolean result;
        String oldName = property.getName();
        property.setName(newName);
        String cleanNewName = property.getName();
        if (this._children_names.contains(cleanNewName)) {
            property.setName(oldName);
            result = false;
        } else {
            this._children_names.add(cleanNewName);
            this._children_names.remove(oldName);
            result = true;
        }
        return result;
    }

    public boolean deleteChild(Property property) {
        boolean result = this._children.remove(property);
        if (result) {
            this._children_names.remove(property.getName());
        }
        return result;
    }

    public Iterator getChildren() {
        return this._children.iterator();
    }

    public boolean isDirectory() {
        return true;
    }

    protected void preWrite() {
        if (this._children.size() > 0) {
            Property[] children = this._children.toArray(new Property[0]);
            Arrays.sort(children, new PropertyComparator());
            int midpoint = children.length / 2;
            this.setChildProperty(children[midpoint].getIndex());
            children[0].setPreviousChild(null);
            children[0].setNextChild(null);
            int j = 1;
            while (j < midpoint) {
                children[j].setPreviousChild(children[j - 1]);
                children[j].setNextChild(null);
                ++j;
            }
            if (midpoint != 0) {
                children[midpoint].setPreviousChild(children[midpoint - 1]);
            }
            if (midpoint != children.length - 1) {
                children[midpoint].setNextChild(children[midpoint + 1]);
                int j2 = midpoint + 1;
                while (j2 < children.length - 1) {
                    children[j2].setPreviousChild(null);
                    children[j2].setNextChild(children[j2 + 1]);
                    ++j2;
                }
                children[children.length - 1].setPreviousChild(null);
                children[children.length - 1].setNextChild(null);
            } else {
                children[midpoint].setNextChild(null);
            }
        }
    }

    private class PropertyComparator
    implements Comparator {
        private PropertyComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ((Property)o1).getName();
            String name2 = ((Property)o2).getName();
            int result = name1.length() - name2.length();
            if (result == 0) {
                result = name1.compareTo(name2);
            }
            return result;
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

