/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.hssf.record.MergeCellsRecord;

public class Region
implements Comparable {
    private short colFrom;
    private short colTo;
    private int rowFrom;
    private int rowTo;

    public Region(MergeCellsRecord.MergedRegion region) {
        this(region.row_from, region.col_from, region.row_to, region.col_to);
    }

    public Region(int rowFrom, short colFrom, int rowTo, short colTo) {
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    public Region() {
    }

    public int compareTo(Object o) {
        return this.compareTo((Region)o);
    }

    public int compareTo(Region r) {
        if (this.getRowFrom() == r.getRowFrom() && this.getColumnFrom() == r.getColumnFrom() && this.getRowTo() == r.getRowTo() && this.getColumnTo() == r.getColumnTo()) {
            return 0;
        }
        if (this.getRowFrom() < r.getRowFrom() || this.getColumnFrom() < r.getColumnFrom() || this.getRowTo() < r.getRowTo() || this.getColumnTo() < r.getColumnTo()) {
            return 1;
        }
        return -1;
    }

    public boolean contains(int row, short col) {
        return this.rowFrom <= row && this.rowTo >= row && this.colFrom <= col && this.colTo >= col;
    }

    public boolean equals(Region r) {
        return this.compareTo(r) == 0;
    }

    public int getArea() {
        return (1 + (this.getRowTo() - this.getRowFrom())) * (1 + (this.getColumnTo() - this.getColumnFrom()));
    }

    public short getColumnFrom() {
        return this.colFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public int getRowFrom() {
        return this.rowFrom;
    }

    public int getRowTo() {
        return this.rowTo;
    }

    public void setColumnFrom(short colFrom) {
        this.colFrom = colFrom;
    }

    public void setColumnTo(short colTo) {
        this.colTo = colTo;
    }

    public void setRowFrom(int rowFrom) {
        this.rowFrom = rowFrom;
    }

    public void setRowTo(int rowTo) {
        this.rowTo = rowTo;
    }
}

