/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;

public abstract class HSSFShape {
    public static final int LINESTYLE_DASHDOTDOTSYS = 4;
    public static final int LINESTYLE_DASHDOTGEL = 8;
    public static final int LINESTYLE_DASHDOTSYS = 3;
    public static final int LINESTYLE_DASHGEL = 6;
    public static final int LINESTYLE_DASHSYS = 1;
    public static final int LINESTYLE_DOTGEL = 5;
    public static final int LINESTYLE_DOTSYS = 2;
    public static final int LINESTYLE_LONGDASHDOTDOTGEL = 10;
    public static final int LINESTYLE_LONGDASHDOTGEL = 9;
    public static final int LINESTYLE_LONGDASHGEL = 7;
    public static final int LINESTYLE_NONE = -1;
    public static final int LINESTYLE_SOLID = 0;
    public static final int LINEWIDTH_DEFAULT = 9525;
    public static final int LINEWIDTH_ONE_PT = 12700;
    HSSFAnchor anchor;
    int fillColor = 0x8000009;
    int lineStyle = 0;
    int lineStyleColor = 0x8000040;
    int lineWidth = 9525;
    boolean noFill = false;
    HSSFShape parent;

    HSSFShape(HSSFShape parent, HSSFAnchor anchor) {
        this.parent = parent;
        this.anchor = anchor;
    }

    public int countOfAllChildren() {
        return 1;
    }

    public HSSFAnchor getAnchor() {
        return this.anchor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineStyleColor() {
        return this.lineStyleColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public HSSFShape getParent() {
        return this.parent;
    }

    public boolean isNoFill() {
        return this.noFill;
    }

    public void setAnchor(HSSFAnchor anchor) {
        if (this.parent == null) {
            if (anchor instanceof HSSFChildAnchor) {
                throw new IllegalArgumentException("Must use client anchors for shapes directly attached to sheet.");
            }
        } else if (anchor instanceof HSSFClientAnchor) {
            throw new IllegalArgumentException("Must use child anchors for shapes attached to groups.");
        }
        this.anchor = anchor;
    }

    public void setFillColor(int red, int green, int blue) {
        this.fillColor = blue << 16 | green << 8 | red;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public void setLineStyleColor(int red, int green, int blue) {
        this.lineStyleColor = blue << 16 | green << 8 | red;
    }

    public void setLineStyleColor(int lineStyleColor) {
        this.lineStyleColor = lineStyleColor;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setNoFill(boolean noFill) {
        this.noFill = noFill;
    }
}

