/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.FooterRecord;

public class HSSFFooter {
    String center;
    FooterRecord footerRecord;
    String left;
    String right;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    protected HSSFFooter(FooterRecord footerRecord) {
        block14: {
            String foot;
            block13: {
                this.footerRecord = footerRecord;
                foot = footerRecord.getFooter();
                if (!true) break block13;
                if (foot == null) return;
                if (foot.length() <= 1) break block14;
            }
            do {
                int pos = foot.length();
                switch (foot.substring(1, 2).charAt(0)) {
                    case 'L': {
                        if (foot.indexOf("&C") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&C"));
                        }
                        if (foot.indexOf("&R") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&R"));
                        }
                        this.left = foot.substring(2, pos);
                        foot = foot.substring(pos);
                        break;
                    }
                    case 'C': {
                        if (foot.indexOf("&L") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&L"));
                        }
                        if (foot.indexOf("&R") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&R"));
                        }
                        this.center = foot.substring(2, pos);
                        foot = foot.substring(pos);
                        break;
                    }
                    case 'R': {
                        if (foot.indexOf("&C") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&C"));
                        }
                        if (foot.indexOf("&L") >= 0) {
                            pos = Math.min(pos, foot.indexOf("&L"));
                        }
                        this.right = foot.substring(2, pos);
                        foot = foot.substring(pos);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (foot == null) return;
            } while (foot.length() > 1);
        }
    }

    private void createFooterString() {
        this.footerRecord.setFooter("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.footerRecord.setFooterLength((byte)this.footerRecord.getFooter().length());
    }

    public static String date() {
        return "&D";
    }

    public static String file() {
        return "&F";
    }

    public static String font(String font, String style) {
        return "&\"" + font + "," + style + "\"";
    }

    public static String fontSize(short size) {
        return "&" + size;
    }

    public String getCenter() {
        return this.center;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public static String numPages() {
        return "&N";
    }

    public static String page() {
        return "&P";
    }

    public void setCenter(String newCenter) {
        this.center = newCenter;
        this.createFooterString();
    }

    public void setLeft(String newLeft) {
        this.left = newLeft;
        this.createFooterString();
    }

    public void setRight(String newRight) {
        this.right = newRight;
        this.createFooterString();
    }

    public static String tab() {
        return "&A";
    }

    public static String time() {
        return "&T";
    }
}

