/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.FontRecord;

public class HSSFFont {
    public static final short BOLDWEIGHT_BOLD = 700;
    public static final short BOLDWEIGHT_NORMAL = 400;
    public static final short COLOR_NORMAL = Short.MAX_VALUE;
    public static final short COLOR_RED = 10;
    public static final String FONT_ARIAL = "Arial";
    public static final short SS_NONE = 0;
    public static final short SS_SUB = 2;
    public static final short SS_SUPER = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    private FontRecord font;
    private short index;

    protected HSSFFont(short index, FontRecord rec) {
        this.font = rec;
        this.index = index;
    }

    public short getBoldweight() {
        return this.font.getBoldWeight();
    }

    public short getColor() {
        return this.font.getColorPaletteIndex();
    }

    public short getFontHeight() {
        return this.font.getFontHeight();
    }

    public short getFontHeightInPoints() {
        return (short)(this.font.getFontHeight() / 20);
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public short getIndex() {
        return this.index;
    }

    public boolean getItalic() {
        return this.font.isItalic();
    }

    public boolean getStrikeout() {
        return this.font.isStruckout();
    }

    public short getTypeOffset() {
        return this.font.getSuperSubScript();
    }

    public byte getUnderline() {
        return this.font.getUnderline();
    }

    public void setBoldweight(short boldweight) {
        this.font.setBoldWeight(boldweight);
    }

    public void setColor(short color) {
        this.font.setColorPaletteIndex(color);
    }

    public void setFontHeight(short height) {
        this.font.setFontHeight(height);
    }

    public void setFontHeightInPoints(short height) {
        this.font.setFontHeight((short)(height * 20));
    }

    public void setFontName(String name) {
        this.font.setFontName(name);
        this.font.setFontNameLength((byte)name.length());
    }

    public void setItalic(boolean italic) {
        this.font.setItalic(italic);
    }

    public void setStrikeout(boolean strikeout) {
        this.font.setStrikeout(strikeout);
    }

    public void setTypeOffset(short offset) {
        this.font.setSuperSubScript(offset);
    }

    public void setUnderline(byte underline) {
        this.font.setUnderline(underline);
    }

    public String toString() {
        return "org.apache.poi.hssf.usermodel.HSSFFont{" + this.font + "}";
    }
}

