/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.model.FormulaParser;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class HSSFCell {
    public static final int CELL_TYPE_BLANK = 3;
    public static final int CELL_TYPE_BOOLEAN = 4;
    public static final int CELL_TYPE_ERROR = 5;
    public static final int CELL_TYPE_FORMULA = 2;
    public static final int CELL_TYPE_NUMERIC = 0;
    public static final int CELL_TYPE_STRING = 1;
    public static final short ENCODING_COMPRESSED_UNICODE = 0;
    public static final short ENCODING_UTF_16 = 1;
    private Workbook book;
    private boolean booleanValue;
    private short cellNum;
    private HSSFCellStyle cellStyle;
    private int cellType;
    private double cellValue;
    private short encoding = 0;
    private byte errorValue;
    private CellValueRecordInterface record;
    private int row;
    private Sheet sheet;
    private String stringValue;

    private HSSFCell() {
    }

    protected HSSFCell(Workbook book, Sheet sheet, int row, CellValueRecordInterface cval) {
        this.cellNum = cval.getColumn();
        this.record = cval;
        this.row = row;
        this.cellType = this.determineType(cval);
        this.cellStyle = null;
        this.stringValue = null;
        this.book = book;
        this.sheet = sheet;
        switch (this.cellType) {
            case 0: {
                this.cellValue = ((NumberRecord)cval).getValue();
                break;
            }
            case 1: {
                this.stringValue = book.getSSTString(((LabelSSTRecord)cval).getSSTIndex());
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this.cellValue = ((FormulaRecordAggregate)cval).getFormulaRecord().getValue();
                this.stringValue = ((FormulaRecordAggregate)cval).getStringValue();
                break;
            }
            case 4: {
                this.booleanValue = ((BoolErrRecord)cval).getBooleanValue();
                break;
            }
            case 5: {
                this.errorValue = ((BoolErrRecord)cval).getErrorValue();
            }
        }
        ExtendedFormatRecord xf = book.getExFormatAt(cval.getXFIndex());
        this.setCellStyle(new HSSFCellStyle(cval.getXFIndex(), xf));
    }

    protected HSSFCell(Workbook book, Sheet sheet, int row, short col, int type) {
        this.checkBounds(col);
        this.cellNum = col;
        this.row = row;
        this.cellType = type;
        this.cellStyle = null;
        this.cellValue = 0.0;
        this.stringValue = null;
        this.booleanValue = false;
        this.errorValue = 0;
        this.book = book;
        this.sheet = sheet;
        switch (type) {
            case 0: {
                this.record = new NumberRecord();
                ((NumberRecord)this.record).setColumn(col);
                ((NumberRecord)this.record).setRow(row);
                ((NumberRecord)this.record).setValue(0.0);
                ((NumberRecord)this.record).setXFIndex((short)0);
                break;
            }
            case 1: {
                this.record = new LabelSSTRecord();
                ((LabelSSTRecord)this.record).setColumn(col);
                ((LabelSSTRecord)this.record).setRow(row);
                ((LabelSSTRecord)this.record).setXFIndex((short)0);
                break;
            }
            case 3: {
                this.record = new BlankRecord();
                ((BlankRecord)this.record).setColumn(col);
                ((BlankRecord)this.record).setRow(row);
                ((BlankRecord)this.record).setXFIndex((short)0);
                break;
            }
            case 2: {
                FormulaRecord formulaRecord = new FormulaRecord();
                this.record = new FormulaRecordAggregate(formulaRecord, null);
                formulaRecord.setColumn(col);
                formulaRecord.setRow(row);
                formulaRecord.setXFIndex((short)0);
            }
            case 4: {
                this.record = new BoolErrRecord();
                ((BoolErrRecord)this.record).setColumn(col);
                ((BoolErrRecord)this.record).setRow(row);
                ((BoolErrRecord)this.record).setXFIndex((short)0);
                ((BoolErrRecord)this.record).setValue(false);
                break;
            }
            case 5: {
                this.record = new BoolErrRecord();
                ((BoolErrRecord)this.record).setColumn(col);
                ((BoolErrRecord)this.record).setRow(row);
                ((BoolErrRecord)this.record).setXFIndex((short)0);
                ((BoolErrRecord)this.record).setValue((byte)0);
            }
        }
        ExtendedFormatRecord xf = book.getExFormatAt(15);
        this.setCellStyle(new HSSFCellStyle(15, xf));
    }

    protected HSSFCell(Workbook book, Sheet sheet, int row, short col) {
        this.checkBounds(col);
        this.cellNum = col;
        this.row = row;
        this.cellStyle = null;
        this.cellValue = 0.0;
        this.stringValue = null;
        this.booleanValue = false;
        this.errorValue = 0;
        this.book = book;
        this.sheet = sheet;
        this.setCellType(3, false);
        ExtendedFormatRecord xf = book.getExFormatAt(15);
        this.setCellStyle(new HSSFCellStyle(15, xf));
    }

    private void checkBounds(int cellNum) {
        if (cellNum > 255) {
            throw new RuntimeException("You cannot have more than 255 columns in a given row (IV).  Because Excel can't handle it");
        }
        if (cellNum < 0) {
            throw new RuntimeException("You cannot reference columns with an index of less then 0.");
        }
    }

    private int determineType(CellValueRecordInterface cval) {
        Record record = (Record)((Object)cval);
        short sid = record.getSid();
        int retval = 0;
        switch (sid) {
            case 515: {
                retval = 0;
                break;
            }
            case 513: {
                retval = 3;
                break;
            }
            case 253: {
                retval = 1;
                break;
            }
            case -2000: {
                retval = 2;
                break;
            }
            case 517: {
                BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                retval = boolErrRecord.isBoolean() ? 4 : 5;
            }
        }
        return retval;
    }

    public boolean getBooleanCellValue() {
        if (this.cellType == 4) {
            return this.booleanValue;
        }
        if (this.cellType == 3) {
            return false;
        }
        throw new NumberFormatException("You cannot get a boolean value from a non-boolean cell");
    }

    public String getCellFormula() {
        String retval = FormulaParser.toFormulaString(this.book, ((FormulaRecordAggregate)this.record).getFormulaRecord().getParsedExpression());
        return retval;
    }

    public short getCellNum() {
        return this.cellNum;
    }

    public HSSFCellStyle getCellStyle() {
        return this.cellStyle;
    }

    public int getCellType() {
        return this.cellType;
    }

    protected CellValueRecordInterface getCellValueRecord() {
        return this.record;
    }

    public Date getDateCellValue() {
        if (this.cellType == 3) {
            return null;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a date value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a date value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a date value from an error cell");
        }
        if (this.book.isUsing1904DateWindowing()) {
            return HSSFDateUtil.getJavaDate(this.cellValue, true);
        }
        return HSSFDateUtil.getJavaDate(this.cellValue, false);
    }

    public short getEncoding() {
        return this.encoding;
    }

    public byte getErrorCellValue() {
        if (this.cellType == 5) {
            return this.errorValue;
        }
        if (this.cellType == 3) {
            return 0;
        }
        throw new NumberFormatException("You cannot get an error value from a non-error cell");
    }

    public double getNumericCellValue() {
        if (this.cellType == 3) {
            return 0.0;
        }
        if (this.cellType == 1) {
            throw new NumberFormatException("You cannot get a numeric value from a String based cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a numeric value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a numeric value from an error cell");
        }
        return this.cellValue;
    }

    public String getStringCellValue() {
        if (this.cellType == 3) {
            return "";
        }
        if (this.cellType == 0) {
            throw new NumberFormatException("You cannot get a string value from a numeric cell");
        }
        if (this.cellType == 4) {
            throw new NumberFormatException("You cannot get a string value from a boolean cell");
        }
        if (this.cellType == 5) {
            throw new NumberFormatException("You cannot get a string value from an error cell");
        }
        if (this.cellType == 2 && this.stringValue == null) {
            return "";
        }
        return this.stringValue;
    }

    public void setAsActiveCell() {
        this.sheet.setActiveCellRow(this.row);
        this.sheet.setActiveCellCol(this.cellNum);
    }

    public void setCellErrorValue(byte value) {
        if (this.cellType != 5 && this.cellType != 2) {
            this.setCellType(5, false);
        }
        ((BoolErrRecord)this.record).setValue(value);
        this.errorValue = value;
    }

    public void setCellFormula(String formula) {
        if (formula == null) {
            this.setCellType(3, false);
        } else {
            this.setCellType(2, false);
            FormulaRecordAggregate rec = (FormulaRecordAggregate)this.record;
            rec.getFormulaRecord().setOptions((short)2);
            rec.getFormulaRecord().setValue(0.0);
            if (rec.getXFIndex() == 0) {
                rec.setXFIndex((short)15);
            }
            FormulaParser fp = new FormulaParser(formula + ";", this.book);
            fp.parse();
            Ptg[] ptg = fp.getRPNPtg();
            int size = 0;
            int k = 0;
            while (k < ptg.length) {
                size += ptg[k].getSize();
                rec.getFormulaRecord().pushExpressionToken(ptg[k]);
                ++k;
            }
            rec.getFormulaRecord().setExpressionLength((short)size);
        }
    }

    public void setCellNum(short num) {
        this.cellNum = num;
        this.record.setColumn(num);
    }

    public void setCellStyle(HSSFCellStyle style) {
        this.cellStyle = style;
        this.record.setXFIndex(style.getIndex());
    }

    private void setCellType(int cellType, boolean setValue) {
        if (cellType > 5) {
            throw new RuntimeException("I have no idea what type that is!");
        }
        switch (cellType) {
            case 2: {
                FormulaRecordAggregate frec = null;
                frec = cellType != this.cellType ? new FormulaRecordAggregate(new FormulaRecord(), null) : (FormulaRecordAggregate)this.record;
                frec.setColumn(this.getCellNum());
                if (setValue) {
                    frec.getFormulaRecord().setValue(this.getNumericCellValue());
                }
                frec.setXFIndex(this.cellStyle.getIndex());
                frec.setRow(this.row);
                this.record = frec;
                break;
            }
            case 0: {
                NumberRecord nrec = null;
                nrec = cellType != this.cellType ? new NumberRecord() : (NumberRecord)this.record;
                nrec.setColumn(this.getCellNum());
                if (setValue) {
                    nrec.setValue(this.getNumericCellValue());
                }
                nrec.setXFIndex(this.cellStyle.getIndex());
                nrec.setRow(this.row);
                this.record = nrec;
                break;
            }
            case 1: {
                LabelSSTRecord lrec = null;
                lrec = cellType != this.cellType ? new LabelSSTRecord() : (LabelSSTRecord)this.record;
                lrec.setColumn(this.getCellNum());
                lrec.setRow(this.row);
                lrec.setXFIndex(this.cellStyle.getIndex());
                if (setValue && this.getStringCellValue() != null && !this.getStringCellValue().equals("")) {
                    int sst = 0;
                    if (this.encoding == 0) {
                        sst = this.book.addSSTString(this.getStringCellValue());
                    }
                    if (this.encoding == 1) {
                        sst = this.book.addSSTString(this.getStringCellValue(), true);
                    }
                    lrec.setSSTIndex(sst);
                }
                this.record = lrec;
                break;
            }
            case 3: {
                BlankRecord brec = null;
                brec = cellType != this.cellType ? new BlankRecord() : (BlankRecord)this.record;
                brec.setColumn(this.getCellNum());
                if (this.cellStyle != null) {
                    brec.setXFIndex(this.cellStyle.getIndex());
                } else {
                    brec.setXFIndex((short)0);
                }
                brec.setRow(this.row);
                this.record = brec;
                break;
            }
            case 4: {
                BoolErrRecord boolRec = null;
                boolRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                boolRec.setColumn(this.getCellNum());
                if (setValue) {
                    boolRec.setValue(this.getBooleanCellValue());
                }
                boolRec.setXFIndex(this.cellStyle.getIndex());
                boolRec.setRow(this.row);
                this.record = boolRec;
                break;
            }
            case 5: {
                BoolErrRecord errRec = null;
                errRec = cellType != this.cellType ? new BoolErrRecord() : (BoolErrRecord)this.record;
                errRec.setColumn(this.getCellNum());
                if (setValue) {
                    errRec.setValue(this.getErrorCellValue());
                }
                errRec.setXFIndex(this.cellStyle.getIndex());
                errRec.setRow(this.row);
                this.record = errRec;
            }
        }
        if (cellType != this.cellType) {
            int loc = this.sheet.getLoc();
            this.sheet.replaceValueRecord(this.record);
            this.sheet.setLoc(loc);
        }
        this.cellType = cellType;
    }

    public void setCellType(int cellType) {
        this.setCellType(cellType, true);
    }

    public void setCellValue(boolean value) {
        if (this.cellType != 4 && this.cellType != 2) {
            this.setCellType(4, false);
        }
        ((BoolErrRecord)this.record).setValue(value);
        this.booleanValue = value;
    }

    public void setCellValue(String value) {
        if (value == null) {
            this.setCellType(3, false);
        } else {
            if (this.cellType != 1 && this.cellType != 2) {
                this.setCellType(1, false);
            }
            int index = 0;
            if (this.encoding == 0) {
                index = this.book.addSSTString(value);
            }
            if (this.encoding == 1) {
                index = this.book.addSSTString(value, true);
            }
            ((LabelSSTRecord)this.record).setSSTIndex(index);
            this.stringValue = value;
        }
    }

    public void setCellValue(Calendar value) {
        this.setCellValue(value.getTime());
    }

    public void setCellValue(Date value) {
        this.setCellValue(HSSFDateUtil.getExcelDate(value));
    }

    public void setCellValue(double value) {
        if (this.cellType != 0 && this.cellType != 2) {
            this.setCellType(0, false);
        }
        ((NumberRecord)this.record).setValue(value);
        this.cellValue = value;
    }

    public void setEncoding(short encoding) {
        this.encoding = encoding;
    }
}

