/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class Ref3DPtg
extends Ptg {
    private static final int SIZE = 7;
    private BitField colRelative;
    private short field_1_index_extern_sheet;
    private short field_2_row;
    private short field_3_column;
    private BitField rowRelative = new BitField(32768);
    public static final byte sid = 58;

    public Ref3DPtg(String cellref, short externIdx) {
        this.colRelative = new BitField(16384);
        CellReference c = new CellReference(cellref);
        this.setRow((short)c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
        this.setExternSheetIndex(externIdx);
    }

    public Ref3DPtg(byte[] data, int offset) {
        this.colRelative = new BitField(16384);
        this.field_1_index_extern_sheet = LittleEndian.getShort(data, 0 + ++offset);
        this.field_2_row = LittleEndian.getShort(data, 2 + offset);
        this.field_3_column = LittleEndian.getShort(data, 4 + offset);
    }

    public Ref3DPtg() {
        this.colRelative = new BitField(16384);
    }

    public Object clone() {
        Ref3DPtg ptg = new Ref3DPtg();
        ptg.field_1_index_extern_sheet = this.field_1_index_extern_sheet;
        ptg.field_2_row = this.field_2_row;
        ptg.field_3_column = this.field_3_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public short getColumn() {
        return (short)(this.field_3_column & 0xFF);
    }

    public short getColumnRaw() {
        return this.field_3_column;
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public short getRow() {
        return this.field_2_row;
    }

    public int getSize() {
        return 7;
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_3_column);
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_3_column);
    }

    public void setArea(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String from = ra.getFromCell();
        this.setColumn((short)(ra.getXPosition(from) - 1));
        this.setRow((short)(ra.getYPosition(from) - 1));
    }

    public void setColRelative(boolean rel) {
        this.field_3_column = this.colRelative.setShortBoolean(this.field_3_column, rel);
    }

    public void setColumn(short column) {
        this.field_3_column = (short)(this.field_3_column & 0xFF00);
        this.field_3_column = (short)(this.field_3_column | column & 0xFF);
    }

    public void setColumnRaw(short column) {
        this.field_3_column = column;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public void setRow(short row) {
        this.field_2_row = row;
    }

    public void setRowRelative(boolean rel) {
        this.field_3_column = this.rowRelative.setShortBoolean(this.field_3_column, rel);
    }

    public String toFormulaString(Workbook book) {
        SheetReferences refs;
        StringBuffer retval = new StringBuffer();
        SheetReferences sheetReferences = refs = book == null ? null : book.getSheetReferences();
        if (refs != null) {
            retval.append(refs.getSheetName(this.field_1_index_extern_sheet));
            retval.append('!');
        }
        retval.append(new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).toString());
        return retval.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ref3dPtg\n");
        buffer.append("Index to Extern Sheet = " + this.getExternSheetIndex()).append("\n");
        buffer.append("Row = " + this.getRow()).append("\n");
        buffer.append("Col  = " + this.getColumn()).append("\n");
        buffer.append("ColRowRel= " + this.isRowRelative()).append("\n");
        buffer.append("ColRel   = " + this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[0 + offset] = (byte)(58 + this.ptgClass);
        LittleEndian.putShort(array, 1 + offset, this.getExternSheetIndex());
        LittleEndian.putShort(array, 3 + offset, this.getRow());
        LittleEndian.putShort(array, 5 + offset, this.getColumnRaw());
    }
}

